/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.hibernate.boot.model.domain.MappedJoin;
import org.hibernate.boot.model.domain.PersistentAttributeMapping;
import org.hibernate.boot.model.relational.MappedTable;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.mapping.AttributeContainer;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.sql.Alias;

public class Join
implements AttributeContainer,
Serializable,
MappedJoin {
    private static final Alias PK_ALIAS = new Alias(15, "PK");
    private TreeMap<String, PersistentAttributeMapping> declaredAttributeMappings;
    private TreeMap<String, PersistentAttributeMapping> attributeMappings;
    private MappedTable table;
    private KeyValue key;
    private PersistentClass persistentClass;
    private boolean sequentialSelect;
    private boolean inverse;
    private boolean optional;
    private String customSQLInsert;
    private boolean customInsertCallable;
    private ExecuteUpdateResultCheckStyle insertCheckStyle;
    private String customSQLUpdate;
    private boolean customUpdateCallable;
    private ExecuteUpdateResultCheckStyle updateCheckStyle;
    private String customSQLDelete;
    private boolean customDeleteCallable;
    private ExecuteUpdateResultCheckStyle deleteCheckStyle;
    private ForeignKey joinMapping;

    @Override
    public void addProperty(Property prop) {
        if (this.attributeMappings == null) {
            this.attributeMappings = new TreeMap();
        }
        if (this.declaredAttributeMappings == null) {
            this.declaredAttributeMappings = new TreeMap();
        }
        this.attributeMappings.putIfAbsent(prop.getName(), prop);
        this.declaredAttributeMappings.putIfAbsent(prop.getName(), prop);
        prop.setPersistentClass(this.getPersistentClass());
    }

    public void addMappedsuperclassProperty(Property prop) {
        if (this.declaredAttributeMappings == null) {
            this.declaredAttributeMappings = new TreeMap();
        }
        this.attributeMappings.put(prop.getName(), prop);
        prop.setPersistentClass(this.getPersistentClass());
    }

    @Deprecated
    public Iterator getDeclaredPropertyIterator() {
        return this.getDeclaredPersistentAttributes().iterator();
    }

    @Deprecated
    public boolean containsProperty(Property prop) {
        return this.containsPersistentAttributeMapping(prop);
    }

    public boolean containsPersistentAttributeMapping(PersistentAttributeMapping attributeMapping) {
        return this.attributeMappings.containsKey(attributeMapping.getName());
    }

    @Deprecated
    public Iterator getPropertyIterator() {
        return this.getPersistentAttributes().iterator();
    }

    @Override
    public List<PersistentAttributeMapping> getPersistentAttributes() {
        return this.attributeMappings == null ? Collections.emptyList() : new ArrayList<PersistentAttributeMapping>(this.attributeMappings.values());
    }

    @Override
    public List<PersistentAttributeMapping> getDeclaredPersistentAttributes() {
        return this.declaredAttributeMappings == null ? Collections.emptyList() : new ArrayList<PersistentAttributeMapping>(this.declaredAttributeMappings.values());
    }

    @Deprecated
    public int getPropertySpan() {
        return this.getPersistentAttributes().size();
    }

    @Deprecated
    public Table getTable() {
        return (Table)this.getMappedTable();
    }

    public void setTable(MappedTable table) {
        this.table = table;
    }

    @Override
    public MappedTable getMappedTable() {
        return this.table;
    }

    public KeyValue getKey() {
        return this.key;
    }

    public void setKey(KeyValue key) {
        this.key = key;
    }

    public PersistentClass getPersistentClass() {
        return this.persistentClass;
    }

    public void setPersistentClass(PersistentClass persistentClass) {
        this.persistentClass = persistentClass;
    }

    public void createForeignKey() {
        this.joinMapping = this.getKey().createForeignKeyOfEntity(this.persistentClass.getEntityName());
    }

    @Override
    public ForeignKey getJoinMapping() {
        return this.joinMapping;
    }

    public void createPrimaryKey() {
        PrimaryKey pk = new PrimaryKey(this.table);
        pk.setName(PK_ALIAS.toAliasString(this.table.getName()));
        this.table.setPrimaryKey(pk);
        pk.addColumns(this.getKey().getMappedColumns());
    }

    public void setCustomSQLInsert(String customSQLInsert, boolean callable, ExecuteUpdateResultCheckStyle checkStyle) {
        this.customSQLInsert = customSQLInsert;
        this.customInsertCallable = callable;
        this.insertCheckStyle = checkStyle;
    }

    public String getCustomSQLInsert() {
        return this.customSQLInsert;
    }

    public boolean isCustomInsertCallable() {
        return this.customInsertCallable;
    }

    public ExecuteUpdateResultCheckStyle getCustomSQLInsertCheckStyle() {
        return this.insertCheckStyle;
    }

    public void setCustomSQLUpdate(String customSQLUpdate, boolean callable, ExecuteUpdateResultCheckStyle checkStyle) {
        this.customSQLUpdate = customSQLUpdate;
        this.customUpdateCallable = callable;
        this.updateCheckStyle = checkStyle;
    }

    public String getCustomSQLUpdate() {
        return this.customSQLUpdate;
    }

    public boolean isCustomUpdateCallable() {
        return this.customUpdateCallable;
    }

    public ExecuteUpdateResultCheckStyle getCustomSQLUpdateCheckStyle() {
        return this.updateCheckStyle;
    }

    public void setCustomSQLDelete(String customSQLDelete, boolean callable, ExecuteUpdateResultCheckStyle checkStyle) {
        this.customSQLDelete = customSQLDelete;
        this.customDeleteCallable = callable;
        this.deleteCheckStyle = checkStyle;
    }

    public String getCustomSQLDelete() {
        return this.customSQLDelete;
    }

    public boolean isCustomDeleteCallable() {
        return this.customDeleteCallable;
    }

    public ExecuteUpdateResultCheckStyle getCustomSQLDeleteCheckStyle() {
        return this.deleteCheckStyle;
    }

    public boolean isSequentialSelect() {
        return this.sequentialSelect;
    }

    public void setSequentialSelect(boolean deferred) {
        this.sequentialSelect = deferred;
    }

    @Override
    public boolean isInverse() {
        return this.inverse;
    }

    public void setInverse(boolean leftJoin) {
        this.inverse = leftJoin;
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.table.toString() + ')';
    }

    public boolean isLazy() {
        Iterator iter = this.getPropertyIterator();
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            if (prop.isLazy()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean nullable) {
        this.optional = nullable;
    }

    @Override
    public ExecuteUpdateResultCheckStyle getUpdateResultCheckStyle() {
        String sql = this.getCustomSQLUpdate();
        boolean callable = sql != null && this.isCustomUpdateCallable();
        ExecuteUpdateResultCheckStyle checkStyle = this.getCustomSQLUpdateCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(sql, callable) : this.getCustomSQLUpdateCheckStyle();
        return checkStyle;
    }
}

