/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.Iterator;
import java.util.Locale;
import org.hibernate.HibernateError;
import org.hibernate.MappingException;
import org.hibernate.boot.model.domain.JavaTypeMapping;
import org.hibernate.boot.model.domain.NotYetResolvedException;
import org.hibernate.boot.model.domain.ResolutionContext;
import org.hibernate.boot.model.relational.MappedColumn;
import org.hibernate.boot.model.relational.MappedTable;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.ValueVisitor;

public class ManyToOne
extends ToOne {
    private ForeignKey foreignKey;
    private boolean ignoreNotFound;
    private boolean isLogicalOneToOne;

    @Deprecated
    public ManyToOne(MetadataBuildingContext metadata, Table table) {
        this(metadata, (MappedTable)table);
    }

    public ManyToOne(MetadataBuildingContext metadata, MappedTable table) {
        super(metadata, table);
        this.registerResolver(metadata);
    }

    private void registerResolver(MetadataBuildingContext metadata) {
        metadata.getMetadataCollector().registerValueMappingResolver(this::resolve);
    }

    @Override
    public Boolean resolve(ResolutionContext context) {
        try {
            this.getJavaTypeMapping().getJavaTypeDescriptor();
        }
        catch (NotYetResolvedException e) {
            return false;
        }
        ForeignKey foreignKey = this.getForeignKey();
        Iterator<MappedColumn> targetColumnItr = foreignKey.getTargetColumns().iterator();
        for (MappedColumn column : foreignKey.getColumns()) {
            assert (targetColumnItr.hasNext());
            MappedColumn targetColumn = targetColumnItr.next();
            if (targetColumn.getJavaTypeMapping() == null) {
                return false;
            }
            column.setJavaTypeMapping(targetColumn.getJavaTypeMapping());
            column.setSqlTypeDescriptorAccess(targetColumn::getSqlTypeDescriptor);
        }
        assert (!targetColumnItr.hasNext());
        return true;
    }

    @Override
    public ForeignKey getForeignKey() {
        if (this.foreignKey == null) {
            throw new MappingException("ManyToOne is not yet resolved - cannot yet access ForeignKey");
        }
        return this.foreignKey;
    }

    @Override
    public ForeignKey createForeignKey() throws MappingException {
        if (this.foreignKey == null && this.referencedPropertyName == null) {
            this.foreignKey = (ForeignKey)this.getMappedTable().createForeignKey(this.getForeignKeyName(), this.getConstraintColumns(), this.getReferencedEntityName(), this.getForeignKeyDefinition(), null);
            if (this.hasFormula() || "none".equals(this.getForeignKeyName())) {
                this.foreignKey.disableCreation();
            }
        }
        return this.foreignKey;
    }

    public ForeignKey createPropertyRefConstraints(ResolutionContext context) {
        if (this.foreignKey != null) {
            return this.foreignKey;
        }
        if (this.referencedPropertyName == null) {
            throw new HibernateError("#createForeignKey should have created ForeignKey, but none was found");
        }
        PersistentClass pc = context.getMetadataBuildingContext().getMetadataCollector().getEntityBinding(this.getReferencedEntityName());
        Property property = pc.getReferencedProperty(this.getReferencedPropertyName());
        if (property == null) {
            throw new MappingException(String.format(Locale.ROOT, "Could not find property `%s` on `%s : cannot create foreign-key (selectable mappings)", this.getReferencedPropertyName(), this.getReferencedEntityName()));
        }
        this.foreignKey = (ForeignKey)this.getMappedTable().createForeignKey(this.getForeignKeyName(), this.getConstraintColumns(), this.getReferencedEntityName(), this.getForeignKeyDefinition(), property.getMappedColumns());
        this.foreignKey.setCascadeDeleteEnabled(this.isCascadeDeleteEnabled());
        if (!this.hasFormula() && !"none".equals(this.getForeignKeyName())) {
            this.foreignKey.disableCreation();
        }
        return this.foreignKey;
    }

    @Override
    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }

    public boolean isIgnoreNotFound() {
        return this.ignoreNotFound;
    }

    public void setIgnoreNotFound(boolean ignoreNotFound) {
        this.ignoreNotFound = ignoreNotFound;
    }

    public void markAsLogicalOneToOne() {
        this.isLogicalOneToOne = true;
    }

    public boolean isLogicalOneToOne() {
        return this.isLogicalOneToOne;
    }

    public JavaTypeMapping getJavaTypeMapping() {
        PersistentClass referencedPersistentClass = this.getMetadataBuildingContext().getMetadataCollector().getEntityBinding(this.getReferencedEntityName());
        return referencedPersistentClass.getJavaTypeMapping();
    }
}

