/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.hibernate.MappingException;
import org.hibernate.boot.model.domain.JavaTypeMapping;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.collection.internal.StandardMapSemantics;
import org.hibernate.collection.internal.StandardOrderedMapSemantics;
import org.hibernate.collection.internal.StandardSortedMapSemantics;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.ValueVisitor;

public class Map
extends IndexedCollection {
    private Collection.CollectionJavaTypeMapping javaTypeMapping;

    public Map(MetadataBuildingContext buildingContext, PersistentClass owner) {
        super(buildingContext, owner);
    }

    @Override
    public boolean isMap() {
        return true;
    }

    @Override
    public void createAllKeys() throws MappingException {
        super.createAllKeys();
        if (!this.isInverse()) {
            this.getIndex().createForeignKey();
        }
    }

    @Override
    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }

    public JavaTypeMapping getJavaTypeMapping() {
        if (this.javaTypeMapping == null) {
            this.javaTypeMapping = this.resolveJavaTypeMapping();
        }
        return this.javaTypeMapping;
    }

    public CollectionSemantics getCollectionSemantics() {
        Comparator comparator = this.getComparator();
        if (comparator != null) {
            return StandardSortedMapSemantics.INSTANCE;
        }
        if (this.hasOrder()) {
            return StandardOrderedMapSemantics.INSTANCE;
        }
        return StandardMapSemantics.INSTANCE;
    }

    private Collection.CollectionJavaTypeMapping resolveJavaTypeMapping() {
        Class javaTypeMappingClass = this.isSorted() ? SortedMap.class : (this.hasOrder() ? TreeMap.class : java.util.Map.class);
        return new Collection.CollectionJavaTypeMapping(this.getMetadataBuildingContext().getBootstrapContext().getTypeConfiguration(), javaTypeMappingClass);
    }
}

