/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.boot.model.domain.MetaAttributeMapping;

public class MetaAttribute
implements MetaAttributeMapping,
Serializable {
    private String name;
    private List<String> values = new ArrayList<String>();

    public MetaAttribute(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List getValues() {
        return Collections.unmodifiableList(this.values);
    }

    @Override
    public void addValue(String value) {
        this.values.add(value);
    }

    @Override
    public String getValue() {
        if (this.values.size() != 1) {
            throw new IllegalStateException("no unique value");
        }
        return this.values.get(0);
    }

    @Override
    public boolean isMultiValued() {
        return this.values.size() > 1;
    }

    public String toString() {
        return "[" + this.name + "=" + this.values + "]";
    }
}

