/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.boot.model.domain.JavaTypeMapping;
import org.hibernate.boot.model.relational.ForeignKeyExporter;
import org.hibernate.boot.model.relational.MappedColumn;
import org.hibernate.boot.model.relational.MappedTable;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.service.ServiceRegistry;

public class OneToMany
implements ForeignKeyExporter,
Value {
    private final MetadataBuildingContext buildingContext;
    private final MappedTable referencingTable;
    private String referencedEntityName;
    private PersistentClass associatedClass;
    private boolean ignoreNotFound;
    private JavaTypeMapping javaTypeMapping;

    public OneToMany(MetadataBuildingContext buildingContext, PersistentClass owner) throws MappingException {
        this.buildingContext = buildingContext;
        this.referencingTable = owner == null ? null : owner.getTable();
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.buildingContext.getBuildingOptions().getServiceRegistry();
    }

    public PersistentClass getAssociatedClass() {
        return this.associatedClass;
    }

    public void setAssociatedClass(PersistentClass associatedClass) {
        this.associatedClass = associatedClass;
    }

    @Override
    public List<MappedColumn> getMappedColumns() {
        return Collections.unmodifiableList(this.associatedClass.getKey().getMappedColumns());
    }

    @Override
    public int getColumnSpan() {
        return this.associatedClass.getKey().getColumnSpan();
    }

    @Override
    public FetchMode getFetchMode() {
        return FetchMode.JOIN;
    }

    @Override
    public MetadataBuildingContext getMetadataBuildingContext() {
        return this.buildingContext;
    }

    @Override
    @Deprecated
    public Table getTable() {
        return (Table)this.referencingTable;
    }

    @Override
    public MappedTable getMappedTable() {
        return this.referencingTable;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean isSimpleValue() {
        return false;
    }

    @Override
    public boolean isAlternateUniqueKey() {
        return false;
    }

    @Override
    public boolean hasFormula() {
        return false;
    }

    @Override
    public boolean isValid() throws MappingException {
        if (this.referencedEntityName == null) {
            throw new MappingException("one to many association must specify the referenced entity");
        }
        return true;
    }

    public String getReferencedEntityName() {
        return this.referencedEntityName;
    }

    public void setReferencedEntityName(String referencedEntityName) {
        this.referencedEntityName = referencedEntityName == null ? null : referencedEntityName.intern();
    }

    @Override
    public void setTypeUsingReflection(String className, String propertyName) {
    }

    @Override
    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }

    @Override
    public boolean isSame(Value other) {
        return this == other || other instanceof OneToMany && this.isSame((OneToMany)other);
    }

    public boolean isSame(OneToMany other) {
        return Objects.equals(this.referencingTable, other.referencingTable) && Objects.equals(this.referencedEntityName, other.referencedEntityName) && Objects.equals(this.associatedClass, other.associatedClass);
    }

    @Override
    public boolean[] getColumnInsertability() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean[] getColumnUpdateability() {
        throw new UnsupportedOperationException();
    }

    public boolean isIgnoreNotFound() {
        return this.ignoreNotFound;
    }

    public void setIgnoreNotFound(boolean ignoreNotFound) {
        this.ignoreNotFound = ignoreNotFound;
    }

    @Override
    public JavaTypeMapping getJavaTypeMapping() {
        return this.javaTypeMapping;
    }

    public void setJavaTypeMapping(JavaTypeMapping javaTypeMapping) {
        this.javaTypeMapping = javaTypeMapping;
    }
}

