/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.hibernate.MappingException;
import org.hibernate.boot.model.domain.JavaTypeMapping;
import org.hibernate.boot.model.domain.ResolutionContext;
import org.hibernate.boot.model.relational.MappedColumn;
import org.hibernate.boot.model.relational.MappedTable;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.type.ForeignKeyDirection;

public class OneToOne
extends ToOne {
    private boolean constrained;
    private ForeignKeyDirection foreignKeyType;
    private KeyValue identifier;
    private String propertyName;
    private String entityName;
    private ForeignKey foreignKey;

    @Deprecated
    public OneToOne(MetadataBuildingContext metadata, Table table, PersistentClass owner) throws MappingException {
        this(metadata, (MappedTable)table, owner);
    }

    public OneToOne(MetadataBuildingContext metadata, MappedTable table, PersistentClass owner) throws MappingException {
        super(metadata, table);
        this.identifier = owner.getKey();
        this.entityName = owner.getEntityName();
        this.registerResolver(metadata);
    }

    private void registerResolver(MetadataBuildingContext metadata) {
        metadata.getMetadataCollector().registerValueMappingResolver(this::resolve);
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName == null ? null : propertyName.intern();
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String propertyName) {
        this.entityName = this.entityName == null ? null : this.entityName.intern();
    }

    @Override
    public ForeignKey getForeignKey() {
        return this.foreignKey;
    }

    @Override
    public ForeignKey createForeignKey() throws MappingException {
        if (this.constrained) {
            this.foreignKey = this.createForeignKeyOfEntity(this.getReferencedEntityName());
            if (this.referencedPropertyName == null) {
                this.foreignKey.disableCreation();
            }
        }
        return this.foreignKey;
    }

    @Override
    public Boolean resolve(ResolutionContext context) {
        this.getJavaTypeMapping().getJavaTypeDescriptor();
        ForeignKey foreignKey = this.getForeignKey();
        if (foreignKey == null) {
            return true;
        }
        Iterator<MappedColumn> targetColumnItr = foreignKey.getTargetColumns().iterator();
        for (MappedColumn column : foreignKey.getColumns()) {
            assert (targetColumnItr.hasNext());
            MappedColumn targetColumn = targetColumnItr.next();
            if (targetColumn.getJavaTypeMapping() == null) {
                return false;
            }
            column.setJavaTypeMapping(targetColumn.getJavaTypeMapping());
            column.setSqlTypeDescriptorAccess(targetColumn::getSqlTypeDescriptor);
        }
        assert (!targetColumnItr.hasNext());
        return true;
    }

    @Override
    public List<MappedColumn> getConstraintColumns() {
        ArrayList<MappedColumn> list = new ArrayList<MappedColumn>();
        this.identifier.getMappedColumns().forEach(o -> list.add((MappedColumn)o));
        return list;
    }

    public boolean isConstrained() {
        return this.constrained;
    }

    public ForeignKeyDirection getForeignKeyType() {
        return this.foreignKeyType;
    }

    public KeyValue getIdentifier() {
        return this.identifier;
    }

    public void setConstrained(boolean constrained) {
        this.constrained = constrained;
    }

    public void setForeignKeyType(ForeignKeyDirection foreignKeyType) {
        this.foreignKeyType = foreignKeyType;
    }

    public void setIdentifier(KeyValue identifier) {
        this.identifier = identifier;
    }

    @Override
    public boolean isNullable() {
        return !this.constrained;
    }

    @Override
    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }

    @Override
    public boolean isSame(ToOne other) {
        return other instanceof OneToOne && this.isSame((OneToOne)other);
    }

    public boolean isSame(OneToOne other) {
        return super.isSame(other) && Objects.equals((Object)this.foreignKeyType, (Object)other.foreignKeyType) && OneToOne.isSame(this.identifier, other.identifier) && Objects.equals(this.propertyName, other.propertyName) && Objects.equals(this.entityName, other.entityName) && this.constrained == other.constrained;
    }

    public JavaTypeMapping getJavaTypeMapping() {
        PersistentClass referencedPersistentClass = this.getMetadataBuildingContext().getMetadataCollector().getEntityBinding(this.getReferencedEntityName());
        if (this.referenceToPrimaryKey || this.referencedPropertyName == null) {
            return referencedPersistentClass.getIdentifier().getJavaTypeMapping();
        }
        return referencedPersistentClass.getReferencedProperty(this.getReferencedPropertyName()).getValue().getJavaTypeMapping();
    }
}

