/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.hibernate.MappingException;
import org.hibernate.boot.model.domain.EmbeddedValueMapping;
import org.hibernate.boot.model.domain.EntityJavaTypeMapping;
import org.hibernate.boot.model.domain.EntityMappingHierarchy;
import org.hibernate.boot.model.domain.IdentifiableTypeMapping;
import org.hibernate.boot.model.domain.MappedJoin;
import org.hibernate.boot.model.domain.internal.AbstractIdentifiableTypeMapping;
import org.hibernate.boot.model.domain.spi.EntityMappingImplementor;
import org.hibernate.boot.model.relational.MappedColumn;
import org.hibernate.boot.model.relational.MappedTable;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.internal.FilterConfiguration;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.JoinedIterator;
import org.hibernate.internal.util.collections.SingletonIterator;
import org.hibernate.mapping.AttributeContainer;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Filterable;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.MetaAttributable;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.PersistentClassVisitor;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.PropertyContainer;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.RepresentationMode;
import org.hibernate.metamodel.model.domain.spi.IdentifiableTypeDescriptor;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.Alias;

public abstract class PersistentClass
extends AbstractIdentifiableTypeMapping
implements EntityMappingImplementor,
AttributeContainer,
Serializable,
Filterable,
MetaAttributable,
PropertyContainer {
    private static final Alias PK_ALIAS = new Alias(15, "PK");
    public static final String NULL_DISCRIMINATOR_MAPPING = "null";
    public static final String NOT_NULL_DISCRIMINATOR_MAPPING = "not null";
    private final MetadataBuildingContext metadataBuildingContext;
    private String entityName;
    private String className;
    private transient Class mappedClass;
    private String proxyInterfaceName;
    private transient Class proxyInterface;
    private String jpaEntityName;
    private String discriminatorValue;
    private boolean lazy;
    private ArrayList<Property> properties = new ArrayList();
    private final ArrayList<Property> subclassProperties = new ArrayList();
    private final ArrayList<MappedTable> subclassTables = new ArrayList();
    private boolean dynamicInsert;
    private boolean dynamicUpdate;
    private int batchSize = -1;
    private boolean selectBeforeUpdate;
    private Map metaAttributes;
    private ArrayList<Join> joins = new ArrayList();
    private final ArrayList<Join> subclassJoins = new ArrayList();
    private final ArrayList<FilterConfiguration> filters = new ArrayList();
    protected final HashSet<String> synchronizedTables = new HashSet();
    private String loaderName;
    private Boolean isAbstract;
    private boolean hasSubselectLoadableCollections;
    private String customSQLInsert;
    private boolean customInsertCallable;
    private ExecuteUpdateResultCheckStyle insertCheckStyle;
    private String customSQLUpdate;
    private boolean customUpdateCallable;
    private ExecuteUpdateResultCheckStyle updateCheckStyle;
    private String customSQLDelete;
    private boolean customDeleteCallable;
    private ExecuteUpdateResultCheckStyle deleteCheckStyle;
    private MappedSuperclass superMappedSuperclass;
    private EmbeddedValueMapping declaredIdentifierValueMapping;
    private boolean isCached;

    public PersistentClass(MetadataBuildingContext metadataBuildingContext, EntityMappingHierarchy entityMappingHierarchy) {
        super(entityMappingHierarchy);
        this.metadataBuildingContext = metadataBuildingContext;
    }

    @Override
    public EntityJavaTypeMapping getJavaTypeMapping() {
        return (EntityJavaTypeMapping)super.getJavaTypeMapping();
    }

    public ServiceRegistry getServiceRegistry() {
        return this.metadataBuildingContext.getBuildingOptions().getServiceRegistry();
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className == null ? null : className.intern();
        this.mappedClass = null;
        this.getEntityMappingHierarchy().setExplicitRepresentationMode(this.className == null ? RepresentationMode.MAP : RepresentationMode.POJO);
    }

    @Override
    public String getName() {
        return this.entityName;
    }

    public String getProxyInterfaceName() {
        return this.proxyInterfaceName;
    }

    public void setProxyInterfaceName(String proxyInterfaceName) {
        this.proxyInterfaceName = proxyInterfaceName;
        this.proxyInterface = null;
    }

    @Override
    public Class getMappedClass() throws MappingException {
        if (this.className == null) {
            return null;
        }
        try {
            if (this.mappedClass == null) {
                this.mappedClass = this.metadataBuildingContext.getBootstrapContext().getClassLoaderAccess().classForName(this.className);
            }
            return this.mappedClass;
        }
        catch (ClassLoadingException e) {
            throw new MappingException("entity class not found: " + this.className, (Throwable)((Object)e));
        }
    }

    @Override
    public Class getProxyInterface() {
        if (this.proxyInterfaceName == null) {
            return null;
        }
        try {
            if (this.proxyInterface == null) {
                this.proxyInterface = this.metadataBuildingContext.getBootstrapContext().getClassLoaderAccess().classForName(this.proxyInterfaceName);
            }
            return this.proxyInterface;
        }
        catch (ClassLoadingException e) {
            throw new MappingException("proxy class not found: " + this.proxyInterfaceName, (Throwable)((Object)e));
        }
    }

    public boolean useDynamicInsert() {
        return this.dynamicInsert;
    }

    public abstract int getSubclassId();

    public boolean useDynamicUpdate() {
        return this.dynamicUpdate;
    }

    public void setDynamicInsert(boolean dynamicInsert) {
        this.dynamicInsert = dynamicInsert;
    }

    public void setDynamicUpdate(boolean dynamicUpdate) {
        this.dynamicUpdate = dynamicUpdate;
    }

    @Override
    public String getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    public void addSubclass(Subclass subclass) throws MappingException {
        subclass.injectSuperclassMapping(this);
    }

    @Deprecated
    public boolean hasSubclasses() {
        return !this.getSubTypeMappings().isEmpty();
    }

    public int getSubclassSpan() {
        int n = this.getSubTypeMappings().size();
        for (IdentifiableTypeMapping subclass : this.getSubTypeMappings()) {
            n += subclass.getSubTypeMappings().size();
        }
        return n;
    }

    public Iterator getSubclassIterator() {
        Iterator[] iters = new Iterator[this.getSubTypeMappings().size() + 1];
        Iterator<IdentifiableTypeMapping> iter = this.getSubTypeMappings().iterator();
        int i = 0;
        while (iter.hasNext()) {
            iters[i++] = ((Subclass)iter.next()).getSubclassIterator();
        }
        iters[i] = this.getSubTypeMappings().iterator();
        return new JoinedIterator(iters);
    }

    public Iterator getSubclassClosureIterator() {
        ArrayList iters = new ArrayList();
        iters.add(new SingletonIterator<PersistentClass>(this));
        Iterator iter = this.getSubclassIterator();
        while (iter.hasNext()) {
            PersistentClass clazz = (PersistentClass)iter.next();
            iters.add(clazz.getSubclassClosureIterator());
        }
        return new JoinedIterator(iters);
    }

    public MappedTable getIdentityTable() {
        return this.getRootTable();
    }

    @Deprecated
    public Iterator getDirectSubclasses() {
        return this.getSubTypeMappings().iterator();
    }

    @Override
    public void addProperty(Property p) {
        this.properties.add(p);
        this.addDeclaredPersistentAttribute(p);
        p.setPersistentClass(this);
    }

    @Deprecated
    public abstract Table getTable();

    @Override
    public MappedTable getMappedTable() {
        return this.getTable();
    }

    @Override
    public String getEntityName() {
        return this.entityName;
    }

    public abstract boolean isMutable();

    @Deprecated
    public abstract boolean hasIdentifierProperty();

    @Deprecated
    public abstract Property getIdentifierProperty();

    @Deprecated
    public abstract Property getDeclaredIdentifierProperty();

    public abstract KeyValue getIdentifier();

    @Deprecated
    public abstract Property getVersion();

    @Deprecated
    public abstract Property getDeclaredVersion();

    @Deprecated
    public abstract Value getDiscriminator();

    public abstract boolean isInherited();

    public abstract boolean isPolymorphic();

    @Deprecated
    public abstract boolean isVersioned();

    public boolean isCached() {
        return this.isCached;
    }

    public void setCached(boolean cached) {
        this.isCached = cached;
    }

    @Deprecated
    public boolean isCachingExplicitlyRequested() {
        return this.isCached();
    }

    @Deprecated
    public void setCachingExplicitlyRequested(boolean cached) {
        this.setCached(cached);
    }

    public abstract String getCacheConcurrencyStrategy();

    public abstract String getNaturalIdCacheRegionName();

    public abstract PersistentClass getSuperclass();

    public abstract boolean isExplicitPolymorphism();

    public abstract boolean isDiscriminatorInsertable();

    public abstract Iterator getPropertyClosureIterator();

    public abstract Iterator getTableClosureIterator();

    public abstract Iterator getKeyClosureIterator();

    protected void addSubclassProperty(Property prop) {
        this.subclassProperties.add(prop);
    }

    protected void addSubclassJoin(Join join) {
        this.subclassJoins.add(join);
    }

    protected void addSubclassTable(MappedTable subclassTable) {
        this.subclassTables.add(subclassTable);
    }

    public Iterator getSubclassPropertyClosureIterator() {
        ArrayList iters = new ArrayList();
        iters.add(this.getPropertyClosureIterator());
        iters.add(this.subclassProperties.iterator());
        for (int i = 0; i < this.subclassJoins.size(); ++i) {
            Join join = this.subclassJoins.get(i);
            iters.add(join.getPropertyIterator());
        }
        return new JoinedIterator(iters);
    }

    public Iterator getSubclassJoinClosureIterator() {
        return new JoinedIterator(this.getJoinClosureIterator(), this.subclassJoins.iterator());
    }

    public Iterator getSubclassTableClosureIterator() {
        return new JoinedIterator(this.getTableClosureIterator(), this.subclassTables.iterator());
    }

    public boolean isClassOrSuperclassJoin(Join join) {
        return this.joins.contains(join);
    }

    public boolean isClassOrSuperclassTable(Table closureTable) {
        return this.getTable() == closureTable;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    @Deprecated
    public abstract boolean hasEmbeddedIdentifier();

    @Override
    public abstract Table getRootTable();

    public Collection<Join> getJoins() {
        return this.joins;
    }

    @Override
    public Collection<MappedJoin> getMappedJoins() {
        Collection<Join> joins = this.getJoins();
        if (joins.size() <= 0) {
            return Collections.emptyList();
        }
        if (this.getJoinClosureSpan() == 1) {
            return Collections.singletonList(joins.iterator().next());
        }
        return new ArrayList<MappedJoin>(joins);
    }

    public abstract RootClass getRootClass();

    public abstract KeyValue getKey();

    public void setDiscriminatorValue(String discriminatorValue) {
        this.discriminatorValue = discriminatorValue;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName == null ? null : entityName.intern();
    }

    public void createPrimaryKey() {
        MappedTable table = this.getMappedTable();
        PrimaryKey pk = new PrimaryKey(table);
        pk.setName(PK_ALIAS.toAliasString(table.getName()));
        table.setPrimaryKey(pk);
        pk.addColumns(this.getKey().getMappedColumns());
    }

    public abstract String getWhere();

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public boolean hasSelectBeforeUpdate() {
        return this.selectBeforeUpdate;
    }

    public void setSelectBeforeUpdate(boolean selectBeforeUpdate) {
        this.selectBeforeUpdate = selectBeforeUpdate;
    }

    public Iterator getReferenceablePropertyIterator() {
        return this.getPropertyClosureIterator();
    }

    public Property getReferencedProperty(String propertyPath) throws MappingException {
        try {
            return this.getRecursiveProperty(propertyPath, this.getReferenceablePropertyIterator());
        }
        catch (MappingException e) {
            throw new MappingException("property-ref [" + propertyPath + "] not found on entity [" + this.getEntityName() + "]", (Throwable)((Object)e));
        }
    }

    public Property getRecursiveProperty(String propertyPath) throws MappingException {
        try {
            return this.getRecursiveProperty(propertyPath, this.getPropertyClosureIterator());
        }
        catch (MappingException e) {
            throw new MappingException("property [" + propertyPath + "] not found on entity [" + this.getEntityName() + "]", (Throwable)((Object)e));
        }
    }

    private Property getRecursiveProperty(String propertyPath, Iterator iter) throws MappingException {
        Property property = null;
        StringTokenizer st = new StringTokenizer(propertyPath, ".", false);
        try {
            while (st.hasMoreElements()) {
                String element = (String)st.nextElement();
                if (property == null) {
                    Property identifierProperty = this.getIdentifierProperty();
                    if (identifierProperty != null && identifierProperty.getName().equals(element)) {
                        property = identifierProperty;
                    } else if (identifierProperty == null && this.getIdentifierMapper() != null) {
                        try {
                            identifierProperty = this.getProperty(element, this.getIdentifierMapper().getPropertyIterator());
                            if (identifierProperty != null) {
                                property = identifierProperty;
                            }
                        }
                        catch (MappingException mappingException) {
                            // empty catch block
                        }
                    }
                    if (property != null) continue;
                    property = this.getProperty(element, iter);
                    continue;
                }
                property = ((Component)property.getValue()).getProperty(element);
            }
        }
        catch (MappingException e) {
            throw new MappingException("property [" + propertyPath + "] not found on entity [" + this.getEntityName() + "]");
        }
        return property;
    }

    private Property getProperty(String propertyName, Iterator iterator) throws MappingException {
        if (iterator.hasNext()) {
            String root = StringHelper.root(propertyName);
            while (iterator.hasNext()) {
                Property prop = (Property)iterator.next();
                if (!prop.getName().equals(root)) continue;
                return prop;
            }
        }
        throw new MappingException("property [" + propertyName + "] not found on entity [" + this.getEntityName() + "]");
    }

    public Property getProperty(String propertyName) throws MappingException {
        Iterator iter = this.getPropertyClosureIterator();
        Property identifierProperty = (Property)this.getIdentifierAttributeMapping();
        if (identifierProperty != null && identifierProperty.getName().equals(StringHelper.root(propertyName))) {
            return identifierProperty;
        }
        return this.getProperty(propertyName, iter);
    }

    public boolean hasProperty(String name) {
        Property identifierProperty = this.getIdentifierProperty();
        if (identifierProperty != null && identifierProperty.getName().equals(name)) {
            return true;
        }
        Iterator itr = this.getPropertyClosureIterator();
        while (itr.hasNext()) {
            Property property = (Property)itr.next();
            if (!property.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isPropertyDefinedInSuperHierarchy(String name) {
        return this.getSuperclass() != null && this.getSuperclass().isPropertyDefinedInHierarchy(name);
    }

    public boolean isPropertyDefinedInHierarchy(String name) {
        if (this.hasProperty(name)) {
            return true;
        }
        if (this.getSuperMappedSuperclass() != null && this.getSuperMappedSuperclass().isPropertyDefinedInHierarchy(name)) {
            return true;
        }
        return this.getSuperclass() != null && this.getSuperclass().isPropertyDefinedInHierarchy(name);
    }

    @Deprecated
    public int getOptimisticLockMode() {
        return this.getOptimisticLockStyle().getOldCode();
    }

    @Deprecated
    public void setOptimisticLockMode(int optimisticLockMode) {
        this.setOptimisticLockStyle(OptimisticLockStyle.interpretOldCode(optimisticLockMode));
    }

    @Deprecated
    public OptimisticLockStyle getOptimisticLockStyle() {
        return this.getEntityMappingHierarchy().getOptimisticLockStyle();
    }

    @Deprecated
    public void setOptimisticLockStyle(OptimisticLockStyle optimisticLockStyle) {
        this.getEntityMappingHierarchy().setOptimisticLockStyle(optimisticLockStyle);
    }

    @Override
    public void validate() throws MappingException {
        Iterator iter = this.getPropertyIterator();
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            if (prop.isValid()) continue;
            throw new MappingException("property mapping has wrong number of columns: " + StringHelper.qualify(this.getEntityName(), prop.getName()) + " type: " + prop.getValueMapping().getJavaTypeMapping().getTypeName());
        }
        this.checkPropertyDuplication();
        this.checkColumnDuplication();
    }

    private void checkPropertyDuplication() throws MappingException {
        HashSet<String> names = new HashSet<String>();
        Iterator iter = this.getPropertyIterator();
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            if (names.add(prop.getName())) continue;
            throw new MappingException("Duplicate property mapping of " + prop.getName() + " found in " + this.getEntityName());
        }
    }

    public boolean isDiscriminatorValueNotNull() {
        return NOT_NULL_DISCRIMINATOR_MAPPING.equals(this.getDiscriminatorValue());
    }

    public boolean isDiscriminatorValueNull() {
        return NULL_DISCRIMINATOR_MAPPING.equals(this.getDiscriminatorValue());
    }

    @Override
    public Map getMetaAttributes() {
        return this.metaAttributes;
    }

    @Override
    public void setMetaAttributes(Map metas) {
        this.metaAttributes = metas;
    }

    @Override
    public MetaAttribute getMetaAttribute(String name) {
        return this.metaAttributes == null ? null : (MetaAttribute)this.metaAttributes.get(name);
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.getEntityName() + ')';
    }

    @Deprecated
    public Iterator getJoinIterator() {
        return this.joins.iterator();
    }

    public Iterator getJoinClosureIterator() {
        return this.joins.iterator();
    }

    public void addJoin(Join join) {
        this.joins.add(join);
        join.setPersistentClass(this);
    }

    public int getJoinClosureSpan() {
        return this.joins.size();
    }

    public int getPropertyClosureSpan() {
        int span = this.properties.size();
        for (Join join : this.joins) {
            span += join.getPropertySpan();
        }
        return span;
    }

    public int getJoinNumber(Property prop) {
        int result = 1;
        Iterator iter = this.getSubclassJoinClosureIterator();
        while (iter.hasNext()) {
            Join join = (Join)iter.next();
            if (join.containsPersistentAttributeMapping(prop)) {
                return result;
            }
            ++result;
        }
        return 0;
    }

    public Iterator getPropertyIterator() {
        ArrayList iterators = new ArrayList();
        iterators.add(this.properties.iterator());
        for (int i = 0; i < this.joins.size(); ++i) {
            Join join = this.joins.get(i);
            iterators.add(join.getPropertyIterator());
        }
        return new JoinedIterator(iterators);
    }

    public Iterator getUnjoinedPropertyIterator() {
        return this.properties.iterator();
    }

    public void setCustomSQLInsert(String customSQLInsert, boolean callable, ExecuteUpdateResultCheckStyle checkStyle) {
        this.customSQLInsert = customSQLInsert;
        this.customInsertCallable = callable;
        this.insertCheckStyle = checkStyle;
    }

    public String getCustomSQLInsert() {
        return this.customSQLInsert;
    }

    public boolean isCustomInsertCallable() {
        return this.customInsertCallable;
    }

    public ExecuteUpdateResultCheckStyle getCustomSQLInsertCheckStyle() {
        return this.insertCheckStyle;
    }

    public void setCustomSQLUpdate(String customSQLUpdate, boolean callable, ExecuteUpdateResultCheckStyle checkStyle) {
        this.customSQLUpdate = customSQLUpdate;
        this.customUpdateCallable = callable;
        this.updateCheckStyle = checkStyle;
    }

    public String getCustomSQLUpdate() {
        return this.customSQLUpdate;
    }

    public boolean isCustomUpdateCallable() {
        return this.customUpdateCallable;
    }

    public ExecuteUpdateResultCheckStyle getCustomSQLUpdateCheckStyle() {
        return this.updateCheckStyle;
    }

    public void setCustomSQLDelete(String customSQLDelete, boolean callable, ExecuteUpdateResultCheckStyle checkStyle) {
        this.customSQLDelete = customSQLDelete;
        this.customDeleteCallable = callable;
        this.deleteCheckStyle = checkStyle;
    }

    public String getCustomSQLDelete() {
        return this.customSQLDelete;
    }

    public boolean isCustomDeleteCallable() {
        return this.customDeleteCallable;
    }

    public ExecuteUpdateResultCheckStyle getCustomSQLDeleteCheckStyle() {
        return this.deleteCheckStyle;
    }

    @Override
    public void addFilter(String name, String condition, boolean autoAliasInjection, Map<String, String> aliasTableMap, Map<String, String> aliasEntityMap) {
        this.filters.add(new FilterConfiguration(name, condition, autoAliasInjection, aliasTableMap, aliasEntityMap, this));
    }

    public List getFilters() {
        return this.filters;
    }

    public boolean isForceDiscriminator() {
        return false;
    }

    public abstract boolean isJoinedSubclass();

    public String getLoaderName() {
        return this.loaderName;
    }

    public void setLoaderName(String loaderName) {
        this.loaderName = loaderName == null ? null : loaderName.intern();
    }

    public abstract Set getSynchronizedTables();

    public void addSynchronizedTable(String table) {
        this.synchronizedTables.add(table);
    }

    public Boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(Boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    @Deprecated
    protected void checkColumnDuplication(Set distinctColumns, Iterator columns) throws MappingException {
        while (columns.hasNext()) {
            Column col;
            Selectable columnOrFormula = (Selectable)columns.next();
            if (columnOrFormula.isFormula() || distinctColumns.add((col = (Column)columnOrFormula).getName())) continue;
            throw new MappingException("Repeated column in mapping for entity: " + this.getEntityName() + " column: " + col.getName() + " (should be mapped with insert=\"false\" update=\"false\")");
        }
    }

    protected void checkColumnDuplication(Set distinctColumns, List<MappedColumn> columns) throws MappingException {
        columns.stream().filter(column -> !column.isFormula()).map(Column.class::cast).forEach(column -> {
            if (!distinctColumns.add(column.getName())) {
                throw new MappingException("Repeated column in mapping for entity: " + this.getEntityName() + " column: " + column.getName() + " (should be mapped with insert=\"false\" update=\"false\")");
            }
        });
    }

    protected void checkPropertyColumnDuplication(Set distinctColumns, Iterator properties) throws MappingException {
        while (properties.hasNext()) {
            Property prop = (Property)properties.next();
            if (prop.getValue() instanceof Component) {
                Component component = (Component)prop.getValue();
                this.checkPropertyColumnDuplication(distinctColumns, component.getPropertyIterator());
                continue;
            }
            if (!prop.isUpdateable() && !prop.isInsertable()) continue;
            this.checkColumnDuplication(distinctColumns, prop.getMappedColumns());
        }
    }

    protected Iterator getNonDuplicatedPropertyIterator() {
        return this.getUnjoinedPropertyIterator();
    }

    protected List<MappedColumn> getDiscriminatorColumns() {
        return Collections.emptyList();
    }

    protected void checkColumnDuplication() {
        HashSet cols = new HashSet();
        if (this.getEntityMappingHierarchy().getIdentifierEmbeddedValueMapping() == null) {
            this.checkColumnDuplication(cols, this.getKey().getMappedColumns());
        }
        this.checkColumnDuplication(cols, this.getDiscriminatorColumns());
        this.checkPropertyColumnDuplication(cols, this.getNonDuplicatedPropertyIterator());
        this.joins.forEach(join -> {
            cols.clear();
            this.checkColumnDuplication((Set)cols, join.getKey().getMappedColumns());
            this.checkPropertyColumnDuplication(cols, join.getPropertyIterator());
        });
    }

    public abstract Object accept(PersistentClassVisitor var1);

    @Override
    public String getJpaEntityName() {
        return this.jpaEntityName;
    }

    public void setJpaEntityName(String jpaEntityName) {
        this.jpaEntityName = jpaEntityName;
    }

    public boolean hasSubselectLoadableCollections() {
        return this.hasSubselectLoadableCollections;
    }

    public void setSubselectLoadableCollections(boolean hasSubselectCollections) {
        this.hasSubselectLoadableCollections = hasSubselectCollections;
    }

    @Deprecated
    public Component getIdentifierMapper() {
        return (Component)this.getEntityMappingHierarchy().getIdentifierEmbeddedValueMapping();
    }

    @Deprecated
    public Component getDeclaredIdentifierMapper() {
        return (Component)this.declaredIdentifierValueMapping;
    }

    public void setDeclaredIdentifierMapper(Component declaredIdentifierMapper) {
        this.declaredIdentifierValueMapping = declaredIdentifierMapper;
        this.getEntityMappingHierarchy().setIdentifierEmbeddedValueMapping(declaredIdentifierMapper);
    }

    @Deprecated
    public boolean hasIdentifierMapper() {
        return this.getEntityMappingHierarchy().hasIdentifierMapper();
    }

    @Deprecated
    public void setIdentifierMapper(Component handle) {
        this.getEntityMappingHierarchy().setIdentifierEmbeddedValueMapping(handle);
    }

    public boolean hasNaturalId() {
        Iterator props = this.getRootClass().getPropertyIterator();
        while (props.hasNext()) {
            if (!((Property)props.next()).isNaturalIdentifier()) continue;
            return true;
        }
        return false;
    }

    public Iterator getDeclaredPropertyIterator() {
        ArrayList iterators = new ArrayList();
        iterators.add(this.getDeclaredProperties().iterator());
        for (int i = 0; i < this.joins.size(); ++i) {
            Join join = this.joins.get(i);
            iterators.add(join.getDeclaredPropertyIterator());
        }
        return new JoinedIterator(iterators);
    }

    @Override
    public List<Property> getDeclaredProperties() {
        return this.getDeclaredPersistentAttributes().stream().map(p -> (Property)p).collect(Collectors.toList());
    }

    @Override
    public PropertyContainer getSuperPropertyContainer() {
        return this.superMappedSuperclass;
    }

    public void addMappedsuperclassProperty(Property p) {
        this.properties.add(p);
        p.setPersistentClass(this);
    }

    public MappedSuperclass getSuperMappedSuperclass() {
        return this.superMappedSuperclass;
    }

    public void setSuperMappedSuperclass(MappedSuperclass superMappedSuperclass) {
        this.superMappedSuperclass = superMappedSuperclass;
    }

    @Override
    public RepresentationMode getExplicitRepresentationMode() {
        return this.getEntityMappingHierarchy().getExplicitRepresentationMode();
    }

    @Override
    public <X> IdentifiableTypeDescriptor<X> makeRuntimeDescriptor(IdentifiableTypeDescriptor superTypeDescriptor, RuntimeModelCreationContext creationContext) {
        return creationContext.getRuntimeModelDescriptorFactory().createEntityDescriptor(this, superTypeDescriptor, creationContext);
    }

    @Override
    public boolean hasProxy() {
        return this.isLazy() && (!this.getExplicitRepresentationMode().equals((Object)RepresentationMode.POJO) || this.getProxyInterface() != null && !ReflectHelper.isFinalClass(this.getProxyInterface()));
    }

    @Override
    public ExecuteUpdateResultCheckStyle getUpdateResultCheckStyle() {
        String sql = this.getCustomSQLUpdate();
        boolean callable = sql != null && this.isCustomUpdateCallable();
        ExecuteUpdateResultCheckStyle checkStyle = this.getCustomSQLUpdateCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(sql, callable) : this.getCustomSQLUpdateCheckStyle();
        return checkStyle;
    }
}

