/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.Set;
import org.hibernate.boot.model.relational.MappedColumn;
import org.hibernate.boot.model.relational.MappedPrimaryKey;
import org.hibernate.boot.model.relational.MappedTable;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Constraint;
import org.jboss.logging.Logger;

public class PrimaryKey
extends Constraint
implements MappedPrimaryKey {
    private static final Logger log = Logger.getLogger(PrimaryKey.class);

    public PrimaryKey(MappedTable table) {
        this.setTable(table);
    }

    @Override
    public void addColumn(Column column) {
        this.addColumn((MappedColumn)column);
    }

    @Override
    public void addColumn(MappedColumn column) {
        Set columns = this.getMappedTable().getMappedColumns();
        columns.stream().filter(c -> c.getText().equals(column.getText())).forEach(c -> {
            ((Column)c).setNullable(false);
            log.debugf("Forcing column [%s] to be non-null as it is part of the primary key for table [%s]", (Object)column.getText(), (Object)this.getTableNameForLogging(column));
        });
        super.addColumn(column);
    }

    protected String getTableNameForLogging(MappedColumn mappedColumn) {
        Column column;
        if (this.getMappedTable() != null) {
            if (this.getMappedTable().getNameIdentifier() != null) {
                return this.getMappedTable().getNameIdentifier().getCanonicalName();
            }
            return "<unknown>";
        }
        if (mappedColumn instanceof Column && (column = (Column)mappedColumn).getTableName() != null) {
            return column.getTableName().getCanonicalName();
        }
        return "<unknown>";
    }

    @Override
    public String generatedConstraintNamePrefix() {
        return "PK_";
    }
}

