/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.util.Comparator;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.boot.model.domain.BasicValueMapping;
import org.hibernate.boot.model.domain.EntityMapping;
import org.hibernate.boot.model.domain.ManagedTypeMapping;
import org.hibernate.boot.model.domain.PersistentAttributeMapping;
import org.hibernate.boot.model.domain.ValueMapping;
import org.hibernate.boot.model.relational.MappedColumn;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.collection.internal.StandardArraySemantics;
import org.hibernate.collection.internal.StandardBagSemantics;
import org.hibernate.collection.internal.StandardIdentifierBagSemantics;
import org.hibernate.collection.internal.StandardListSemantics;
import org.hibernate.collection.internal.StandardMapSemantics;
import org.hibernate.collection.internal.StandardOrderedMapSemantics;
import org.hibernate.collection.internal.StandardOrderedSetSemantics;
import org.hibernate.collection.internal.StandardSetSemantics;
import org.hibernate.collection.internal.StandardSortedMapSemantics;
import org.hibernate.collection.internal.StandardSortedSetSemantics;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.Array;
import org.hibernate.mapping.Bag;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.IdentifierBag;
import org.hibernate.mapping.List;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Set;
import org.hibernate.mapping.SyntheticProperty;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.internal.SingularPersistentAttributeBasic;
import org.hibernate.metamodel.model.domain.internal.SingularPersistentAttributeEmbedded;
import org.hibernate.metamodel.model.domain.internal.SingularPersistentAttributeEntity;
import org.hibernate.metamodel.model.domain.spi.ManagedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.PersistentAttributeDescriptor;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.domain.spi.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.SingularPersistentAttribute;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.property.access.spi.PropertyAccessStrategyResolver;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tuple.ValueGeneration;

public class Property
implements Serializable,
PersistentAttributeMapping {
    private final MetadataBuildingContext context;
    private String name;
    private Value value;
    private String cascade;
    private boolean updateable = true;
    private boolean insertable = true;
    private boolean selectable = true;
    private boolean optimisticLocked = true;
    private ValueGeneration valueGenerationStrategy;
    private String propertyAccessorName;
    private boolean lazy;
    private String lazyGroup;
    private boolean optional;
    private java.util.Map metaAttributes;
    private PersistentClass persistentClass;
    private boolean naturalIdentifier;
    private boolean lob;
    private String mappedBy;

    @Override
    public String getMappedBy() {
        return this.mappedBy;
    }

    public void setMappedBy(String mappedBy) {
        this.mappedBy = mappedBy;
    }

    public Property(MetadataBuildingContext context) {
        this.context = context;
    }

    @Override
    public ValueMapping getValueMapping() {
        return this.value;
    }

    @Override
    public boolean isBackRef() {
        return false;
    }

    public boolean isSynthetic() {
        return false;
    }

    public int getColumnSpan() {
        return this.value.getColumnSpan();
    }

    public java.util.List<MappedColumn> getMappedColumns() {
        return this.value.getMappedColumns();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isComposite() {
        return this.value instanceof Component;
    }

    public Value getValue() {
        return this.value;
    }

    public boolean isPrimitive(Class clazz) {
        return this.getGetter(clazz).getReturnType().isPrimitive();
    }

    @Override
    public String getCascade() {
        return this.cascade;
    }

    public void setCascade(String cascade) {
        this.cascade = cascade;
    }

    public void setName(String name) {
        this.name = name == null ? null : name.intern();
    }

    public void setValue(Value value) {
        this.value = value;
    }

    @Override
    public boolean isUpdateable() {
        return this.updateable && !ArrayHelper.isAllFalse(this.value.getColumnUpdateability());
    }

    @Override
    public boolean isIncludedInDirtyChecking() {
        return this.isUpdateable() || this.shouldAlwaysDirtyCheck();
    }

    private boolean shouldAlwaysDirtyCheck() {
        return this.value instanceof Collection || this.value instanceof ManyToOne;
    }

    @Override
    public boolean isInsertable() {
        boolean[] columnInsertability = this.value.getColumnInsertability();
        return this.insertable && (columnInsertability.length == 0 || !ArrayHelper.isAllFalse(columnInsertability));
    }

    @Override
    public ValueGeneration getValueGenerationStrategy() {
        return this.valueGenerationStrategy;
    }

    public void setValueGenerationStrategy(ValueGeneration valueGenerationStrategy) {
        this.valueGenerationStrategy = valueGenerationStrategy;
    }

    public void setUpdateable(boolean mutable) {
        this.updateable = mutable;
    }

    public void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    @Override
    public String getPropertyAccessorName() {
        return this.propertyAccessorName;
    }

    public void setPropertyAccessorName(String string) {
        this.propertyAccessorName = string;
    }

    boolean isNullable() {
        return this.value == null || this.value.isNullable();
    }

    public boolean isBasicPropertyAccessor() {
        return this.propertyAccessorName == null || "property".equals(this.propertyAccessorName);
    }

    public java.util.Map getMetaAttributes() {
        return this.metaAttributes;
    }

    public MetaAttribute getMetaAttribute(String attributeName) {
        return this.metaAttributes == null ? null : (MetaAttribute)this.metaAttributes.get(attributeName);
    }

    public void setMetaAttributes(java.util.Map metas) {
        this.metaAttributes = metas;
    }

    public boolean isValid() throws MappingException {
        return this.getValue().isValid();
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.name + ')';
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    @Override
    public boolean isLazy() {
        if (this.value instanceof ToOne) {
            ToOne toOneValue = (ToOne)this.value;
            return toOneValue.isLazy() && toOneValue.isUnwrapProxy();
        }
        return this.lazy;
    }

    @Override
    public String getLazyGroup() {
        return this.lazyGroup;
    }

    public void setLazyGroup(String lazyGroup) {
        this.lazyGroup = lazyGroup;
    }

    public boolean isOptimisticLocked() {
        return this.optimisticLocked;
    }

    public void setOptimisticLocked(boolean optimisticLocked) {
        this.optimisticLocked = optimisticLocked;
    }

    @Override
    public boolean isOptional() {
        return this.optional || this.isNullable();
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public PersistentClass getPersistentClass() {
        return this.persistentClass;
    }

    public void setPersistentClass(PersistentClass persistentClass) {
        this.persistentClass = persistentClass;
    }

    @Override
    public boolean isSelectable() {
        return this.selectable;
    }

    @Override
    public EntityMapping getEntity() {
        return this.persistentClass;
    }

    @Override
    public boolean isIncludedInOptimisticLocking() {
        return this.optimisticLocked;
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    public String getAccessorPropertyName(EntityMode mode) {
        return this.getName();
    }

    public Getter getGetter(Class clazz) throws PropertyNotFoundException, MappingException {
        return this.getPropertyAccessStrategy(clazz).buildPropertyAccess(clazz, this.name).getGetter();
    }

    public Setter getSetter(Class clazz) throws PropertyNotFoundException, MappingException {
        return this.getPropertyAccessStrategy(clazz).buildPropertyAccess(clazz, this.name).getSetter();
    }

    public PropertyAccessStrategy getPropertyAccessStrategy(Class clazz) throws MappingException {
        String accessName = this.getPropertyAccessorName();
        if (accessName == null) {
            accessName = clazz == null || java.util.Map.class.equals((Object)clazz) ? "map" : "property";
        }
        EntityMode entityMode = clazz == null || java.util.Map.class.equals((Object)clazz) ? EntityMode.MAP : EntityMode.POJO;
        return this.resolveServiceRegistry().getService(PropertyAccessStrategyResolver.class).resolvePropertyAccessStrategy(clazz, accessName, entityMode);
    }

    protected ServiceRegistry resolveServiceRegistry() {
        if (this.persistentClass != null) {
            return this.persistentClass.getServiceRegistry();
        }
        if (this.getValue() != null) {
            return this.getValue().getServiceRegistry();
        }
        throw new HibernateException("Could not resolve ServiceRegistry");
    }

    @Override
    public boolean isNaturalIdentifier() {
        return this.naturalIdentifier;
    }

    public void setNaturalIdentifier(boolean naturalIdentifier) {
        this.naturalIdentifier = naturalIdentifier;
    }

    @Override
    public boolean isLob() {
        return this.lob;
    }

    public void setLob(boolean lob) {
        this.lob = lob;
    }

    @Override
    public <O, T> PersistentAttributeDescriptor<O, T> makeRuntimeAttribute(ManagedTypeDescriptor<O> runtimeContainer, ManagedTypeMapping bootContainer, SingularPersistentAttribute.Disposition singularAttributeDisposition, RuntimeModelCreationContext context) {
        assert (this.value != null);
        assert (!SyntheticProperty.class.isInstance(this));
        if (this.value instanceof Collection) {
            return this.buildCollectionAttribute(runtimeContainer, bootContainer, context);
        }
        return this.buildSingularAttribute(runtimeContainer, bootContainer, singularAttributeDisposition, context);
    }

    private <O, T> PluralPersistentAttribute<O, T, ?> buildCollectionAttribute(ManagedTypeDescriptor runtimeContainer, ManagedTypeMapping bootContainer, RuntimeModelCreationContext context) {
        PersistentCollectionDescriptor descriptor = context.getRuntimeModelDescriptorFactory().createPersistentCollectionDescriptor(this, runtimeContainer, context);
        context.registerCollectionDescriptor(descriptor, (Collection)this.value);
        return descriptor.getDescribedAttribute();
    }

    private <T> CollectionSemantics<T> resolveCollectionSemantics() {
        if (this.value instanceof Array) {
            return StandardArraySemantics.INSTANCE;
        }
        if (this.value instanceof Bag) {
            return StandardBagSemantics.INSTANCE;
        }
        if (this.value instanceof IdentifierBag) {
            return StandardIdentifierBagSemantics.INSTANCE;
        }
        if (this.value instanceof List) {
            return StandardListSemantics.INSTANCE;
        }
        if (this.value instanceof Set) {
            Set set = (Set)this.value;
            Comparator comparator = set.getComparator();
            if (comparator != null) {
                return StandardSortedSetSemantics.INSTANCE;
            }
            if (set.hasOrder()) {
                return StandardOrderedSetSemantics.INSTANCE;
            }
            return StandardSetSemantics.INSTANCE;
        }
        if (this.value instanceof Map) {
            Map map = (Map)this.value;
            Comparator comparator = map.getComparator();
            if (comparator != null) {
                return StandardSortedMapSemantics.INSTANCE;
            }
            if (map.hasOrder()) {
                return StandardOrderedMapSemantics.INSTANCE;
            }
            return StandardMapSemantics.INSTANCE;
        }
        throw new HibernateException("Unable to determine collection semantics - `" + this.getEntity().getEntityName() + '#' + this.getName() + " : " + this.value.getJavaTypeMapping().getTypeName());
    }

    private <O, T> PersistentAttributeDescriptor<O, T> buildSingularAttribute(ManagedTypeDescriptor runtimeContainer, ManagedTypeMapping bootContainer, SingularPersistentAttribute.Disposition singularAttributeDisposition, RuntimeModelCreationContext context) {
        PropertyAccess propertyAccess = runtimeContainer.getRepresentationStrategy().generatePropertyAccess(bootContainer, this, runtimeContainer, context.getSessionFactory().getSessionFactoryOptions().getBytecodeProvider());
        return this.getPersistentAttributeDescriptor(this.value, runtimeContainer, singularAttributeDisposition, context, propertyAccess);
    }

    private <O, T> PersistentAttributeDescriptor<O, T> getPersistentAttributeDescriptor(Value value, ManagedTypeDescriptor runtimeContainer, SingularPersistentAttribute.Disposition singularAttributeDisposition, RuntimeModelCreationContext context, PropertyAccess propertyAccess) {
        if (value instanceof BasicValueMapping) {
            return new SingularPersistentAttributeBasic(runtimeContainer, this, propertyAccess, singularAttributeDisposition, context);
        }
        if (value instanceof ToOne) {
            return new SingularPersistentAttributeEntity(runtimeContainer, this, propertyAccess, singularAttributeDisposition, this.isManyToOne((ToOne)value) ? SingularPersistentAttribute.SingularAttributeClassification.MANY_TO_ONE : SingularPersistentAttribute.SingularAttributeClassification.ONE_TO_ONE, context);
        }
        if (value instanceof Component) {
            return new SingularPersistentAttributeEmbedded(runtimeContainer, this, propertyAccess, singularAttributeDisposition, context);
        }
        if (value instanceof Any) {
            throw new NotYetImplementedFor6Exception();
        }
        if (value instanceof DependantValue) {
            return this.getPersistentAttributeDescriptor(((DependantValue)value).getWrappedValue(), runtimeContainer, singularAttributeDisposition, context, propertyAccess);
        }
        throw new MappingException("Unrecognized ValueMapping type for conversion to runtime model : " + value);
    }

    private boolean isManyToOne(ToOne value) {
        return ManyToOne.class.isInstance(value);
    }

    public Property shallowCopy() {
        Property clone = new Property(this.context);
        clone.setCascade(this.getCascade());
        clone.setInsertable(this.isInsertable());
        clone.setLazy(this.isLazy());
        clone.setName(this.getName());
        clone.setNaturalIdentifier(this.isNaturalIdentifier());
        clone.setOptimisticLocked(this.isOptimisticLocked());
        clone.setOptional(this.isOptional());
        clone.setPersistentClass((PersistentClass)this.getEntity());
        clone.setPropertyAccessorName(this.getPropertyAccessorName());
        clone.setSelectable(this.isSelectable());
        clone.setUpdateable(this.isUpdateable());
        clone.setValue(this.getValue());
        return clone;
    }
}

