/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.hibernate.MappingException;
import org.hibernate.boot.model.domain.PersistentAttributeMapping;
import org.hibernate.boot.model.domain.ValueMapping;
import org.hibernate.boot.model.domain.internal.EntityJavaTypeMappingImpl;
import org.hibernate.boot.model.domain.internal.EntityMappingHierarchyImpl;
import org.hibernate.boot.model.relational.MappedTable;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.SingletonIterator;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PersistentClassVisitor;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.TableOwner;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.model.domain.RepresentationMode;

public class RootClass
extends PersistentClass
implements TableOwner {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(RootClass.class);
    public static final String DEFAULT_IDENTIFIER_COLUMN_NAME = "id";
    public static final String DEFAULT_DISCRIMINATOR_COLUMN_NAME = "class";
    private KeyValue identifier;
    private boolean polymorphic;
    private String cacheConcurrencyStrategy;
    private String cacheRegionName;
    private boolean lazyPropertiesCacheable = true;
    private String naturalIdCacheRegionName;
    private boolean mutable = true;
    private boolean explicitPolymorphism;
    private Class entityPersisterClass;
    private boolean forceDiscriminator;
    private String where;
    private MappedTable table;
    private boolean discriminatorInsertable = true;
    private int nextSubclassId;

    public RootClass(MetadataBuildingContext metadataBuildingContext) {
        super(metadataBuildingContext, new EntityMappingHierarchyImpl());
        this.setJavaTypeMapping(new EntityJavaTypeMappingImpl(metadataBuildingContext, this, null));
        this.getEntityMappingHierarchy().setRootType(this);
        this.getEntityMappingHierarchy().setExplicitRepresentationMode(RepresentationMode.MAP);
    }

    @Override
    public int nextSubclassId() {
        return ++this.nextSubclassId;
    }

    @Override
    public int getSubclassId() {
        return 0;
    }

    @Override
    public void setMappedTable(MappedTable table) {
        this.table = table;
    }

    @Override
    public Table getTable() {
        return (Table)this.table;
    }

    @Override
    public MappedTable getMappedTable() {
        return this.table;
    }

    @Override
    @Deprecated
    public Property getIdentifierProperty() {
        return (Property)this.getIdentifierAttributeMapping();
    }

    @Override
    public Property getDeclaredIdentifierProperty() {
        return (Property)this.getDeclaredIdentifierAttributeMapping();
    }

    @Deprecated
    public void setDeclaredIdentifierProperty(Property declaredIdentifierProperty) {
        this.setDeclaredIdentifierAttributeMapping(declaredIdentifierProperty);
    }

    @Override
    public void setDeclaredIdentifierAttributeMapping(PersistentAttributeMapping declaredIdentifierAttributeMapping) {
        this.getEntityMappingHierarchy().setIdentifierAttributeMapping(declaredIdentifierAttributeMapping);
        super.setDeclaredIdentifierAttributeMapping(declaredIdentifierAttributeMapping);
    }

    @Override
    public KeyValue getIdentifier() {
        return this.identifier;
    }

    @Override
    public boolean hasIdentifierProperty() {
        return this.getEntityMappingHierarchy().hasIdentifierAttributeMapping();
    }

    @Override
    public Value getDiscriminator() {
        return (Value)this.getEntityMappingHierarchy().getDiscriminatorMapping();
    }

    @Override
    public boolean isInherited() {
        return false;
    }

    @Override
    public boolean isPolymorphic() {
        return this.polymorphic;
    }

    public void setPolymorphic(boolean polymorphic) {
        this.polymorphic = polymorphic;
    }

    @Override
    public RootClass getRootClass() {
        return this;
    }

    @Override
    public Iterator getPropertyClosureIterator() {
        return this.getPropertyIterator();
    }

    @Override
    public Iterator getTableClosureIterator() {
        return new SingletonIterator<Table>(this.getTable());
    }

    @Override
    public Iterator getKeyClosureIterator() {
        return new SingletonIterator<KeyValue>(this.getKey());
    }

    @Override
    public void addSubclass(Subclass subclass) throws MappingException {
        super.addSubclass(subclass);
        this.setPolymorphic(true);
    }

    @Override
    public boolean isExplicitPolymorphism() {
        return this.explicitPolymorphism;
    }

    @Override
    @Deprecated
    public Property getVersion() {
        return (Property)this.getVersionAttributeMapping();
    }

    @Override
    public Property getDeclaredVersion() {
        return (Property)this.getDeclaredVersionAttributeMapping();
    }

    @Deprecated
    public void setDeclaredVersion(Property declaredVersion) {
        this.setDeclaredVersionAttributeMapping(declaredVersion);
    }

    @Deprecated
    public void setVersion(Property version) {
        this.setVersionAttributeMapping(version);
    }

    @Override
    public boolean isVersioned() {
        return this.hasVersionAttributeMapping();
    }

    @Override
    public boolean isMutable() {
        return this.mutable;
    }

    @Override
    public boolean hasEmbeddedIdentifier() {
        return this.getEntityMappingHierarchy().hasEmbeddedIdentifier();
    }

    @Override
    public Class getRuntimeEntityDescriptorClass() {
        return this.entityPersisterClass;
    }

    @Override
    public Table getRootTable() {
        return this.getTable();
    }

    @Override
    public void setEntityPersisterClass(Class persister) {
        this.entityPersisterClass = persister;
    }

    @Override
    public PersistentClass getSuperclass() {
        return null;
    }

    @Override
    public KeyValue getKey() {
        return this.getIdentifier();
    }

    @Deprecated
    public void setDiscriminator(Value discriminator) {
        this.setDiscriminatorValueMapping(discriminator);
    }

    public void setDiscriminatorValueMapping(ValueMapping discriminatorValueMapping) {
        this.getEntityMappingHierarchy().setDiscriminatorMapping(discriminatorValueMapping);
    }

    @Deprecated
    public void setEmbeddedIdentifier(boolean embeddedIdentifier) {
        this.getEntityMappingHierarchy().setEmbeddedIdentifier(embeddedIdentifier);
    }

    public void setExplicitPolymorphism(boolean explicitPolymorphism) {
        this.explicitPolymorphism = explicitPolymorphism;
    }

    public void setIdentifier(KeyValue identifier) {
        this.identifier = identifier;
    }

    public void setIdentifierProperty(Property identifierProperty) {
        this.getEntityMappingHierarchy().setIdentifierAttributeMapping(identifierProperty);
        identifierProperty.setPersistentClass(this);
    }

    public void setMutable(boolean mutable) {
        this.mutable = mutable;
    }

    @Override
    public boolean isDiscriminatorInsertable() {
        return this.discriminatorInsertable;
    }

    public void setDiscriminatorInsertable(boolean insertable) {
        this.discriminatorInsertable = insertable;
    }

    @Override
    public boolean isForceDiscriminator() {
        return this.forceDiscriminator;
    }

    public void setForceDiscriminator(boolean forceDiscriminator) {
        this.forceDiscriminator = forceDiscriminator;
    }

    @Override
    public String getWhere() {
        return this.where;
    }

    public void setWhere(String string) {
        this.where = string;
    }

    @Override
    public String getCacheConcurrencyStrategy() {
        return this.cacheConcurrencyStrategy;
    }

    public void setCacheConcurrencyStrategy(String cacheConcurrencyStrategy) {
        this.cacheConcurrencyStrategy = cacheConcurrencyStrategy;
    }

    public String getCacheRegionName() {
        return this.cacheRegionName == null ? this.getEntityName() : this.cacheRegionName;
    }

    public void setCacheRegionName(String cacheRegionName) {
        this.cacheRegionName = StringHelper.nullIfEmpty(cacheRegionName);
    }

    public boolean isLazyPropertiesCacheable() {
        return this.lazyPropertiesCacheable;
    }

    public void setLazyPropertiesCacheable(boolean lazyPropertiesCacheable) {
        this.lazyPropertiesCacheable = lazyPropertiesCacheable;
    }

    @Override
    public String getNaturalIdCacheRegionName() {
        return this.naturalIdCacheRegionName;
    }

    public void setNaturalIdCacheRegionName(String naturalIdCacheRegionName) {
        this.naturalIdCacheRegionName = naturalIdCacheRegionName;
    }

    @Override
    public boolean isJoinedSubclass() {
        return false;
    }

    @Override
    public Set getSynchronizedTables() {
        return this.synchronizedTables;
    }

    public Set<MappedTable> getIdentityTables() {
        HashSet<MappedTable> tables = new HashSet<MappedTable>();
        Iterator iter = this.getSubclassClosureIterator();
        while (iter.hasNext()) {
            PersistentClass clazz = (PersistentClass)iter.next();
            if (clazz.isAbstract() != null && clazz.isAbstract().booleanValue()) continue;
            tables.add(clazz.getIdentityTable());
        }
        return tables;
    }

    @Override
    public Object accept(PersistentClassVisitor mv) {
        return mv.accept(this);
    }
}

