/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.hibernate.MappingException;
import org.hibernate.boot.model.domain.JavaTypeMapping;
import org.hibernate.boot.model.relational.MappedColumn;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.collection.internal.StandardOrderedSetSemantics;
import org.hibernate.collection.internal.StandardSetSemantics;
import org.hibernate.collection.internal.StandardSortedSetSemantics;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.ValueVisitor;

public class Set
extends Collection {
    private Collection.CollectionJavaTypeMapping javaTypeMapping;

    public Set(MetadataBuildingContext buildingContext, PersistentClass owner) {
        super(buildingContext, owner);
    }

    @Override
    public void validate() throws MappingException {
        super.validate();
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    void createPrimaryKey() {
        if (!this.isOneToMany()) {
            PrimaryKey pk = new PrimaryKey(this.getMappedTable());
            pk.addColumns(this.getKey().getMappedColumns());
            for (MappedColumn selectable : this.getElement().getMappedColumns()) {
                if (!(selectable instanceof Column)) continue;
                Column col = (Column)selectable;
                if (!col.isNullable()) {
                    pk.addColumn((MappedColumn)col);
                    continue;
                }
                return;
            }
            if (pk.getColumnSpan() != this.getKey().getColumnSpan()) {
                this.getMappedTable().setPrimaryKey(pk);
            }
        }
    }

    @Override
    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }

    public JavaTypeMapping getJavaTypeMapping() {
        if (this.javaTypeMapping == null) {
            this.javaTypeMapping = this.resolveJavaTypeMapping();
        }
        return this.javaTypeMapping;
    }

    public CollectionSemantics getCollectionSemantics() {
        Comparator comparator = this.getComparator();
        if (comparator != null) {
            return StandardSortedSetSemantics.INSTANCE;
        }
        if (this.hasOrder()) {
            return StandardOrderedSetSemantics.INSTANCE;
        }
        return StandardSetSemantics.INSTANCE;
    }

    private Collection.CollectionJavaTypeMapping resolveJavaTypeMapping() {
        Class javaTypeMappingClass = this.isSorted() ? SortedSet.class : (this.hasOrder() ? TreeSet.class : java.util.Set.class);
        return new Collection.CollectionJavaTypeMapping(this.getMetadataBuildingContext().getBootstrapContext().getTypeConfiguration(), javaTypeMappingClass);
    }
}

