/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.boot.model.relational.MappedColumn;
import org.hibernate.boot.model.relational.MappedTable;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentityGenerator;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;
import org.hibernate.type.descriptor.spi.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class SimpleValue
implements KeyValue {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(SimpleValue.class);
    public static final String DEFAULT_ID_GEN_STRATEGY = "assigned";
    protected final List<MappedColumn> columns = new ArrayList<MappedColumn>();
    protected String typeName;
    protected Properties typeParameters;
    protected MappedTable table;
    protected boolean cascadeDeleteEnabled;
    private final MetadataBuildingContext buildingContext;
    private Properties identifierGeneratorProperties;
    private String identifierGeneratorStrategy = "assigned";
    private String nullValue;
    private String foreignKeyName;
    private String foreignKeyDefinition;
    private boolean alternateUniqueKey;
    private IdentifierGenerator identifierGenerator;

    public SimpleValue(MetadataBuildingContext buildingContext, MappedTable table) {
        this.buildingContext = buildingContext;
        this.table = table;
    }

    @Override
    public MetadataBuildingContext getMetadataBuildingContext() {
        return this.buildingContext;
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.buildingContext.getMetadataCollector().getMetadataBuildingOptions().getServiceRegistry();
    }

    @Override
    public boolean isCascadeDeleteEnabled() {
        return this.cascadeDeleteEnabled;
    }

    public void setCascadeDeleteEnabled(boolean cascadeDeleteEnabled) {
        this.cascadeDeleteEnabled = cascadeDeleteEnabled;
    }

    public void addColumn(Column column) {
        column.setTableName(this.getMappedTable().getNameIdentifier());
        this.getMappedTable().addColumn(column);
        if (!this.columns.contains(column)) {
            this.columns.add(column);
        }
    }

    public void addFormula(Formula formula) {
        this.getMappedTable().addFormula(formula);
        this.columns.add(formula);
    }

    @Override
    public boolean hasFormula() {
        for (MappedColumn column : this.getMappedColumns()) {
            if (!column.isFormula()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getColumnSpan() {
        return this.columns.size();
    }

    @Override
    public List<MappedColumn> getMappedColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public List<MappedColumn> getConstraintColumns() {
        return this.columns;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setExplicitTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Deprecated
    public void setTable(Table table) {
        this.table = table;
    }

    public void setTable(MappedTable table) {
        this.table = table;
    }

    @Override
    public ForeignKey createForeignKeyOfEntity(String entityName) {
        ForeignKey fk = (ForeignKey)this.table.createForeignKey(this.getForeignKeyName(), this.getConstraintColumns(), entityName, this.getForeignKeyDefinition());
        fk.setCascadeDeleteEnabled(this.cascadeDeleteEnabled);
        if (this.hasFormula() || "none".equals(this.getForeignKeyName())) {
            fk.disableCreation();
        }
        return fk;
    }

    @Override
    public IdentifierGenerator createIdentifierGenerator(IdentifierGeneratorFactory identifierGeneratorFactory, Dialect dialect, String defaultCatalog, String defaultSchema, RootClass rootClass) throws MappingException {
        if (this.identifierGenerator != null) {
            return this.identifierGenerator;
        }
        Properties params = new Properties();
        if (defaultSchema != null) {
            params.setProperty("schema", defaultSchema);
        }
        if (defaultCatalog != null) {
            params.setProperty("catalog", defaultCatalog);
        }
        if (rootClass != null) {
            params.setProperty("entity_name", rootClass.getEntityName());
            params.setProperty("jpa_entity_name", rootClass.getJpaEntityName());
        }
        String tableName = this.getMappedTable().getQuotedName(dialect);
        params.setProperty("target_table", tableName);
        String columnName = ((Column)this.getMappedColumns().get(0)).getQuotedName(dialect);
        params.setProperty("target_column", columnName);
        if (rootClass != null) {
            StringBuilder tables = new StringBuilder();
            Iterator<MappedTable> iter = rootClass.getIdentityTables().iterator();
            while (iter.hasNext()) {
                Table table = (Table)iter.next();
                tables.append(table.getQuotedName(dialect));
                if (!iter.hasNext()) continue;
                tables.append(", ");
            }
            params.setProperty("identity_tables", tables.toString());
        } else {
            params.setProperty("identity_tables", tableName);
        }
        if (this.identifierGeneratorProperties != null) {
            params.putAll((Map<?, ?>)this.identifierGeneratorProperties);
        }
        ConfigurationService cs = this.getServiceRegistry().getService(ConfigurationService.class);
        params.put("hibernate.id.optimizer.pooled.prefer_lo", cs.getSetting("hibernate.id.optimizer.pooled.prefer_lo", StandardConverters.BOOLEAN, Boolean.valueOf(false)));
        if (cs.getSettings().get("hibernate.id.optimizer.pooled.preferred") != null) {
            params.put("hibernate.id.optimizer.pooled.preferred", cs.getSettings().get("hibernate.id.optimizer.pooled.preferred"));
        }
        identifierGeneratorFactory.setDialect(dialect);
        this.identifierGenerator = identifierGeneratorFactory.createIdentifierGenerator(this.identifierGeneratorStrategy, this.getJavaTypeMapping().getJavaTypeDescriptor(), params);
        return this.identifierGenerator;
    }

    @Override
    public boolean isUpdateable() {
        return true;
    }

    @Override
    public FetchMode getFetchMode() {
        return FetchMode.SELECT;
    }

    public Properties getIdentifierGeneratorProperties() {
        return this.identifierGeneratorProperties;
    }

    @Override
    public String getNullValue() {
        return this.nullValue;
    }

    @Override
    public Table getTable() {
        return (Table)this.getMappedTable();
    }

    @Override
    public MappedTable getMappedTable() {
        return this.table;
    }

    public String getIdentifierGeneratorStrategy() {
        return this.identifierGeneratorStrategy;
    }

    @Override
    public boolean isIdentityColumn(IdentifierGeneratorFactory identifierGeneratorFactory) {
        return IdentityGenerator.class.isAssignableFrom(identifierGeneratorFactory.getIdentifierGeneratorClass(this.identifierGeneratorStrategy));
    }

    public void setIdentifierGeneratorProperties(Properties identifierGeneratorProperties) {
        this.identifierGeneratorProperties = identifierGeneratorProperties;
    }

    public void setIdentifierGeneratorStrategy(String identifierGeneratorStrategy) {
        this.identifierGeneratorStrategy = identifierGeneratorStrategy;
    }

    public void setNullValue(String nullValue) {
        this.nullValue = nullValue;
    }

    public String getForeignKeyName() {
        return this.foreignKeyName;
    }

    public void setForeignKeyName(String foreignKeyName) {
        this.foreignKeyName = foreignKeyName;
    }

    public String getForeignKeyDefinition() {
        return this.foreignKeyDefinition;
    }

    public void setForeignKeyDefinition(String foreignKeyDefinition) {
        this.foreignKeyDefinition = foreignKeyDefinition;
    }

    @Override
    public boolean isAlternateUniqueKey() {
        return this.alternateUniqueKey;
    }

    public void setAlternateUniqueKey(boolean unique) {
        this.alternateUniqueKey = unique;
    }

    @Override
    public boolean isNullable() {
        List<MappedColumn> mappedColumns = this.getMappedColumns();
        for (MappedColumn column : mappedColumns) {
            if (column instanceof Formula) {
                return true;
            }
            if (((Column)column).isNullable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSimpleValue() {
        return true;
    }

    @Override
    public boolean isValid() throws MappingException {
        return true;
    }

    public SqlTypeDescriptorIndicators makeJdbcRecommendedSqlTypeMappingContext(TypeConfiguration typeConfiguration, boolean isNationalized, boolean isLob) {
        return new LocalSqlTypeDescriptorIndicators(typeConfiguration, isNationalized, isLob);
    }

    @Override
    public void setTypeUsingReflection(String className, String propertyName) throws MappingException {
        if (this.typeName != null) {
            return;
        }
        if (className == null) {
            throw new MappingException("Attribute types for a dynamic entity must be explicitly specified: " + propertyName);
        }
        this.typeName = ReflectHelper.reflectedPropertyClass(className, propertyName, this.getServiceRegistry().getService(ClassLoaderService.class)).getName();
    }

    public boolean isTypeSpecified() {
        return this.typeName != null;
    }

    public void setTypeParameters(Properties parameterMap) {
        this.typeParameters = parameterMap;
    }

    public Properties getTypeParameters() {
        return this.typeParameters;
    }

    @Deprecated
    public void copyTypeFrom(SimpleValue sourceValue) {
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.columns.toString() + ')';
    }

    @Override
    public boolean[] getColumnInsertability() {
        boolean[] columnInsertability = new boolean[this.getColumnSpan()];
        int i = 0;
        for (MappedColumn column : this.columns) {
            columnInsertability[i++] = column.isInsertable();
        }
        return columnInsertability;
    }

    @Override
    public boolean[] getColumnUpdateability() {
        boolean[] columnInsertability = new boolean[this.getColumnSpan()];
        int i = 0;
        for (MappedColumn column : this.columns) {
            columnInsertability[i++] = column.isUpdatable();
        }
        return columnInsertability;
    }

    @Override
    public boolean isSame(Value other) {
        return this == other || other instanceof SimpleValue && this.isSame((SimpleValue)other);
    }

    protected static boolean isSame(Value v1, Value v2) {
        return v1 == v2 || v1 != null && v2 != null && v1.isSame(v2);
    }

    public boolean isSame(SimpleValue other) {
        return Objects.equals(this.columns, other.columns) && Objects.equals(this.typeName, other.typeName) && Objects.equals(this.typeParameters, other.typeParameters) && Objects.equals(this.table, other.table) && Objects.equals(this.foreignKeyName, other.foreignKeyName) && Objects.equals(this.foreignKeyDefinition, other.foreignKeyDefinition);
    }

    public static interface BasicTypeDescriptorResolver
    extends TypeDescriptorResolver {
        @Override
        public SqlTypeDescriptor resolveSqlTypeDescriptor();

        @Override
        public BasicJavaDescriptor resolveJavaTypeDescriptor();
    }

    public static interface TypeDescriptorResolver {
        public SqlTypeDescriptor resolveSqlTypeDescriptor();

        public JavaTypeDescriptor resolveJavaTypeDescriptor();
    }

    private class LocalSqlTypeDescriptorIndicators
    implements SqlTypeDescriptorIndicators {
        private final TypeConfiguration typeConfiguration;
        private final boolean isNationalized;
        private final boolean isLob;

        private LocalSqlTypeDescriptorIndicators(TypeConfiguration typeConfiguration, boolean isNationalized, boolean isLob) {
            this.typeConfiguration = typeConfiguration;
            this.isNationalized = isNationalized;
            this.isLob = isLob;
        }

        @Override
        public boolean isNationalized() {
            return this.isNationalized;
        }

        @Override
        public boolean isLob() {
            return this.isLob;
        }

        @Override
        public TypeConfiguration getTypeConfiguration() {
            return this.typeConfiguration;
        }
    }
}

