/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.hibernate.MappingException;
import org.hibernate.boot.model.relational.InitCommand;
import org.hibernate.boot.model.relational.MappedColumn;
import org.hibernate.boot.model.relational.MappedForeignKey;
import org.hibernate.boot.model.relational.MappedIndex;
import org.hibernate.boot.model.relational.MappedNamespace;
import org.hibernate.boot.model.relational.MappedPrimaryKey;
import org.hibernate.boot.model.relational.MappedTable;
import org.hibernate.boot.model.relational.MappedUniqueKey;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.internal.util.JavaTypeHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.metamodel.model.relational.internal.InflightTable;
import org.hibernate.metamodel.model.relational.spi.DerivedTable;
import org.hibernate.metamodel.model.relational.spi.PhysicalColumn;
import org.hibernate.metamodel.model.relational.spi.PhysicalNamingStrategy;
import org.hibernate.metamodel.model.relational.spi.PhysicalTable;
import org.hibernate.metamodel.model.relational.spi.PrimaryKey;
import org.hibernate.metamodel.model.relational.spi.RuntimeDatabaseModelProducer;
import org.hibernate.naming.Identifier;
import org.hibernate.naming.QualifiedTableName;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class Table
implements MappedTable<Column>,
Serializable {
    private static final Logger log = Logger.getLogger(Table.class);
    private final UUID uuid = UUID.randomUUID();
    private Identifier catalog;
    private Identifier schema;
    private Identifier name;
    private Map<String, Column> columns = new LinkedHashMap<String, Column>();
    private KeyValue idValue;
    private MappedPrimaryKey primaryKey;
    private Map<ForeignKeyKey, MappedForeignKey> foreignKeyMap = new LinkedHashMap<ForeignKeyKey, MappedForeignKey>();
    private Map<String, MappedIndex> indexes = new LinkedHashMap<String, MappedIndex>();
    private Map<String, MappedUniqueKey> uniqueKeys = new LinkedHashMap<String, MappedUniqueKey>();
    private Map<String, Formula> formulas = new LinkedHashMap<String, Formula>();
    private int uniqueInteger;
    private List<String> checkConstraints = new ArrayList<String>();
    private String rowId;
    private String subselect;
    private boolean isAbstract;
    private boolean hasDenormalizedTables;
    private String comment;
    private List<InitCommand> initCommands;
    private int sizeOfUniqueKeyMapOnLastCleanse;

    public Table(MappedNamespace namespace, Identifier tableName, boolean isAbstract) {
        this(namespace.getCatalogName(), namespace.getSchemaName(), tableName, isAbstract);
    }

    public Table(MappedNamespace namespace, String subselect, boolean isAbstract) {
        this(namespace, null, subselect, isAbstract);
    }

    public Table(MappedNamespace namespace, Identifier tableName, String subselect, boolean isAbstract) {
        this(namespace.getCatalogName(), namespace.getSchemaName(), tableName, isAbstract);
        this.subselect = subselect;
    }

    public Table(Identifier catalog, Identifier schema, Identifier tableName, boolean isAbstract) {
        this.catalog = catalog;
        this.schema = schema;
        this.name = tableName;
        this.isAbstract = isAbstract;
    }

    @Deprecated
    public String getQualifiedName(Dialect dialect, String defaultCatalog, String defaultSchema) {
        if (this.subselect != null) {
            return "( " + this.subselect + " )";
        }
        String quotedName = this.getQuotedName(dialect);
        String usedSchema = this.schema == null ? defaultSchema : this.getQuotedSchema(dialect);
        String usedCatalog = this.catalog == null ? defaultCatalog : this.getQuotedCatalog(dialect);
        return Table.qualify(usedCatalog, usedSchema, quotedName);
    }

    @Deprecated
    public static String qualify(String catalog, String schema, String table) {
        StringBuilder qualifiedName = new StringBuilder();
        if (catalog != null) {
            qualifiedName.append(catalog).append('.');
        }
        if (schema != null) {
            qualifiedName.append(schema).append('.');
        }
        return qualifiedName.append(table).toString();
    }

    @Override
    public void setName(String name) {
        this.name = Identifier.toIdentifier(name);
    }

    @Override
    public String getName() {
        return this.name == null ? null : this.name.getText();
    }

    @Override
    public Identifier getNameIdentifier() {
        return this.name;
    }

    @Override
    public String getQuotedName() {
        return this.name == null ? null : this.name.toString();
    }

    @Override
    public String getQuotedName(Dialect dialect) {
        return this.name == null ? null : this.name.render(dialect);
    }

    @Override
    public QualifiedTableName getQualifiedTableName() {
        return this.name == null ? null : new QualifiedTableName(this.catalog, this.schema, this.name);
    }

    public boolean isQuoted() {
        return this.name.isQuoted();
    }

    public void setQuoted(boolean quoted) {
        if (quoted == this.name.isQuoted()) {
            return;
        }
        this.name = new Identifier(this.name.getText(), quoted);
    }

    public void setSchema(String schema) {
        this.schema = Identifier.toIdentifier(schema);
    }

    @Override
    public String getSchema() {
        return this.schema == null ? null : this.schema.getText();
    }

    public String getQuotedSchema(Dialect dialect) {
        return this.schema == null ? null : this.schema.render(dialect);
    }

    public void setCatalog(String catalog) {
        this.catalog = Identifier.toIdentifier(catalog);
    }

    @Override
    public String getCatalog() {
        return this.catalog == null ? null : this.catalog.getText();
    }

    public String getQuotedCatalog(Dialect dialect) {
        return this.catalog == null ? null : this.catalog.render(dialect);
    }

    @Override
    public Column getColumn(Column column) {
        if (column == null) {
            return null;
        }
        Column myColumn = this.columns.get(column.getCanonicalName());
        return column.equals(myColumn) ? myColumn : null;
    }

    @Override
    public Column getColumn(Identifier name) {
        if (name == null) {
            return null;
        }
        return this.columns.get(name.getCanonicalName());
    }

    @Override
    public Column getColumn(int n) {
        Iterator<Column> iter = this.columns.values().iterator();
        for (int i = 0; i < n - 1; ++i) {
            iter.next();
        }
        return iter.next();
    }

    @Override
    public void addColumn(Column column) {
        Column old = this.getColumn(column);
        if (old == null) {
            if (this.primaryKey != null) {
                for (MappedColumn pkColumn : this.primaryKey.getColumns()) {
                    Column c;
                    if (pkColumn.isFormula() || !(c = (Column)pkColumn).getCanonicalName().equals(column.getCanonicalName())) continue;
                    column.setNullable(false);
                    log.debugf("Forcing column [%s] to be non-null as it is part of the primary key for table [%s]", (Object)column.getCanonicalName(), (Object)this.getNameIdentifier().getCanonicalName());
                }
            }
            this.columns.put(column.getCanonicalName(), column);
            column.setUniqueInteger(this.columns.size());
        } else {
            column.setUniqueInteger(old.getUniqueInteger());
        }
        if (column.isUnique()) {
            ArrayList<Column> cols = new ArrayList<Column>();
            cols.add(column);
            this.createUniqueKey((List<Column>)cols);
        }
    }

    public int getColumnSpan() {
        return this.columns.size();
    }

    @Deprecated
    public Iterator getColumnIterator() {
        return this.columns.values().iterator();
    }

    @Deprecated
    public Iterator<MappedIndex> getIndexIterator() {
        return this.indexes.values().iterator();
    }

    @Override
    public Collection<MappedIndex> getIndexes() {
        return this.indexes.values();
    }

    public Map<ForeignKeyKey, MappedForeignKey> getForeignKeyMap() {
        return Collections.unmodifiableMap(this.foreignKeyMap);
    }

    @Deprecated
    public Iterator getForeignKeyIterator() {
        return this.foreignKeyMap.values().iterator();
    }

    @Override
    public Collection<MappedForeignKey> getForeignKeys() {
        return Collections.unmodifiableCollection(this.foreignKeyMap.values());
    }

    @Deprecated
    public Iterator<MappedUniqueKey> getUniqueKeyIterator() {
        return this.getUniqueKeys().iterator();
    }

    @Override
    public Collection<MappedUniqueKey> getUniqueKeys() {
        this.cleanseUniqueKeyMapIfNeeded();
        return this.uniqueKeys.values();
    }

    private void cleanseUniqueKeyMapIfNeeded() {
        if (this.uniqueKeys.size() == this.sizeOfUniqueKeyMapOnLastCleanse) {
            return;
        }
        this.cleanseUniqueKeyMap();
        this.sizeOfUniqueKeyMapOnLastCleanse = this.uniqueKeys.size();
    }

    private void cleanseUniqueKeyMap() {
        if (this.uniqueKeys.isEmpty()) {
            return;
        }
        if (this.uniqueKeys.size() == 1) {
            Map.Entry<String, MappedUniqueKey> uniqueKeyEntry = this.uniqueKeys.entrySet().iterator().next();
            if (this.isSameAsPrimaryKeyColumns(uniqueKeyEntry.getValue())) {
                this.uniqueKeys.remove(uniqueKeyEntry.getKey());
            }
        } else {
            Iterator<Map.Entry<String, MappedUniqueKey>> uniqueKeyEntries = this.uniqueKeys.entrySet().iterator();
            while (uniqueKeyEntries.hasNext()) {
                Map.Entry<String, MappedUniqueKey> uniqueKeyEntry = uniqueKeyEntries.next();
                MappedUniqueKey uniqueKey = uniqueKeyEntry.getValue();
                boolean removeIt = false;
                for (MappedUniqueKey otherUniqueKey : this.uniqueKeys.values()) {
                    if (uniqueKeyEntry.getValue() == otherUniqueKey || !otherUniqueKey.getColumns().containsAll(uniqueKey.getColumns()) || !uniqueKey.getColumns().containsAll(otherUniqueKey.getColumns())) continue;
                    removeIt = true;
                    break;
                }
                if (this.isSameAsPrimaryKeyColumns(uniqueKeyEntry.getValue())) {
                    removeIt = true;
                }
                if (!removeIt) continue;
                uniqueKeyEntries.remove();
            }
        }
    }

    private boolean isSameAsPrimaryKeyColumns(MappedUniqueKey uniqueKey) {
        if (this.primaryKey == null || !this.primaryKey.getColumns().isEmpty()) {
            return false;
        }
        return this.primaryKey.getColumns().containsAll(uniqueKey.getColumns()) && uniqueKey.getColumns().containsAll(this.primaryKey.getColumns());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.catalog == null ? 0 : this.catalog.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.schema == null ? 0 : this.schema.hashCode());
        return result;
    }

    public boolean equals(Object object) {
        return object instanceof Table && this.equals((Table)object);
    }

    public boolean equals(Table table) {
        if (null == table) {
            return false;
        }
        if (this == table) {
            return true;
        }
        return Identifier.areEqual(this.name, table.name) && Identifier.areEqual(this.schema, table.schema) && Identifier.areEqual(this.catalog, table.catalog);
    }

    public boolean hasPrimaryKey() {
        return this.getPrimaryKey() != null;
    }

    @Override
    public MappedPrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public void setPrimaryKey(MappedPrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    @Override
    public MappedIndex getOrCreateIndex(String indexName) {
        MappedIndex index = this.indexes.get(indexName);
        if (index == null) {
            index = new Index();
            index.setName(indexName);
            index.setTable(this);
            this.indexes.put(indexName, index);
        }
        return index;
    }

    public MappedIndex getIndex(String indexName) {
        return this.indexes.get(indexName);
    }

    @Override
    public void addUniqueKey(MappedUniqueKey uniqueKey) {
        MappedUniqueKey current = this.uniqueKeys.get(uniqueKey.getName());
        if (current != null) {
            throw new MappingException("UniqueKey " + uniqueKey.getName() + " already exists!");
        }
        this.uniqueKeys.put(uniqueKey.getName(), uniqueKey);
    }

    @Override
    public void addFormula(Formula formula) {
        this.formulas.put(formula.getFormula(), formula);
    }

    @Override
    public MappedUniqueKey createUniqueKey(List<Column> keyColumns) {
        List columns = (List)JavaTypeHelper.cast(keyColumns);
        String keyName = Constraint.generateName("UK_", this, columns);
        MappedUniqueKey uk = this.getOrCreateUniqueKey(keyName);
        uk.addColumns(keyColumns);
        return uk;
    }

    public MappedUniqueKey getUniqueKey(String keyName) {
        return this.uniqueKeys.get(keyName);
    }

    @Override
    public MappedUniqueKey getOrCreateUniqueKey(String keyName) {
        MappedUniqueKey uk = this.uniqueKeys.get(keyName);
        if (uk == null) {
            uk = new UniqueKey();
            uk.setName(keyName);
            uk.setMappedTable(this);
            this.uniqueKeys.put(keyName, uk);
        }
        return uk;
    }

    @Override
    public void createForeignKeys() {
    }

    @Override
    public MappedForeignKey createForeignKey(String keyName, List keyColumns, String referencedEntityName, String keyDefinition) {
        return this.createForeignKey(keyName, keyColumns, referencedEntityName, keyDefinition, null);
    }

    @Override
    public MappedForeignKey createForeignKey(String keyName, List keyColumns, String referencedEntityName, String keyDefinition, List referencedColumns) {
        ForeignKeyKey key = new ForeignKeyKey(keyColumns, referencedEntityName, referencedColumns);
        MappedForeignKey fk = this.foreignKeyMap.get(key);
        if (fk == null) {
            fk = new ForeignKey();
            fk.setMappedTable(this);
            fk.setReferencedEntityName(referencedEntityName);
            fk.setKeyDefinition(keyDefinition);
            fk.addColumns(keyColumns);
            if (referencedColumns != null) {
                fk.addReferencedColumns(referencedColumns);
            }
            fk.setName(keyName);
            this.foreignKeyMap.put(key, fk);
        }
        if (keyName != null) {
            fk.setName(keyName);
        }
        return fk;
    }

    @Override
    public void setUniqueInteger(int uniqueInteger) {
        this.uniqueInteger = uniqueInteger;
    }

    public int getUniqueInteger() {
        return this.uniqueInteger;
    }

    @Override
    public void setIdentifierValue(KeyValue idValue) {
        this.idValue = idValue;
    }

    @Override
    public KeyValue getIdentifierValue() {
        return this.idValue;
    }

    @Override
    public void addCheckConstraint(String constraint) {
        this.checkConstraints.add(constraint);
    }

    @Override
    public boolean containsColumn(Column column) {
        return this.columns.containsKey(column.getCanonicalName());
    }

    @Override
    public String getRowId() {
        return this.rowId;
    }

    @Override
    public void setRowId(String rowId) {
        this.rowId = rowId;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append(this.getClass().getName()).append('(');
        if (this.getCatalog() != null) {
            buf.append(this.getCatalog()).append(".");
        }
        if (this.getSchema() != null) {
            buf.append(this.getSchema()).append(".");
        }
        buf.append(this.getName()).append(')');
        return buf.toString();
    }

    @Override
    public String toLoggableString() {
        return this.toString();
    }

    @Override
    public String getSubselect() {
        return this.subselect;
    }

    @Override
    public void setSubselect(String subselect) {
        this.subselect = subselect;
    }

    @Override
    public boolean isSubselect() {
        return this.subselect != null;
    }

    public boolean isAbstractUnionTable() {
        return this.hasDenormalizedTables() && this.isAbstract;
    }

    @Override
    public boolean hasDenormalizedTables() {
        return this.hasDenormalizedTables;
    }

    @Override
    public void setHasDenormalizedTables() {
        this.hasDenormalizedTables = true;
    }

    @Override
    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public boolean isPhysicalTable() {
        return !this.isSubselect() && !this.isAbstractUnionTable();
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Deprecated
    public Iterator<String> getCheckConstraintsIterator() {
        return this.checkConstraints.iterator();
    }

    @Override
    public List<String> getCheckConstraints() {
        return Collections.unmodifiableList(this.checkConstraints);
    }

    @Override
    public boolean isExportable() {
        return this.isPhysicalTable();
    }

    @Override
    public void addInitCommand(InitCommand command) {
        if (this.initCommands == null) {
            this.initCommands = new ArrayList<InitCommand>();
        }
        this.initCommands.add(command);
    }

    @Override
    public List<InitCommand> getInitCommands() {
        if (this.initCommands == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.initCommands);
    }

    @Override
    public Set<Column> getMappedColumns() {
        return Collections.unmodifiableSet(new HashSet<Column>(this.columns.values()));
    }

    @Override
    public UUID getUid() {
        return this.uuid;
    }

    @Override
    public InflightTable generateRuntimeTable(PhysicalNamingStrategy namingStrategy, JdbcEnvironment jdbcEnvironment, IdentifierGeneratorFactory identifierGeneratorFactory, RuntimeDatabaseModelProducer.Callback callback, TypeConfiguration typeConfiguration) {
        InflightTable runtimeTable = this.getSubselect() != null ? new DerivedTable(this.getUid(), this.getSubselect(), this.isAbstract()) : this.createRuntimePhysicalTable(namingStrategy, jdbcEnvironment, identifierGeneratorFactory, typeConfiguration);
        this.addColumnsToInflightTable(runtimeTable, namingStrategy, jdbcEnvironment, callback, typeConfiguration);
        callback.tableBuilt(this, runtimeTable);
        return runtimeTable;
    }

    private void addColumnsToInflightTable(InflightTable runtimeTable, PhysicalNamingStrategy namingStrategy, JdbcEnvironment jdbcEnvironment, RuntimeDatabaseModelProducer.Callback callback, TypeConfiguration typeConfiguration) {
        HashMap<MappedColumn, org.hibernate.metamodel.model.relational.spi.Column> tableColumnXref = new HashMap<MappedColumn, org.hibernate.metamodel.model.relational.spi.Column>();
        for (MappedColumn mappedColumn : this.getMappedColumns()) {
            org.hibernate.metamodel.model.relational.spi.Column column = mappedColumn.generateRuntimeColumn(runtimeTable, namingStrategy, jdbcEnvironment, typeConfiguration);
            runtimeTable.addColumn(column);
            callback.columnBuilt(mappedColumn, column);
            tableColumnXref.put(mappedColumn, column);
        }
        if (this.getPrimaryKey() != null) {
            PrimaryKey runtimeTablePrimaryKey = new PrimaryKey(runtimeTable);
            for (MappedColumn mappedColumn : this.getPrimaryKey().getColumns()) {
                if (mappedColumn.isFormula()) {
                    throw new MappingException("FK column must be a physical column");
                }
                runtimeTablePrimaryKey.addColumn((PhysicalColumn)tableColumnXref.get(mappedColumn));
                runtimeTable.addPrimaryKey(runtimeTablePrimaryKey);
            }
            callback.primaryKeyBuilt(this.primaryKey, runtimeTable.getPrimaryKey());
        }
        this.getUniqueKeys().forEach(bootUk -> {
            org.hibernate.metamodel.model.relational.spi.UniqueKey runtimeUk = runtimeTable.createUniqueKey(bootUk.getName());
            for (MappedColumn mappedColumn : bootUk.getColumns()) {
                if (mappedColumn.isFormula()) {
                    throw new MappingException("UK column must be a physical column");
                }
                org.hibernate.metamodel.model.relational.spi.Column column = (org.hibernate.metamodel.model.relational.spi.Column)tableColumnXref.get(mappedColumn);
                runtimeUk.addColumn((PhysicalColumn)column, bootUk.getColumnOrderMap().get(mappedColumn));
            }
            callback.uniqueKeyBuilt((MappedUniqueKey)bootUk, runtimeUk);
        });
        this.formulas.values().forEach(formula -> {
            org.hibernate.metamodel.model.relational.spi.Column column = formula.generateRuntimeColumn(runtimeTable, namingStrategy, jdbcEnvironment, typeConfiguration);
            callback.columnBuilt((MappedColumn)formula, column);
        });
    }

    private InflightTable createRuntimePhysicalTable(PhysicalNamingStrategy namingStrategy, JdbcEnvironment jdbcEnvironment, IdentifierGeneratorFactory identifierGeneratorFactory, TypeConfiguration typeConfiguration) {
        PhysicalTable runtimeTable = new PhysicalTable(this.getUid(), this.catalog, this.schema, this.name, this.isAbstract(), this.getComment(), namingStrategy, jdbcEnvironment);
        if (this.primaryKey != null && this.getIdentifierValue() != null && this.getIdentifierValue().isIdentityColumn(identifierGeneratorFactory)) {
            runtimeTable.setPrimaryKeyIdentity(true);
        }
        runtimeTable.setCheckConstraints(this.getCheckConstraints());
        for (MappedIndex index : this.getIndexes()) {
            runtimeTable.addIndex(((Index)index).generateRuntimeIndex(runtimeTable, namingStrategy, jdbcEnvironment, typeConfiguration));
        }
        for (InitCommand initCommand : this.getInitCommands()) {
            runtimeTable.addInitCommand(initCommand);
        }
        return runtimeTable;
    }

    public static class ForeignKeyKey
    implements Serializable {
        String referencedClassName;
        List columns;
        List referencedColumns;

        ForeignKeyKey(List columns, String referencedClassName, List referencedColumns) {
            this.referencedClassName = referencedClassName;
            this.columns = new ArrayList();
            this.columns.addAll(columns);
            if (referencedColumns != null) {
                this.referencedColumns = new ArrayList();
                this.referencedColumns.addAll(referencedColumns);
            } else {
                this.referencedColumns = Collections.EMPTY_LIST;
            }
        }

        public int hashCode() {
            return this.columns.hashCode() + this.referencedColumns.hashCode();
        }

        public boolean equals(Object other) {
            ForeignKeyKey fkk = (ForeignKeyKey)other;
            return fkk != null && fkk.columns.equals(this.columns) && fkk.referencedColumns.equals(this.referencedColumns);
        }

        public String toString() {
            return "ForeignKeyKey{columns=" + String.join((CharSequence)",", this.columns) + ", referencedClassName='" + this.referencedClassName + '\'' + ", referencedColumns=" + String.join((CharSequence)",", this.referencedColumns) + '}';
        }
    }
}

