/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.Objects;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.boot.model.relational.MappedTable;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.mapping.Fetchable;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;

public abstract class ToOne
extends SimpleValue
implements Fetchable {
    private FetchMode fetchMode;
    protected String referencedPropertyName;
    private String referencedEntityName;
    private String propertyName;
    private boolean lazy = true;
    protected boolean unwrapProxy;
    protected boolean referenceToPrimaryKey = true;

    protected ToOne(MetadataBuildingContext buildingContext, Table table) {
        super(buildingContext, table);
    }

    protected ToOne(MetadataBuildingContext buildingContext, MappedTable table) {
        super(buildingContext, table);
    }

    @Override
    public FetchMode getFetchMode() {
        return this.fetchMode;
    }

    @Override
    public void setFetchMode(FetchMode fetchMode) {
        this.fetchMode = fetchMode;
    }

    @Override
    public abstract ForeignKey createForeignKey() throws MappingException;

    public String getReferencedPropertyName() {
        return this.referencedPropertyName;
    }

    public void setReferencedPropertyName(String name) {
        this.referencedPropertyName = name == null ? null : name.intern();
    }

    public String getReferencedEntityName() {
        return this.referencedEntityName;
    }

    public void setReferencedEntityName(String referencedEntityName) {
        this.referencedEntityName = referencedEntityName == null ? null : referencedEntityName.intern();
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName == null ? null : propertyName.intern();
    }

    @Override
    public void setTypeUsingReflection(String className, String propertyName) throws MappingException {
        if (this.referencedEntityName == null) {
            ClassLoaderService cls = this.getMetadataBuildingContext().getBootstrapContext().getServiceRegistry().getService(ClassLoaderService.class);
            this.referencedEntityName = ReflectHelper.reflectedPropertyClass(className, propertyName, cls).getName();
        }
    }

    @Override
    public boolean isTypeSpecified() {
        return this.referencedEntityName != null;
    }

    @Override
    public boolean isSame(Value other) {
        return other instanceof ToOne && this.isSame((ToOne)other);
    }

    @Override
    public boolean isSame(SimpleValue other) {
        return other instanceof ToOne && this.isSame((ToOne)other);
    }

    public boolean isSame(ToOne other) {
        return super.isSame(other) && Objects.equals(this.referencedPropertyName, other.referencedPropertyName) && Objects.equals(this.referencedEntityName, other.referencedEntityName);
    }

    @Override
    public boolean isValid() throws MappingException {
        if (this.referencedEntityName == null) {
            throw new MappingException("association must specify the referenced entity");
        }
        return super.isValid();
    }

    @Override
    public boolean isLazy() {
        return this.lazy;
    }

    @Override
    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public boolean isUnwrapProxy() {
        return this.unwrapProxy;
    }

    public void setUnwrapProxy(boolean unwrapProxy) {
        this.unwrapProxy = unwrapProxy;
    }

    public boolean isReferenceToPrimaryKey() {
        return this.referenceToPrimaryKey;
    }

    public void setReferenceToPrimaryKey(boolean referenceToPrimaryKey) {
        this.referenceToPrimaryKey = referenceToPrimaryKey;
    }
}

