/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.Iterator;
import java.util.Set;
import org.hibernate.MappingException;
import org.hibernate.boot.model.relational.MappedTable;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PersistentClassVisitor;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.TableOwner;

public class UnionSubclass
extends Subclass
implements TableOwner {
    private MappedTable table;
    private KeyValue key;

    public UnionSubclass(PersistentClass superclass, MetadataBuildingContext metadataBuildingContext) {
        super(superclass, metadataBuildingContext);
    }

    @Override
    public Table getTable() {
        return (Table)this.table;
    }

    @Override
    public MappedTable getMappedTable() {
        return this.table;
    }

    @Override
    public void setMappedTable(MappedTable table) {
        this.table = table;
        this.getSuperclass().addSubclassTable(table);
    }

    @Override
    public Set getSynchronizedTables() {
        return this.synchronizedTables;
    }

    @Override
    protected Iterator getNonDuplicatedPropertyIterator() {
        return this.getPropertyClosureIterator();
    }

    @Override
    public void validate() throws MappingException {
        super.validate();
        if (this.key != null && !this.key.isValid()) {
            throw new MappingException("subclass key mapping has wrong number of columns: " + this.getEntityName() + " type: " + this.key.getJavaTypeMapping().getTypeName());
        }
    }

    @Override
    public MappedTable getIdentityTable() {
        return this.getMappedTable();
    }

    @Override
    public Object accept(PersistentClassVisitor mv) {
        return mv.accept(this);
    }

    @Override
    public ExecuteUpdateResultCheckStyle getUpdateResultCheckStyle() {
        boolean callable;
        String sql = this.getCustomSQLUpdate();
        boolean bl = callable = sql != null && this.isCustomUpdateCallable();
        ExecuteUpdateResultCheckStyle checkStyle = sql == null ? ExecuteUpdateResultCheckStyle.COUNT : (this.getCustomSQLUpdateCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(sql, callable) : this.getCustomSQLUpdateCheckStyle());
        return checkStyle;
    }
}

