/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityGraph;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import org.hibernate.HibernateException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.model.creation.spi.InFlightRuntimeModel;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.spi.AllowableParameterType;
import org.hibernate.metamodel.model.domain.spi.CollectionElementEntity;
import org.hibernate.metamodel.model.domain.spi.CollectionIndexEntity;
import org.hibernate.metamodel.model.domain.spi.EmbeddedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.IdentifiableTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.ManagedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.MappedSuperclassTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.spi.AbstractRuntimeModel;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.query.sqm.tree.domain.SqmPolymorphicRootDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;
import org.hibernate.type.spi.BasicType;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class MetamodelImpl
extends AbstractRuntimeModel
implements MetamodelImplementor,
Serializable {
    private static final Logger log = Logger.getLogger(MetamodelImpl.class);
    public static final String INVALID_IMPORT = "<invalid>";
    private final SessionFactoryImplementor sessionFactory;
    private final TypeConfiguration typeConfiguration;
    private final Map<JavaTypeDescriptor, String> entityProxyInterfaceMap = new ConcurrentHashMap<JavaTypeDescriptor, String>();
    private final Map<String, Set<PersistentCollectionDescriptor<?, ?, ?>>> collectionDescriptorsByEntityParticipant = new ConcurrentHashMap();
    private final Map<JavaTypeDescriptor, SqmPolymorphicRootDescriptor<?>> polymorphicEntityReferenceMap = new HashMap();

    public MetamodelImpl(SessionFactoryImplementor sessionFactory, TypeConfiguration typeConfiguration, InFlightRuntimeModel inFlightModel) {
        super(inFlightModel);
        this.sessionFactory = sessionFactory;
        this.typeConfiguration = typeConfiguration;
        ConcurrentHashMap entityProxyInterfaceMap = new ConcurrentHashMap();
        this.visitEntityDescriptors(entityDescriptor -> {
            Class<?> entityClass = entityDescriptor.getJavaTypeDescriptor().getClass();
            Class proxyClass = entityDescriptor.getConcreteProxyClass();
            if (proxyClass != null && proxyClass.isInterface() && !Map.class.isAssignableFrom(proxyClass)) {
                if (entityClass.equals(proxyClass)) {
                    log.debugf("Entity [%s] mapped same interface [%s] as class and proxy", (Object)entityDescriptor.getEntityName(), entityClass);
                } else {
                    JavaTypeDescriptor proxyTypeDescriptor = typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor(proxyClass, (s, registry) -> null);
                    String old = entityProxyInterfaceMap.put(proxyTypeDescriptor, entityDescriptor.getEntityName());
                    if (old != null) {
                        throw new HibernateException(String.format(Locale.ENGLISH, "Multiple entities [%s, %s] named the same interface [%s] as their proxy which is not supported", old, entityDescriptor.getEntityName(), proxyClass.getName()));
                    }
                }
            }
        });
        this.visitCollectionDescriptors(collectionDescriptor -> {
            EntityTypeDescriptor elementEntityDescriptor;
            if (collectionDescriptor.getElementDescriptor() instanceof CollectionElementEntity) {
                elementEntityDescriptor = ((CollectionElementEntity)collectionDescriptor.getElementDescriptor()).getEntityDescriptor();
                this.collectionDescriptorsByEntityParticipant.computeIfAbsent(elementEntityDescriptor.getNavigableRole().getFullPath(), s -> new HashSet()).add(collectionDescriptor);
            }
            if (collectionDescriptor.getIndexDescriptor() != null && collectionDescriptor.getIndexDescriptor() instanceof CollectionIndexEntity) {
                elementEntityDescriptor = ((CollectionIndexEntity)collectionDescriptor.getIndexDescriptor()).getEntityDescriptor();
                this.collectionDescriptorsByEntityParticipant.computeIfAbsent(elementEntityDescriptor.getNavigableRole().getFullPath(), s -> new HashSet()).add(collectionDescriptor);
            }
        });
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    @Override
    public <X> EntityTypeDescriptor<X> entity(Class<X> cls) {
        EntityTypeDescriptor<X> descriptor = this.getEntityDescriptor(cls);
        if (descriptor == null) {
            throw new IllegalArgumentException("Not an entity: " + cls);
        }
        return descriptor;
    }

    @Override
    public <X> ManagedTypeDescriptor<X> managedType(Class<X> cls) {
        EntityTypeDescriptor<X> entityDescriptor = this.getEntityDescriptor(cls);
        if (entityDescriptor != null) {
            return entityDescriptor;
        }
        EmbeddedTypeDescriptor<X> embeddedDescriptor = this.findEmbeddedDescriptor(cls);
        if (embeddedDescriptor != null) {
            return embeddedDescriptor;
        }
        MappedSuperclassTypeDescriptor<X> msDescriptor = this.findMappedSuperclassDescriptor(cls);
        if (msDescriptor != null) {
            return msDescriptor;
        }
        throw new IllegalArgumentException("Not a managed type: " + cls);
    }

    @Override
    public <X> EmbeddedTypeDescriptor<X> embeddable(Class<X> cls) {
        EmbeddedTypeDescriptor<X> embeddedDescriptor = this.findEmbeddedDescriptor(cls);
        if (embeddedDescriptor != null) {
            return embeddedDescriptor;
        }
        throw new IllegalArgumentException("Not an embeddable: " + cls);
    }

    public Set<ManagedType<?>> getManagedTypes() {
        int setSize = CollectionHelper.determineProperSizing(this.getEntityDescriptorMap().size() + this.getMappedSuperclassDescriptorMap().size() + this.getEmbeddedDescriptorMap().size());
        HashSet managedTypes = new HashSet(setSize);
        managedTypes.addAll(this.getEntityDescriptorMap().values());
        managedTypes.addAll(this.getMappedSuperclassDescriptorMap().values());
        managedTypes.addAll(this.getEmbeddedDescriptorMap().values());
        return managedTypes;
    }

    public Set<EntityType<?>> getEntities() {
        return new HashSet(this.getEntityDescriptorMap().values());
    }

    public Set<EmbeddableType<?>> getEmbeddables() {
        return new HashSet(this.getEmbeddedDescriptorMap().values());
    }

    @Override
    public <X> EntityTypeDescriptor<X> entity(String entityName) {
        EntityTypeDescriptor descriptor = this.findEntityDescriptor(entityName);
        if (descriptor == null) {
            throw new IllegalArgumentException("Not an entity : " + entityName);
        }
        return descriptor;
    }

    @Override
    public Set<PersistentCollectionDescriptor<?, ?, ?>> findCollectionsByEntityParticipant(EntityTypeDescriptor entityDescriptor) {
        Set<PersistentCollectionDescriptor<?, ?, ?>> descriptorSet = this.collectionDescriptorsByEntityParticipant.get(entityDescriptor.getNavigableRole().getFullPath());
        return descriptorSet == null ? Collections.emptySet() : descriptorSet;
    }

    @Override
    public Set<String> findCollectionRolesByEntityParticipant(EntityTypeDescriptor entityDescriptor) {
        HashSet<String> result = new HashSet<String>();
        this.findCollectionsByEntityParticipant(entityDescriptor).forEach(d -> result.add(d.getNavigableRole().getFullPath()));
        return result;
    }

    @Override
    public EntityTypeDescriptor resolveEntityReference(String name) {
        IdentifiableTypeDescriptor descriptor;
        String rename = this.getImportedName(name);
        if (rename != null) {
            name = rename;
        }
        if ((descriptor = this.findEntityDescriptor(name)) != null) {
            return descriptor;
        }
        descriptor = this.findMappedSuperclassDescriptor(name);
        if (descriptor != null) {
            throw new NotYetImplementedFor6Exception();
        }
        Class requestedClass = this.resolveRequestedClass(name);
        if (requestedClass != null) {
            return this.resolveEntityReference(requestedClass);
        }
        throw new IllegalArgumentException("Per JPA spec : no entity named " + name);
    }

    private Class resolveRequestedClass(String entityName) {
        try {
            return this.sessionFactory.getServiceRegistry().getService(ClassLoaderService.class).classForName(entityName);
        }
        catch (ClassLoadingException e) {
            return null;
        }
    }

    @Override
    public String getImportedName(String name) {
        String importedName = this.getNameImportMap().get(name);
        if (INVALID_IMPORT.equals(importedName)) {
            return null;
        }
        if (importedName == null) {
            try {
                this.sessionFactory.getServiceRegistry().getService(ClassLoaderService.class).classForName(name);
                this.getNameImportMap().put(name, name);
                return name;
            }
            catch (ClassLoadingException cnfe) {
                this.getNameImportMap().put(name, INVALID_IMPORT);
                return null;
            }
        }
        return importedName;
    }

    @Override
    public <T> EntityTypeDescriptor<T> resolveEntityReference(Class<T> javaType) {
        if (this.getEntityDescriptorMap().containsKey(javaType.getName())) {
            return this.getEntityDescriptorMap().get(javaType.getName());
        }
        JavaTypeDescriptor<T> jtd = this.typeConfiguration.getJavaTypeDescriptorRegistry().getOrMakeJavaDescriptor(javaType);
        if (jtd == null) {
            throw new HibernateException("Could not locate JavaTypeDescriptor : " + javaType.getName());
        }
        String proxyEntityName = this.entityProxyInterfaceMap.get(jtd);
        if (proxyEntityName != null) {
            return this.getEntityDescriptorMap().get(proxyEntityName);
        }
        if (this.polymorphicEntityReferenceMap.containsKey(jtd)) {
            return this.polymorphicEntityReferenceMap.get(jtd);
        }
        Set<EntityTypeDescriptor<?>> implementors = this.getImplementors(javaType);
        if (!implementors.isEmpty()) {
            SqmPolymorphicRootDescriptor<T> descriptor = new SqmPolymorphicRootDescriptor<T>(jtd, implementors);
            this.polymorphicEntityReferenceMap.put(jtd, descriptor);
            return descriptor;
        }
        throw new IllegalArgumentException("Could not resolve entity reference : " + javaType.getName());
    }

    private Set<EntityTypeDescriptor<?>> getImplementors(Class javaType) {
        EntityTypeDescriptor<?> exactMatch = this.getEntityDescriptorMap().get(javaType.getName());
        if (exactMatch != null) {
            return Collections.singleton(exactMatch);
        }
        HashSet matchingDescriptors = new HashSet();
        for (EntityTypeDescriptor<?> entityDescriptor : this.getEntityDescriptorMap().values()) {
            if (entityDescriptor.getJavaType() == null || !javaType.isAssignableFrom(entityDescriptor.getJavaType())) continue;
            matchingDescriptors.add(entityDescriptor);
        }
        return matchingDescriptors;
    }

    @Override
    public <T> void addNamedEntityGraph(String graphName, RootGraphImplementor<T> entityGraph) {
        RootGraphImplementor<T> old;
        if (entityGraph.isMutable()) {
            entityGraph = entityGraph.makeCopy(false);
        }
        if ((old = this.getRootGraphMap().put(graphName, (RootGraphImplementor<?>)entityGraph)) != null) {
            log.debugf("EntityGraph being replaced on EntityManagerFactory for name %s", (Object)graphName);
        }
    }

    @Override
    public <T> void addNamedEntityGraph(String graphName, EntityGraph<T> entityGraph) {
        this.addNamedEntityGraph(graphName, (RootGraphImplementor)entityGraph);
    }

    @Override
    public <T> RootGraphImplementor<T> findEntityGraphByName(String name) {
        return this.getRootGraphMap().get(name);
    }

    @Override
    public <T> List<RootGraphImplementor<? super T>> findEntityGraphsByJavaType(Class<T> entityClass) {
        EntityDomainType entityType = this.entity(entityClass);
        if (entityType == null) {
            throw new IllegalArgumentException("Given class is not an entity : " + entityClass.getName());
        }
        ArrayList<RootGraphImplementor<T>> results = new ArrayList<RootGraphImplementor<T>>();
        for (EntityGraph entityGraph : this.getRootGraphMap().values()) {
            RootGraphImplementor egi;
            if (!RootGraphImplementor.class.isInstance(entityGraph) || !(egi = (RootGraphImplementor)entityGraph).appliesTo(entityType)) continue;
            results.add(egi);
        }
        return results;
    }

    @Override
    public void close() {
    }

    @Override
    public AllowableParameterType resolveAllowableParamterType(Class clazz) {
        BasicType basicType = this.typeConfiguration.getBasicTypeRegistry().getBasicTypeByName(clazz.getName());
        if (basicType != null) {
            return basicType;
        }
        EntityTypeDescriptor entityDescriptor = this.findEntityDescriptor(clazz);
        if (entityDescriptor != null) {
            return entityDescriptor.getIdentifierDescriptor();
        }
        return this.findEmbeddedDescriptor(clazz);
    }

    @Override
    public <T> void addNamedRootGraph(String graphName, RootGraph<T> entityGraph) {
        this.addNamedEntityGraph(graphName, (RootGraphImplementor)entityGraph);
    }

    @Override
    public RootGraphImplementor findRootGraph(String name) {
        return this.getRootGraphMap().get(name);
    }
}

