/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.convert.internal;

import javax.persistence.AttributeConverter;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.convert.spi.JpaAttributeConverter;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;

public class JpaAttributeConverterImpl<O, R>
implements JpaAttributeConverter<O, R> {
    private final ManagedBean<AttributeConverter<O, R>> attributeConverterBean;
    private final BasicJavaDescriptor<O> domainJavaTypeDescriptor;
    private final BasicJavaDescriptor<R> relationalJavaTypeDescriptor;

    public JpaAttributeConverterImpl(ManagedBean<AttributeConverter<O, R>> attributeConverterBean, JavaTypeDescriptor<O> domainJavaTypeDescriptor, JavaTypeDescriptor<R> relationalJavaTypeDescriptor) {
        this.attributeConverterBean = attributeConverterBean;
        this.domainJavaTypeDescriptor = (BasicJavaDescriptor)domainJavaTypeDescriptor;
        this.relationalJavaTypeDescriptor = (BasicJavaDescriptor)relationalJavaTypeDescriptor;
    }

    @Override
    public ManagedBean<AttributeConverter<O, R>> getConverterBean() {
        return this.attributeConverterBean;
    }

    @Override
    public O toDomainValue(R relationalForm, SharedSessionContractImplementor session) {
        return (O)this.attributeConverterBean.getBeanInstance().convertToEntityAttribute(relationalForm);
    }

    @Override
    public R toRelationalValue(O domainForm, SharedSessionContractImplementor session) {
        return (R)this.attributeConverterBean.getBeanInstance().convertToDatabaseColumn(domainForm);
    }

    @Override
    public BasicJavaDescriptor<O> getDomainJavaDescriptor() {
        return this.domainJavaTypeDescriptor;
    }

    @Override
    public BasicJavaDescriptor<R> getRelationalJavaDescriptor() {
        return this.relationalJavaTypeDescriptor;
    }
}

