/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.convert.internal;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.convert.spi.EnumValueConverter;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.EnumJavaDescriptor;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class NamedEnumValueConverter<E extends Enum>
implements EnumValueConverter<E, String>,
Serializable {
    private static final Logger log = Logger.getLogger(NamedEnumValueConverter.class);
    private final EnumJavaDescriptor<E> enumJavaDescriptor;
    private final BasicJavaDescriptor<String> relationalJavaDescriptor;

    public NamedEnumValueConverter(EnumJavaDescriptor<E> enumJavaDescriptor, TypeConfiguration typeConfiguration) {
        this.enumJavaDescriptor = enumJavaDescriptor;
        this.relationalJavaDescriptor = typeConfiguration.getSqlTypeDescriptorRegistry().getDescriptor(this.getJdbcTypeCode()).getJdbcRecommendedJavaTypeMapping(typeConfiguration);
    }

    @Override
    public E toDomainValue(String relationalForm, SharedSessionContractImplementor session) {
        return this.enumJavaDescriptor.fromName(relationalForm);
    }

    @Override
    public String toRelationalValue(E domainForm, SharedSessionContractImplementor session) {
        return this.enumJavaDescriptor.toName(domainForm);
    }

    @Override
    public int getJdbcTypeCode() {
        return 12;
    }

    @Override
    public EnumJavaDescriptor<E> getDomainJavaDescriptor() {
        return this.enumJavaDescriptor;
    }

    @Override
    public BasicJavaDescriptor<String> getRelationalJavaDescriptor() {
        return this.relationalJavaDescriptor;
    }

    @Override
    public E readValue(ResultSet resultSet, String name, SharedSessionContractImplementor session) throws SQLException {
        String value = resultSet.getString(name);
        boolean traceEnabled = log.isTraceEnabled();
        if (resultSet.wasNull()) {
            if (traceEnabled) {
                log.trace((Object)String.format("Returning null as column [%s]", name));
            }
            return null;
        }
        E enumValue = this.toDomainValue(value, session);
        if (traceEnabled) {
            log.trace((Object)String.format("Returning [%s] as column [%s]", enumValue, name));
        }
        return enumValue;
    }

    @Override
    public void writeValue(PreparedStatement statement, E value, int position, SharedSessionContractImplementor session) throws SQLException {
        String jdbcValue = value == null ? null : this.toRelationalValue(value, session);
        boolean traceEnabled = log.isTraceEnabled();
        if (jdbcValue == null) {
            if (traceEnabled) {
                log.tracef("Binding null to parameter: [%s]", position);
            }
            statement.setNull(position, this.getJdbcTypeCode());
            return;
        }
        if (traceEnabled) {
            log.tracef("Binding [%s] to parameter: [%s]", (Object)jdbcValue, (Object)position);
        }
        statement.setString(position, jdbcValue);
    }

    @Override
    public String toSqlLiteral(Object value) {
        return String.format(Locale.ROOT, "'%s'", ((Enum)value).name());
    }
}

