/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.convert.internal;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.convert.spi.EnumValueConverter;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.EnumJavaDescriptor;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class OrdinalEnumValueConverter<E extends Enum>
implements EnumValueConverter<E, Integer>,
Serializable {
    private static final Logger log = Logger.getLogger(OrdinalEnumValueConverter.class);
    private final EnumJavaDescriptor<E> enumJavaDescriptor;
    private final BasicJavaDescriptor<Integer> relationalJavaDescriptor;

    public OrdinalEnumValueConverter(EnumJavaDescriptor<E> enumJavaDescriptor, RuntimeModelCreationContext creationContext) {
        this(enumJavaDescriptor, creationContext.getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(4).getJdbcRecommendedJavaTypeMapping(creationContext.getTypeConfiguration()));
    }

    public OrdinalEnumValueConverter(EnumJavaDescriptor<E> enumJavaDescriptor, TypeConfiguration typeConfiguration) {
        this(enumJavaDescriptor, typeConfiguration.getSqlTypeDescriptorRegistry().getDescriptor(4).getJdbcRecommendedJavaTypeMapping(typeConfiguration));
    }

    public OrdinalEnumValueConverter(EnumJavaDescriptor<E> enumJavaDescriptor, BasicJavaDescriptor<Integer> relationalJavaDescriptor) {
        this.enumJavaDescriptor = enumJavaDescriptor;
        this.relationalJavaDescriptor = relationalJavaDescriptor;
    }

    @Override
    public E toDomainValue(Integer relationalForm, SharedSessionContractImplementor session) {
        return this.enumJavaDescriptor.fromOrdinal(relationalForm);
    }

    @Override
    public Integer toRelationalValue(E domainForm, SharedSessionContractImplementor session) {
        return this.enumJavaDescriptor.toOrdinal(domainForm);
    }

    @Override
    public int getJdbcTypeCode() {
        return 4;
    }

    @Override
    public EnumJavaDescriptor<E> getDomainJavaDescriptor() {
        return this.enumJavaDescriptor;
    }

    @Override
    public BasicJavaDescriptor<Integer> getRelationalJavaDescriptor() {
        return this.relationalJavaDescriptor;
    }

    @Override
    public E readValue(ResultSet resultSet, String name, SharedSessionContractImplementor session) throws SQLException {
        int ordinal = resultSet.getInt(name);
        boolean traceEnabled = log.isTraceEnabled();
        if (resultSet.wasNull()) {
            if (traceEnabled) {
                log.trace((Object)String.format("Returning null as column [%s]", name));
            }
            return null;
        }
        E enumValue = this.toDomainValue(ordinal, session);
        if (traceEnabled) {
            log.trace((Object)String.format("Returning [%s] as column [%s]", enumValue, name));
        }
        return enumValue;
    }

    @Override
    public void writeValue(PreparedStatement statement, E value, int position, SharedSessionContractImplementor session) throws SQLException {
        Integer jdbcValue = value == null ? null : this.toRelationalValue(value, session);
        boolean traceEnabled = log.isTraceEnabled();
        if (jdbcValue == null) {
            if (traceEnabled) {
                log.tracef("Binding null to parameter: [%s]", position);
            }
            statement.setNull(position, this.getJdbcTypeCode());
            return;
        }
        if (traceEnabled) {
            log.tracef("Binding [%s] to parameter: [%s]", jdbcValue.intValue(), position);
        }
        statement.setInt(position, jdbcValue);
    }

    @Override
    public String toSqlLiteral(Object value) {
        return Integer.toString(((Enum)value).ordinal());
    }
}

