/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.creation.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.boot.model.domain.EntityMapping;
import org.hibernate.boot.model.domain.MappedSuperclassMapping;
import org.hibernate.boot.model.domain.spi.EmbeddedValueMappingImplementor;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelDescriptorClassResolver;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelDescriptorFactory;
import org.hibernate.metamodel.model.domain.spi.EmbeddedContainer;
import org.hibernate.metamodel.model.domain.spi.EmbeddedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.IdentifiableTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.ManagedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.MappedSuperclassTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.domain.spi.SingularPersistentAttribute;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public final class RuntimeModelDescriptorFactoryImpl
implements RuntimeModelDescriptorFactory,
ServiceRegistryAwareService {
    private RuntimeModelDescriptorClassResolver descriptorClassResolver;
    @Deprecated
    public static final Class[] ENTITY_PERSISTER_CONSTRUCTOR_ARGS = EntityTypeDescriptor.STANDARD_CONSTRUCTOR_SIG;
    @Deprecated
    public static final Class[] COLLECTION_PERSISTER_CONSTRUCTOR_ARGS = PersistentCollectionDescriptor.CONSTRUCTOR_SIGNATURE;

    @Override
    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.descriptorClassResolver = serviceRegistry.getService(RuntimeModelDescriptorClassResolver.class);
    }

    @Override
    public <J> EntityTypeDescriptor<J> createEntityDescriptor(EntityMapping bootMapping, IdentifiableTypeDescriptor superTypeDescriptor, RuntimeModelCreationContext creationContext) {
        return this.instantiateEntityDescriptor(bootMapping, superTypeDescriptor, creationContext);
    }

    private EntityTypeDescriptor instantiateEntityDescriptor(EntityMapping bootMapping, IdentifiableTypeDescriptor superTypeDescriptor, RuntimeModelCreationContext creationContext) {
        Class<? extends EntityTypeDescriptor> entityDescriptorClass = bootMapping.getRuntimeEntityDescriptorClass();
        if (entityDescriptorClass == null) {
            entityDescriptorClass = this.descriptorClassResolver.getEntityDescriptorClass(bootMapping);
        }
        return this.instantiateEntityDescriptor(entityDescriptorClass, bootMapping, superTypeDescriptor, creationContext);
    }

    private EntityTypeDescriptor instantiateEntityDescriptor(Class<? extends EntityTypeDescriptor> persisterClass, EntityMapping bootMapping, IdentifiableTypeDescriptor superTypeDescriptor, RuntimeModelCreationContext creationContext) {
        try {
            Constructor<? extends EntityTypeDescriptor> constructor = persisterClass.getConstructor(EntityTypeDescriptor.STANDARD_CONSTRUCTOR_SIG);
            try {
                return constructor.newInstance(bootMapping, superTypeDescriptor, creationContext);
            }
            catch (MappingException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof HibernateException) {
                    throw (HibernateException)((Object)target);
                }
                throw new MappingException("Could not instantiate persister " + persisterClass.getName(), target);
            }
            catch (Exception e) {
                throw new MappingException("Could not instantiate persister " + persisterClass.getName(), e);
            }
        }
        catch (MappingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MappingException("Could not get constructor for " + persisterClass.getName(), e);
        }
    }

    @Override
    public <J> MappedSuperclassTypeDescriptor<J> createMappedSuperclassDescriptor(MappedSuperclassMapping bootMapping, IdentifiableTypeDescriptor superTypeDescriptor, RuntimeModelCreationContext creationContext) throws HibernateException {
        return this.instantiateMappedSuperclassDescriptor(bootMapping, superTypeDescriptor, creationContext);
    }

    private MappedSuperclassTypeDescriptor instantiateMappedSuperclassDescriptor(MappedSuperclassMapping bootMapping, IdentifiableTypeDescriptor superTypeDescriptor, RuntimeModelCreationContext creationContext) {
        Class<? extends MappedSuperclassTypeDescriptor> runtimeDescriptorClass = this.descriptorClassResolver.getMappedSuperclassDescriptorClass(bootMapping);
        return this.instantiateMappedSuperclassDescriptor(runtimeDescriptorClass, bootMapping, superTypeDescriptor, creationContext);
    }

    private MappedSuperclassTypeDescriptor instantiateMappedSuperclassDescriptor(Class<? extends MappedSuperclassTypeDescriptor> descriptorClass, MappedSuperclassMapping bootMapping, IdentifiableTypeDescriptor superTypeDescriptor, RuntimeModelCreationContext creationContext) {
        try {
            Constructor<? extends MappedSuperclassTypeDescriptor> constructor = descriptorClass.getConstructor(MappedSuperclassTypeDescriptor.STANDARD_CONSTRUCTOR_SIG);
            try {
                MappedSuperclassTypeDescriptor descriptor = constructor.newInstance(bootMapping, superTypeDescriptor, creationContext);
                creationContext.registerMappedSuperclassDescriptor(descriptor, bootMapping);
                return descriptor;
            }
            catch (MappingException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof HibernateException) {
                    throw (HibernateException)((Object)target);
                }
                throw new MappingException("Could not instantiate persister " + descriptorClass.getName(), target);
            }
            catch (Exception e) {
                throw new MappingException("Could not instantiate persister " + descriptorClass.getName(), e);
            }
        }
        catch (MappingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MappingException("Could not get constructor for " + descriptorClass.getName(), e);
        }
    }

    @Override
    public <O, C, E> PersistentCollectionDescriptor<O, C, E> createPersistentCollectionDescriptor(Property pluralProperty, ManagedTypeDescriptor<O> runtimeManagedType, RuntimeModelCreationContext creationContext) throws HibernateException {
        Collection collectionMapping = (Collection)pluralProperty.getValue();
        Class<? extends PersistentCollectionDescriptor> persisterClass = collectionMapping.getCollectionPersisterClass();
        if (persisterClass == null) {
            persisterClass = this.descriptorClassResolver.getCollectionDescriptorClass(collectionMapping);
        }
        return this.createCollectionDescriptor(persisterClass, pluralProperty, collectionMapping, runtimeManagedType, creationContext);
    }

    private PersistentCollectionDescriptor createCollectionDescriptor(Class<? extends PersistentCollectionDescriptor> persisterClass, Property pluralProperty, Collection collectionBinding, ManagedTypeDescriptor runtimeManagedType, RuntimeModelCreationContext creationContext) {
        try {
            Constructor<? extends PersistentCollectionDescriptor> constructor = persisterClass.getConstructor(PersistentCollectionDescriptor.CONSTRUCTOR_SIGNATURE);
            try {
                PersistentCollectionDescriptor descriptor = constructor.newInstance(pluralProperty, runtimeManagedType, creationContext);
                creationContext.registerCollectionDescriptor(descriptor, collectionBinding);
                return descriptor;
            }
            catch (MappingException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof HibernateException) {
                    throw (HibernateException)((Object)target);
                }
                throw new MappingException("Could not instantiate collection persister " + persisterClass.getName(), target);
            }
            catch (Exception e) {
                throw new MappingException("Could not instantiate collection persister " + persisterClass.getName(), e);
            }
        }
        catch (MappingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MappingException("Could not get constructor for " + persisterClass.getName(), e);
        }
    }

    public EmbeddedTypeDescriptor createEmbeddedTypeDescriptor(EmbeddedValueMappingImplementor bootValueMapping, EmbeddedContainer source, EmbeddedTypeDescriptor superTypeDescriptor, String localName, SingularPersistentAttribute.Disposition disposition, RuntimeModelCreationContext creationContext) {
        Class<? extends EmbeddedTypeDescriptor> persisterClass = this.descriptorClassResolver.getEmbeddedTypeDescriptorClass(bootValueMapping);
        try {
            Constructor<? extends EmbeddedTypeDescriptor> constructor = persisterClass.getConstructor(EmbeddedTypeDescriptor.STANDARD_CTOR_SIGNATURE);
            try {
                EmbeddedTypeDescriptor descriptor = constructor.newInstance(new Object[]{bootValueMapping, source, superTypeDescriptor, localName, disposition, creationContext});
                creationContext.registerEmbeddableDescriptor(descriptor, bootValueMapping);
                return descriptor;
            }
            catch (MappingException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof HibernateException) {
                    throw (HibernateException)((Object)target);
                }
                throw new MappingException("Could not instantiate embedded persister " + persisterClass.getName(), target);
            }
            catch (Exception e) {
                throw new MappingException("Could not instantiate embedded persister " + persisterClass.getName(), e);
            }
        }
        catch (MappingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MappingException("Could not get constructor for " + persisterClass.getName(), e);
        }
    }
}

