/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.creation.spi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.boot.model.relational.MappedColumn;
import org.hibernate.boot.model.relational.MappedForeignKey;
import org.hibernate.boot.model.relational.MappedTable;
import org.hibernate.mapping.Selectable;
import org.hibernate.metamodel.model.creation.spi.DatabaseObjectResolver;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.ForeignKey;
import org.hibernate.metamodel.model.relational.spi.RuntimeDatabaseModelProducer;
import org.hibernate.metamodel.model.relational.spi.Table;

public class DatabaseObjectResolutionContextImpl
implements DatabaseObjectResolver,
RuntimeDatabaseModelProducer.Callback {
    private final Map<MappedTable, Table> runtimeTableByBootTable = new HashMap<MappedTable, Table>();
    private final Map<MappedColumn, Column> columnMap = new HashMap<MappedColumn, Column>();
    private final Map<MappedForeignKey, ForeignKey> foreignKeyMap = new IdentityHashMap<MappedForeignKey, ForeignKey>();

    @Override
    public void tableBuilt(MappedTable mappedTable, Table table) {
        this.runtimeTableByBootTable.put(mappedTable, table);
    }

    @Override
    public void columnBuilt(MappedColumn mappedColumn, Column column) {
        this.columnMap.put(mappedColumn, column);
    }

    @Override
    public void foreignKeyBuilt(MappedForeignKey mappedFk, ForeignKey runtimeFk) {
        this.foreignKeyMap.put(mappedFk, runtimeFk);
    }

    @Override
    public Table resolveTable(MappedTable mappedTable) {
        return this.runtimeTableByBootTable.get(mappedTable);
    }

    @Override
    public Column resolveColumn(MappedColumn mappedColumn) {
        return this.columnMap.get(mappedColumn);
    }

    @Override
    public ForeignKey resolveForeignKey(MappedForeignKey bootForeignKey) {
        return this.foreignKeyMap.get(bootForeignKey);
    }

    @Override
    public ForeignKey.ColumnMappings resolveColumnMappings(List<Selectable> columns, List<Selectable> otherColumns) {
        if (columns == null || columns.isEmpty()) {
            throw new IllegalArgumentException("`columns` was null or empty");
        }
        if (otherColumns == null || otherColumns.isEmpty()) {
            throw new IllegalArgumentException("`otherColumns` was null or empty");
        }
        if (columns.size() != otherColumns.size()) {
            throw new IllegalArgumentException("`columns` and `otherColumns` had different sizes");
        }
        Table referencingTable = null;
        Table targetTable = null;
        ArrayList<Column> referencingColumns = new ArrayList<Column>();
        ArrayList<Column> targetColumns = new ArrayList<Column>();
        for (int i = 0; i < columns.size(); ++i) {
            MappedColumn bootReferencingColumn = columns.get(i);
            MappedColumn bootTargetColumn = otherColumns.get(i);
            Column referencingColumn = this.resolveColumn(bootReferencingColumn);
            Column targetColumn = this.resolveColumn(bootTargetColumn);
            if (referencingTable == null) {
                assert (targetTable == null);
                referencingTable = referencingColumn.getSourceTable();
                targetTable = targetColumn.getSourceTable();
            }
            referencingColumns.add(referencingColumn);
            targetColumns.add(targetColumn);
        }
        ForeignKey matchedFk = null;
        block1: for (ForeignKey foreignKey : referencingTable.getForeignKeys()) {
            ForeignKey.ColumnMappings mappings = foreignKey.getColumnMappings();
            for (ForeignKey.ColumnMappings.ColumnMapping columnMapping : mappings.getColumnMappings()) {
                int matchedPosition = referencingColumns.indexOf(columnMapping.getReferringColumn());
                if (matchedPosition == -1) continue block1;
                Column correspondingTargetColumn = (Column)targetColumns.get(matchedPosition);
                if (columnMapping.getTargetColumn().equals(correspondingTargetColumn)) continue;
                continue block1;
            }
            matchedFk = foreignKey;
            break;
        }
        if (matchedFk == null) {
            // empty if block
        }
        return matchedFk.getColumnMappings();
    }
}

