/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.creation.spi;

import java.util.Map;
import javax.persistence.EntityGraph;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.metamodel.internal.MetamodelImpl;
import org.hibernate.metamodel.model.domain.spi.EmbeddedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.EntityHierarchy;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.MappedSuperclassTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.spi.AbstractRuntimeModel;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.jboss.logging.Logger;

public class InFlightRuntimeModel
extends AbstractRuntimeModel {
    private static final Logger log = Logger.getLogger(InFlightRuntimeModel.class);

    public InFlightRuntimeModel(Map<String, String> hqlNameImports) {
        hqlNameImports.forEach((k, v) -> this.getNameImportMap().putIfAbsent((String)k, (String)v));
    }

    public InFlightRuntimeModel(MetadataBuildingContext metadataBuildingContext) {
        this(metadataBuildingContext.getMetadataCollector().getImports());
    }

    public void addEntityHierarchy(EntityHierarchy hierarchy) {
        boolean add = this.getEntityHierarchySet().add(hierarchy);
        if (add) {
            log.debugf("Added EntityHierarchy : %s", (Object)hierarchy);
        } else {
            log.debugf("EntityHierarchy [%s] was already registered", new Object[0]);
        }
    }

    public <T> void addEntityDescriptor(EntityTypeDescriptor<T> descriptor) {
        EntityTypeDescriptor<T> previous = this.getEntityDescriptorMap().put(descriptor.getNavigableRole().getFullPath(), descriptor);
        if (previous != null) {
            log.debugf("Adding EntityDescriptor [%s] replaced existing registration [%s]", descriptor, previous);
        }
    }

    public <T> void addMappedSuperclassDescriptor(MappedSuperclassTypeDescriptor<T> descriptor) {
        MappedSuperclassTypeDescriptor<T> previous = this.getMappedSuperclassDescriptorMap().put(descriptor.getNavigableRole().getFullPath(), descriptor);
        if (previous != null) {
            log.debugf("Adding MappedSuperclassDescriptor [%s] replaced existing registration [%s]", descriptor, previous);
        }
    }

    public <T> void addEmbeddedDescriptor(EmbeddedTypeDescriptor<T> descriptor) {
        EmbeddedTypeDescriptor<T> previous = this.getEmbeddedDescriptorMap().put(descriptor.getJavaTypeDescriptor().getTypeName(), descriptor);
        if (previous != null) {
            log.debugf("Adding EmbeddedTypeDescriptor [%s] replaced existing registration [%s]", descriptor, previous);
        }
    }

    public <O, C, E> void addCollectionDescriptor(PersistentCollectionDescriptor<O, C, E> descriptor) {
        PersistentCollectionDescriptor<O, C, E> previous = this.getCollectionDescriptorMap().put(descriptor.getNavigableRole().getFullPath(), descriptor);
        if (previous != null) {
            log.debugf("Adding PersistentCollectionDescriptor [%s] replaced existing registration [%s]", descriptor, previous);
        }
    }

    public void addNamedRootGraph(String name, RootGraphImplementor rootGraph) {
        EntityGraph previous = this.getRootGraphMap().put(name, rootGraph);
        if (previous != null) {
            log.debugf("Adding EntityGraph [%s -> %s] replaced existing registration [%s]", (Object)name, (Object)rootGraph, (Object)previous);
        }
    }

    public MetamodelImplementor complete(SessionFactoryImplementor sessionFactory, MetadataBuildingContext metadataBuildingContext) {
        return new MetamodelImpl(sessionFactory, metadataBuildingContext.getBootstrapContext().getTypeConfiguration(), this);
    }
}

