/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.creation.spi;

import org.hibernate.boot.model.convert.spi.JpaAttributeConverterCreationContext;
import org.hibernate.boot.model.domain.EntityMapping;
import org.hibernate.boot.model.domain.EntityMappingHierarchy;
import org.hibernate.boot.model.domain.MappedSuperclassMapping;
import org.hibernate.boot.model.domain.spi.EmbeddedValueMappingImplementor;
import org.hibernate.boot.model.relational.MappedTable;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.collection.spi.CollectionSemanticsResolver;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.id.factory.spi.MutableIdentifierGeneratorFactory;
import org.hibernate.mapping.Collection;
import org.hibernate.metamodel.internal.JpaStaticMetaModelPopulationSetting;
import org.hibernate.metamodel.model.creation.spi.DatabaseObjectResolver;
import org.hibernate.metamodel.model.creation.spi.InFlightRuntimeModel;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelDescriptorFactory;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.model.domain.spi.EmbeddedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.EntityHierarchy;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.ManagedTypeRepresentationResolver;
import org.hibernate.metamodel.model.domain.spi.MappedSuperclassTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.relational.spi.DatabaseModel;
import org.hibernate.metamodel.model.relational.spi.Namespace;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptorRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public interface RuntimeModelCreationContext
extends JpaAttributeConverterCreationContext {
    public SessionFactoryImplementor getSessionFactory();

    public BootstrapContext getBootstrapContext();

    public TypeConfiguration getTypeConfiguration();

    public MetadataImplementor getMetadata();

    public InFlightRuntimeModel getInFlightRuntimeModel();

    public DatabaseModel getDatabaseModel();

    public DatabaseObjectResolver getDatabaseObjectResolver();

    public JpaStaticMetaModelPopulationSetting getJpaStaticMetaModelPopulationSetting();

    public RuntimeModelDescriptorFactory getRuntimeModelDescriptorFactory();

    public ManagedTypeRepresentationResolver getRepresentationStrategySelector();

    default public IdentifierGeneratorFactory getIdentifierGeneratorFactory() {
        return this.getSessionFactory().getServiceRegistry().getService(MutableIdentifierGeneratorFactory.class);
    }

    public CollectionSemanticsResolver getCollectionSemanticsResolver();

    @Override
    default public ManagedBeanRegistry getManagedBeanRegistry() {
        return this.getSessionFactory().getServiceRegistry().getService(ManagedBeanRegistry.class);
    }

    @Override
    default public JavaTypeDescriptorRegistry getJavaTypeDescriptorRegistry() {
        return this.getTypeConfiguration().getJavaTypeDescriptorRegistry();
    }

    public void registerEntityHierarchy(EntityHierarchy var1, EntityMappingHierarchy var2);

    public void registerEntityDescriptor(EntityTypeDescriptor var1, EntityMapping var2);

    public void registerMappedSuperclassDescriptor(MappedSuperclassTypeDescriptor var1, MappedSuperclassMapping var2);

    public void registerCollectionDescriptor(PersistentCollectionDescriptor var1, Collection var2);

    public void registerEmbeddableDescriptor(EmbeddedTypeDescriptor var1, EmbeddedValueMappingImplementor var2);

    public void registerNavigable(Navigable var1, Object var2);

    default public Table resolve(MappedTable mappedTable) {
        Namespace namespace = this.getDatabaseModel().getNamespace(mappedTable.getCatalog(), mappedTable.getSchema());
        return (Table)namespace.getTable(mappedTable.getUid());
    }

    public EntityDataAccess getEntityCacheAccess(NavigableRole var1);

    public NaturalIdDataAccess getNaturalIdCacheAccess(NavigableRole var1);

    public CollectionDataAccess getCollectionCacheAccess(NavigableRole var1);
}

