/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.creation.spi;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.persistence.NamedAttributeNode;
import javax.persistence.NamedEntityGraph;
import javax.persistence.NamedSubgraph;
import javax.persistence.metamodel.Attribute;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.boot.model.domain.EntityMapping;
import org.hibernate.boot.model.domain.EntityMappingHierarchy;
import org.hibernate.boot.model.domain.IdentifiableTypeMapping;
import org.hibernate.boot.model.domain.MappedSuperclassMapping;
import org.hibernate.boot.model.domain.ResolutionContext;
import org.hibernate.boot.model.domain.spi.EmbeddedValueMappingImplementor;
import org.hibernate.boot.model.domain.spi.IdentifiableTypeMappingImplementor;
import org.hibernate.boot.model.domain.spi.ManagedTypeMappingImplementor;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.cache.cfg.internal.DomainDataRegionConfigImpl;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.cfg.annotations.NamedEntityGraphDefinition;
import org.hibernate.collection.spi.CollectionSemanticsResolver;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.graph.AttributeNode;
import org.hibernate.graph.SubGraph;
import org.hibernate.graph.internal.RootGraphImpl;
import org.hibernate.graph.spi.GraphImplementor;
import org.hibernate.graph.spi.SubGraphImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.RootClass;
import org.hibernate.metamodel.internal.JpaStaticMetaModelPopulationSetting;
import org.hibernate.metamodel.model.creation.spi.DatabaseObjectResolutionContextImpl;
import org.hibernate.metamodel.model.creation.spi.DatabaseObjectResolver;
import org.hibernate.metamodel.model.creation.spi.InFlightRuntimeModel;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelDescriptorFactory;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.model.domain.spi.EmbeddedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.EntityHierarchy;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.IdentifiableTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.ManagedTypeRepresentationResolver;
import org.hibernate.metamodel.model.domain.spi.MappedSuperclassTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.relational.spi.DatabaseModel;
import org.hibernate.metamodel.model.relational.spi.RuntimeDatabaseModelProducer;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.tool.schema.spi.SchemaManagementToolCoordinator;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class RuntimeModelCreationProcess
implements ResolutionContext {
    private static final Logger log = Logger.getLogger(RuntimeModelCreationProcess.class);
    private final SessionFactoryImplementor sessionFactory;
    private final BootstrapContext bootstrapContext;
    private final MetadataBuildingContext metadataBuildingContext;
    private final InFlightRuntimeModel inFlightRuntimeModel;
    private final RuntimeModelDescriptorFactory descriptorFactory;
    private final Map<EntityMappingHierarchy, IdentifiableTypeDescriptor> runtimeRootByBootHierarchy = new LinkedHashMap<EntityMappingHierarchy, IdentifiableTypeDescriptor>();
    private final Map<EntityMappingHierarchy, EntityTypeDescriptor> runtimeRootEntityByBootHierarchy = new LinkedHashMap<EntityMappingHierarchy, EntityTypeDescriptor>();
    private final Map<IdentifiableTypeMappingImplementor, IdentifiableTypeDescriptor> runtimeByBoot = new LinkedHashMap<IdentifiableTypeMappingImplementor, IdentifiableTypeDescriptor>();
    private final Map<IdentifiableTypeDescriptor, IdentifiableTypeMappingImplementor> bootByRuntime = new LinkedHashMap<IdentifiableTypeDescriptor, IdentifiableTypeMappingImplementor>();
    private final Map<EmbeddedValueMappingImplementor, EmbeddedTypeDescriptor> embeddableRuntimeByBoot = new LinkedHashMap<EmbeddedValueMappingImplementor, EmbeddedTypeDescriptor>();
    private final Map<Collection, PersistentCollectionDescriptor> collectionRuntimeByBoot = new LinkedHashMap<Collection, PersistentCollectionDescriptor>();
    private final Map<String, DomainDataRegionConfigImpl.Builder> regionConfigBuilders = new ConcurrentHashMap<String, DomainDataRegionConfigImpl.Builder>();
    private final Map<Navigable, Object> navigablesToFinalize = new LinkedHashMap<Navigable, Object>();

    public static MetamodelImplementor execute(SessionFactoryImplementor sessionFactory, BootstrapContext bootstrapContext, MetadataBuildingContext metadataBuildingContext) {
        return new RuntimeModelCreationProcess(sessionFactory, bootstrapContext, metadataBuildingContext).execute();
    }

    private RuntimeModelCreationProcess(SessionFactoryImplementor sessionFactory, BootstrapContext bootstrapContext, MetadataBuildingContext metadataBuildingContext) {
        this.sessionFactory = sessionFactory;
        this.bootstrapContext = bootstrapContext;
        this.metadataBuildingContext = metadataBuildingContext;
        this.inFlightRuntimeModel = new InFlightRuntimeModel(metadataBuildingContext);
        this.descriptorFactory = sessionFactory.getServiceRegistry().getService(RuntimeModelDescriptorFactory.class);
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public BootstrapContext getBootstrapContext() {
        return this.bootstrapContext;
    }

    @Override
    public MetadataBuildingContext getMetadataBuildingContext() {
        return this.metadataBuildingContext;
    }

    public MetamodelImplementor execute() {
        RuntimeModelCreationContextImpl creationContext;
        DatabaseModel databaseModel;
        InFlightMetadataCollector mappingMetadata;
        block11: {
            boolean anyNavigablesFinalized;
            boolean bl;
            boolean anyEmbeddablesFinalized;
            mappingMetadata = this.metadataBuildingContext.getMetadataCollector();
            DatabaseObjectResolutionContextImpl dbObjectResolver = new DatabaseObjectResolutionContextImpl();
            databaseModel = new RuntimeDatabaseModelProducer(this.metadataBuildingContext.getBootstrapContext()).produceDatabaseModel(mappingMetadata.getDatabase(), dbObjectResolver, dbObjectResolver);
            JpaStaticMetaModelPopulationSetting jpaMetaModelPopulationSetting = JpaStaticMetaModelPopulationSetting.determineJpaMetaModelPopulationSetting(this.sessionFactory.getProperties());
            creationContext = new RuntimeModelCreationContextImpl(mappingMetadata, databaseModel, jpaMetaModelPopulationSetting, dbObjectResolver);
            for (EntityMappingHierarchy entityMappingHierarchy : mappingMetadata.getEntityHierarchies()) {
                EntityTypeDescriptor rootEntityDescriptor = (EntityTypeDescriptor)this.createIdentifiableType(entityMappingHierarchy.getRootType(), null, creationContext);
                if (this.runtimeRootEntityByBootHierarchy.containsKey(entityMappingHierarchy) || this.runtimeRootByBootHierarchy.containsKey(entityMappingHierarchy)) {
                    throw new HibernateException("Entity boot hierarchy was encountered twice while transforming to runtime model : " + entityMappingHierarchy.getRootType().getName());
                }
                this.runtimeRootEntityByBootHierarchy.put(entityMappingHierarchy, rootEntityDescriptor);
                creationContext.registerEntityHierarchy(rootEntityDescriptor.getHierarchy(), entityMappingHierarchy);
                this.walkSupers(entityMappingHierarchy, entityMappingHierarchy.getRootType(), rootEntityDescriptor.getHierarchy(), rootEntityDescriptor, creationContext);
                this.walkSubs(entityMappingHierarchy.getRootType(), rootEntityDescriptor.getHierarchy(), rootEntityDescriptor, creationContext);
            }
            for (Map.Entry entry2 : this.runtimeRootByBootHierarchy.entrySet()) {
                EntityTypeDescriptor runtimeRootEntity = this.runtimeRootEntityByBootHierarchy.get(entry2.getKey());
                IdentifiableTypeDescriptor runtimeRootRoot = (IdentifiableTypeDescriptor)entry2.getValue();
                RootClass bootRootEntity = (RootClass)this.bootByRuntime.get(runtimeRootEntity);
                this.finishInitialization(runtimeRootRoot, this.bootByRuntime.get(runtimeRootRoot), creationContext);
                runtimeRootEntity.getHierarchy().finishInitialization(creationContext, bootRootEntity);
            }
            do {
                LinkedHashMap<Object, Object> copy;
                anyEmbeddablesFinalized = false;
                bl = false;
                anyNavigablesFinalized = false;
                if (!this.embeddableRuntimeByBoot.isEmpty()) {
                    copy = new LinkedHashMap<EmbeddedValueMappingImplementor, EmbeddedTypeDescriptor>(this.embeddableRuntimeByBoot);
                    this.embeddableRuntimeByBoot.clear();
                    anyEmbeddablesFinalized = copy.entrySet().removeIf(entry -> ((EmbeddedTypeDescriptor)entry.getValue()).finishInitialization((ManagedTypeMappingImplementor)entry.getKey(), creationContext));
                    if (!copy.isEmpty()) {
                        this.embeddableRuntimeByBoot.putAll(copy);
                    }
                }
                if (!this.collectionRuntimeByBoot.isEmpty()) {
                    copy = new LinkedHashMap<Collection, PersistentCollectionDescriptor>(this.collectionRuntimeByBoot);
                    this.collectionRuntimeByBoot.clear();
                    bl = copy.entrySet().removeIf(entry -> ((PersistentCollectionDescriptor)entry.getValue()).finishInitialization((Collection)entry.getKey(), creationContext));
                    if (!copy.isEmpty()) {
                        this.collectionRuntimeByBoot.putAll(copy);
                    }
                }
                if (!this.navigablesToFinalize.isEmpty()) {
                    copy = new LinkedHashMap<Navigable, Object>(this.navigablesToFinalize);
                    this.navigablesToFinalize.clear();
                    anyNavigablesFinalized = copy.entrySet().removeIf(entry -> ((Navigable)entry.getKey()).finishInitialization(entry.getValue(), creationContext));
                    if (!copy.isEmpty()) {
                        this.navigablesToFinalize.putAll(copy);
                    }
                }
                if (this.embeddableRuntimeByBoot.isEmpty() && this.collectionRuntimeByBoot.isEmpty() && this.navigablesToFinalize.isEmpty()) break block11;
            } while (anyEmbeddablesFinalized || bl || anyNavigablesFinalized);
            throw new MappingException("Unable to complete initialization of run-time meta-model");
        }
        for (Map.Entry<EntityMappingHierarchy, IdentifiableTypeDescriptor> entry3 : this.runtimeRootByBootHierarchy.entrySet()) {
            EntityTypeDescriptor runtimeRootEntity = this.runtimeRootEntityByBootHierarchy.get(entry3.getKey());
            runtimeRootEntity.postInitialization(creationContext);
        }
        this.descriptorFactory.finishUp(creationContext);
        SchemaManagementToolCoordinator.process(databaseModel, this.sessionFactory.getServiceRegistry(), action -> this.sessionFactory.addObserver(action));
        mappingMetadata.getNamedEntityGraphs().values().forEach(this::applyNamedEntityGraph);
        this.sessionFactory.getCache().prime(this.regionConfigBuilders.values().stream().map(DomainDataRegionConfigImpl.Builder::build).collect(Collectors.toSet()));
        return this.inFlightRuntimeModel.complete(this.sessionFactory, this.metadataBuildingContext);
    }

    private void walkSupers(EntityMappingHierarchy bootHierarchy, IdentifiableTypeMappingImplementor bootMapping, EntityHierarchy runtimeHierarchy, IdentifiableTypeDescriptor<?> runtimeMapping, RuntimeModelCreationContext creationContext) {
        assert (bootHierarchy != null);
        assert (bootMapping != null);
        assert (runtimeHierarchy != null);
        assert (runtimeMapping != null);
        if (runtimeMapping instanceof EntityTypeDescriptor) {
            creationContext.registerEntityDescriptor((EntityTypeDescriptor)runtimeMapping, (EntityMapping)((Object)bootMapping));
        }
        if (bootMapping.getSuperTypeMapping() == null) {
            this.runtimeRootByBootHierarchy.put(bootHierarchy, runtimeMapping);
        } else {
            IdentifiableTypeDescriptor<?> runtimeSuperDescriptor = this.createIdentifiableType((IdentifiableTypeMappingImplementor)bootMapping.getSuperTypeMapping(), runtimeMapping, creationContext);
            this.walkSupers(bootHierarchy, (IdentifiableTypeMappingImplementor)bootMapping.getSuperTypeMapping(), runtimeHierarchy, runtimeSuperDescriptor, creationContext);
        }
    }

    private void walkSubs(IdentifiableTypeMappingImplementor bootMapping, EntityHierarchy runtimeHierarchy, IdentifiableTypeDescriptor runtimeDescriptor, RuntimeModelCreationContext creationContext) {
        for (IdentifiableTypeMapping bootSubTypeMapping : bootMapping.getSubTypeMappings()) {
            IdentifiableTypeDescriptor<?> runtimeSubclassDescriptor = this.createIdentifiableType((IdentifiableTypeMappingImplementor)bootSubTypeMapping, runtimeDescriptor, creationContext);
            this.walkSubs((IdentifiableTypeMappingImplementor)bootSubTypeMapping, runtimeHierarchy, runtimeSubclassDescriptor, creationContext);
        }
    }

    private IdentifiableTypeDescriptor<?> createIdentifiableType(IdentifiableTypeMappingImplementor bootMapping, IdentifiableTypeDescriptor superTypeDescriptor, RuntimeModelCreationContext creationContext) {
        IdentifiableTypeDescriptor runtimeType = bootMapping.makeRuntimeDescriptor(superTypeDescriptor, creationContext);
        this.bootByRuntime.put(runtimeType, bootMapping);
        this.runtimeByBoot.put(bootMapping, runtimeType);
        if (runtimeType instanceof EntityTypeDescriptor) {
            creationContext.registerEntityDescriptor((EntityTypeDescriptor)runtimeType, (EntityMapping)((Object)bootMapping));
        } else if (runtimeType instanceof MappedSuperclassTypeDescriptor) {
            creationContext.registerMappedSuperclassDescriptor((MappedSuperclassTypeDescriptor)runtimeType, (MappedSuperclassMapping)((Object)bootMapping));
        }
        return runtimeType;
    }

    private void finishInitialization(IdentifiableTypeDescriptor runtimeType, IdentifiableTypeMappingImplementor bootType, RuntimeModelCreationContext creationContext) {
        runtimeType.finishInitialization(bootType, creationContext);
        for (IdentifiableTypeMapping subTypeMapping : bootType.getSubTypeMappings()) {
            this.finishInitialization(this.runtimeByBoot.get(subTypeMapping), (IdentifiableTypeMappingImplementor)subTypeMapping, creationContext);
        }
    }

    private void applyNamedEntityGraph(NamedEntityGraphDefinition definition) {
        log.debugf("Applying named entity graph [name=%s, entity-name=%s, jpa-entity-name=%s", (Object)definition.getRegisteredName(), (Object)definition.getEntityName(), (Object)definition.getJpaEntityName());
        EntityTypeDescriptor entityDescriptor = this.inFlightRuntimeModel.findEntityDescriptor(definition.getEntityName());
        if (entityDescriptor == null) {
            throw new IllegalArgumentException("Attempted to register named entity graph [" + definition.getRegisteredName() + "] for unknown entity [" + definition.getEntityName() + "]");
        }
        RootGraphImpl entityGraph = new RootGraphImpl(definition.getRegisteredName(), entityDescriptor, this.sessionFactory);
        NamedEntityGraph namedEntityGraph = definition.getAnnotation();
        if (namedEntityGraph.includeAllAttributes()) {
            for (Object attributeObject : entityDescriptor.getAttributes()) {
                entityGraph.addAttributeNodes(new Attribute[]{(Attribute)attributeObject});
            }
        }
        if (namedEntityGraph.attributeNodes().length > 0) {
            this.applyNamedAttributeNodes(namedEntityGraph.attributeNodes(), namedEntityGraph, entityGraph);
        }
        this.inFlightRuntimeModel.addNamedRootGraph(definition.getRegisteredName(), entityGraph);
    }

    private void applyNamedAttributeNodes(NamedAttributeNode[] namedAttributeNodes, NamedEntityGraph namedEntityGraph, GraphImplementor graphNode) {
        for (NamedAttributeNode namedAttributeNode : namedAttributeNodes) {
            SubGraph subgraph;
            String value = namedAttributeNode.value();
            AttributeNode attributeNode = graphNode.addAttributeNode(value);
            if (StringHelper.isNotEmpty(namedAttributeNode.subgraph())) {
                subgraph = attributeNode.makeSubGraph();
                this.applyNamedSubgraphs(namedEntityGraph, namedAttributeNode.subgraph(), (SubGraphImplementor)subgraph);
            }
            if (!StringHelper.isNotEmpty(namedAttributeNode.keySubgraph())) continue;
            subgraph = attributeNode.makeKeySubGraph();
            this.applyNamedSubgraphs(namedEntityGraph, namedAttributeNode.keySubgraph(), (SubGraphImplementor)subgraph);
        }
    }

    private void applyNamedSubgraphs(NamedEntityGraph namedEntityGraph, String subgraphName, SubGraphImplementor subgraph) {
        for (NamedSubgraph namedSubgraph : namedEntityGraph.subgraphs()) {
            if (!subgraphName.equals(namedSubgraph.name())) continue;
            this.applyNamedAttributeNodes(namedSubgraph.attributeNodes(), namedEntityGraph, subgraph);
        }
    }

    private class RuntimeModelCreationContextImpl
    implements RuntimeModelCreationContext {
        private final InFlightMetadataCollector mappingMetadata;
        private final DatabaseModel databaseModel;
        private final JpaStaticMetaModelPopulationSetting jpaMetaModelPopulationSetting;
        private final DatabaseObjectResolutionContextImpl dbObjectResolver;

        public RuntimeModelCreationContextImpl(InFlightMetadataCollector mappingMetadata, DatabaseModel databaseModel, JpaStaticMetaModelPopulationSetting jpaMetaModelPopulationSetting, DatabaseObjectResolutionContextImpl dbObjectResolver) {
            this.mappingMetadata = mappingMetadata;
            this.databaseModel = databaseModel;
            this.jpaMetaModelPopulationSetting = jpaMetaModelPopulationSetting;
            this.dbObjectResolver = dbObjectResolver;
        }

        @Override
        public BootstrapContext getBootstrapContext() {
            return RuntimeModelCreationProcess.this.bootstrapContext;
        }

        @Override
        public SessionFactoryImplementor getSessionFactory() {
            return RuntimeModelCreationProcess.this.sessionFactory;
        }

        @Override
        public MetadataImplementor getMetadata() {
            return this.mappingMetadata;
        }

        @Override
        public DatabaseModel getDatabaseModel() {
            return this.databaseModel;
        }

        @Override
        public DatabaseObjectResolver getDatabaseObjectResolver() {
            return this.dbObjectResolver;
        }

        @Override
        public InFlightRuntimeModel getInFlightRuntimeModel() {
            return RuntimeModelCreationProcess.this.inFlightRuntimeModel;
        }

        @Override
        public TypeConfiguration getTypeConfiguration() {
            return RuntimeModelCreationProcess.this.metadataBuildingContext.getBootstrapContext().getTypeConfiguration();
        }

        @Override
        public JpaStaticMetaModelPopulationSetting getJpaStaticMetaModelPopulationSetting() {
            return this.jpaMetaModelPopulationSetting;
        }

        @Override
        public RuntimeModelDescriptorFactory getRuntimeModelDescriptorFactory() {
            return RuntimeModelCreationProcess.this.descriptorFactory;
        }

        @Override
        public ManagedTypeRepresentationResolver getRepresentationStrategySelector() {
            return RuntimeModelCreationProcess.this.metadataBuildingContext.getBuildingOptions().getManagedTypeRepresentationResolver();
        }

        @Override
        public CollectionSemanticsResolver getCollectionSemanticsResolver() {
            return RuntimeModelCreationProcess.this.metadataBuildingContext.getBootstrapContext().getCollectionRepresentationResolver();
        }

        @Override
        public void registerEntityHierarchy(EntityHierarchy runtimeHierarchy, EntityMappingHierarchy bootHierarchy) {
            RuntimeModelCreationProcess.this.inFlightRuntimeModel.addEntityHierarchy(runtimeHierarchy);
        }

        @Override
        public void registerEntityDescriptor(EntityTypeDescriptor runtimeDescriptor, EntityMapping bootDescriptor) {
            RuntimeModelCreationProcess.this.inFlightRuntimeModel.addEntityDescriptor(runtimeDescriptor);
            if (RootClass.class.isInstance(bootDescriptor)) {
                RootClass rootBootMapping = (RootClass)bootDescriptor;
                AccessType accessType = AccessType.fromExternalName(rootBootMapping.getCacheConcurrencyStrategy());
                if (accessType != null && rootBootMapping.isCached()) {
                    this.addEntityCachingConfig(runtimeDescriptor, rootBootMapping, accessType);
                }
                if (rootBootMapping.hasNaturalId() && accessType != null && rootBootMapping.getNaturalIdCacheRegionName() != null) {
                    this.addNaturalIdCachingConfig(runtimeDescriptor, rootBootMapping, accessType);
                }
            }
        }

        private void addEntityCachingConfig(EntityTypeDescriptor runtimeDescriptor, RootClass bootDescriptor, AccessType accessType) {
            DomainDataRegionConfigImpl.Builder builder = this.locateBuilder(bootDescriptor.getCacheRegionName());
            builder.addEntityConfig(bootDescriptor, accessType);
        }

        private DomainDataRegionConfigImpl.Builder locateBuilder(String regionName) {
            return RuntimeModelCreationProcess.this.regionConfigBuilders.computeIfAbsent(regionName, DomainDataRegionConfigImpl.Builder::new);
        }

        private void addNaturalIdCachingConfig(EntityTypeDescriptor runtimeDescriptor, RootClass bootDescriptor, AccessType accessType) {
            DomainDataRegionConfigImpl.Builder configBuilder = this.locateBuilder(bootDescriptor.getCacheRegionName());
            configBuilder.addNaturalIdConfig(bootDescriptor, accessType);
        }

        @Override
        public void registerMappedSuperclassDescriptor(MappedSuperclassTypeDescriptor runtimeType, MappedSuperclassMapping bootMapping) {
            RuntimeModelCreationProcess.this.inFlightRuntimeModel.addMappedSuperclassDescriptor(runtimeType);
        }

        @Override
        public void registerEmbeddableDescriptor(EmbeddedTypeDescriptor runtimeDescriptor, EmbeddedValueMappingImplementor bootDescriptor) {
            RuntimeModelCreationProcess.this.embeddableRuntimeByBoot.put(bootDescriptor, runtimeDescriptor);
            RuntimeModelCreationProcess.this.inFlightRuntimeModel.addEmbeddedDescriptor(runtimeDescriptor);
        }

        @Override
        public void registerNavigable(Navigable navigable, Object bootModelReference) {
            RuntimeModelCreationProcess.this.navigablesToFinalize.put(navigable, bootModelReference);
        }

        @Override
        public void registerCollectionDescriptor(PersistentCollectionDescriptor runtimeDescriptor, Collection bootDescriptor) {
            RuntimeModelCreationProcess.this.collectionRuntimeByBoot.put(bootDescriptor, runtimeDescriptor);
            RuntimeModelCreationProcess.this.inFlightRuntimeModel.addCollectionDescriptor(runtimeDescriptor);
            AccessType accessType = AccessType.fromExternalName(bootDescriptor.getCacheConcurrencyStrategy());
            if (accessType != null) {
                this.addCollectionCachingConfig(runtimeDescriptor, bootDescriptor, accessType);
            }
        }

        private void addCollectionCachingConfig(PersistentCollectionDescriptor runtimeDescriptor, Collection bootDescriptor, AccessType accessType) {
            DomainDataRegionConfigImpl.Builder configBuilder = this.locateBuilder(bootDescriptor.getCacheRegionName());
            configBuilder.addCollectionConfig(bootDescriptor, accessType);
        }

        @Override
        public EntityDataAccess getEntityCacheAccess(NavigableRole navigableRole) {
            return null;
        }

        @Override
        public NaturalIdDataAccess getNaturalIdCacheAccess(NavigableRole navigableRole) {
            return null;
        }

        @Override
        public CollectionDataAccess getCollectionCacheAccess(NavigableRole navigableRole) {
            return null;
        }
    }
}

