/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain;

import java.util.Locale;

public enum RepresentationMode {
    POJO("pojo"),
    MAP("map", "dynamic-map");

    private final String externalName;
    private final String alternativeExternalName;

    private RepresentationMode(String externalName) {
        this(externalName, null);
    }

    private RepresentationMode(String externalName, String alternativeExternalName) {
        this.externalName = externalName;
        this.alternativeExternalName = alternativeExternalName;
    }

    public String getExternalName() {
        return this.externalName;
    }

    public static RepresentationMode fromExternalName(String externalName) {
        if (externalName == null) {
            return POJO;
        }
        if (RepresentationMode.MAP.externalName.equalsIgnoreCase(externalName) || RepresentationMode.MAP.alternativeExternalName.equalsIgnoreCase(externalName)) {
            return MAP;
        }
        if (RepresentationMode.POJO.externalName.equalsIgnoreCase(externalName)) {
            return POJO;
        }
        return RepresentationMode.valueOf(externalName.toUpperCase(Locale.ROOT));
    }
}

