/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import java.util.Map;
import javax.persistence.metamodel.PluralAttribute;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.CollectionDomainType;
import org.hibernate.metamodel.model.domain.spi.AbstractPluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.CollectionIndex;
import org.hibernate.metamodel.model.domain.spi.MapPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.domain.spi.SimpleTypeDescriptor;
import org.hibernate.property.access.spi.PropertyAccess;

public class MapAttributeImpl<X, K, V>
extends AbstractPluralPersistentAttribute<X, Map<K, V>, V>
implements MapPersistentAttribute<X, K, V> {
    public MapAttributeImpl(PersistentCollectionDescriptor collectionDescriptor, Property bootProperty, PropertyAccess propertyAccess, RuntimeModelCreationContext creationContext) {
        super(collectionDescriptor, bootProperty, propertyAccess, creationContext);
    }

    @Override
    public PluralAttribute.CollectionType getCollectionType() {
        return PluralAttribute.CollectionType.MAP;
    }

    public Class<K> getKeyJavaType() {
        return this.getKeyType().getJavaType();
    }

    @Override
    public SimpleTypeDescriptor<K> getKeyType() {
        return this.getPersistentCollectionDescriptor().getKeyDomainTypeDescriptor();
    }

    @Override
    protected Map<K, V> replaceElements(Map<K, V> originalValue, Map<K, V> targetValue, Object owner, Map copyCache, SessionImplementor session) {
        targetValue.clear();
        CollectionIndex indexDescriptor = this.getCollectionDescriptor().getIndexDescriptor();
        CollectionDomainType.Element elementDescriptor = this.getCollectionDescriptor().getElementDescriptor();
        for (Map.Entry<K, V> entry : originalValue.entrySet()) {
            Object key = indexDescriptor.replace(entry.getKey(), null, owner, copyCache, session);
            Object value = elementDescriptor.replace(entry.getValue(), null, owner, copyCache, session);
            targetValue.put(key, value);
        }
        return targetValue;
    }
}

