/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import org.hibernate.LockMode;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.internal.ListAttributeImpl;
import org.hibernate.metamodel.model.domain.internal.collection.SqlAstHelper;
import org.hibernate.metamodel.model.domain.spi.AbstractPersistentCollectionDescriptor;
import org.hibernate.metamodel.model.domain.spi.AbstractPluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.CollectionElement;
import org.hibernate.metamodel.model.domain.spi.ManagedTypeDescriptor;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.internal.domain.collection.ArrayInitializerProducer;
import org.hibernate.sql.results.internal.domain.collection.CollectionInitializerProducer;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.FetchParent;

public class PersistentArrayDescriptorImpl<O, E>
extends AbstractPersistentCollectionDescriptor<O, E[], E> {
    private final boolean hasFormula;

    public PersistentArrayDescriptorImpl(Property pluralProperty, ManagedTypeDescriptor runtimeContainer, RuntimeModelCreationContext creationContext) {
        super(pluralProperty, runtimeContainer, creationContext);
        IndexedCollection collection = (IndexedCollection)pluralProperty.getValue();
        this.hasFormula = collection.getIndex().hasFormula();
    }

    @Override
    protected CollectionInitializerProducer createInitializerProducer(NavigablePath navigablePath, FetchParent fetchParent, boolean selected, String resultVariable, LockMode lockMode, DomainResultCreationState creationState) {
        return new ArrayInitializerProducer(this, selected, SqlAstHelper.generateCollectionIndexDomainResult(navigablePath.append("{index}"), this.getIndexDescriptor(), selected, null, creationState), SqlAstHelper.generateCollectionElementDomainResult(navigablePath.append("{element}"), (CollectionElement)this.getElementDescriptor(), selected, null, creationState));
    }

    @Override
    protected AbstractPluralPersistentAttribute createAttribute(Property pluralProperty, PropertyAccess propertyAccess, RuntimeModelCreationContext creationContext) {
        return new ListAttributeImpl(this, pluralProperty, propertyAccess, creationContext);
    }

    @Override
    public boolean contains(Object collection, E childObject) {
        assert (collection.getClass().isArray());
        int length = Array.getLength(collection);
        for (int i = 0; i < length; ++i) {
            if (!this.getElementDescriptor().getJavaTypeDescriptor().areEqual(Array.get(collection, i), childObject)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void doProcessQueuedOps(PersistentCollection collection, Object id, SharedSessionContractImplementor session) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    protected boolean hasIndex() {
        return true;
    }

    @Override
    protected boolean indexContainsFormula() {
        return this.hasFormula;
    }

    @Override
    public Iterator getElementsIterator(Object collection, SharedSessionContractImplementor session) {
        return Arrays.asList((Object[])collection).iterator();
    }

    @Override
    public Object indexOf(Object array, Object element) {
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            if (Array.get(array, i) != element) continue;
            return i;
        }
        return null;
    }
}

