/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.cache.CacheException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.internal.MapAttributeImpl;
import org.hibernate.metamodel.model.domain.internal.collection.SqlAstHelper;
import org.hibernate.metamodel.model.domain.spi.AbstractPersistentCollectionDescriptor;
import org.hibernate.metamodel.model.domain.spi.AbstractPluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.CollectionElement;
import org.hibernate.metamodel.model.domain.spi.ManagedTypeDescriptor;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.internal.domain.collection.CollectionInitializerProducer;
import org.hibernate.sql.results.internal.domain.collection.MapInitializerProducer;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.FetchParent;

public class PersistentMapDescriptorImpl<O, K, E>
extends AbstractPersistentCollectionDescriptor<O, Map<K, E>, E> {
    private final Comparator<K> comparator;
    private final boolean hasFormula;

    public PersistentMapDescriptorImpl(Property pluralProperty, ManagedTypeDescriptor runtimeContainer, RuntimeModelCreationContext creationContext) throws MappingException, CacheException {
        super(pluralProperty, runtimeContainer, creationContext);
        IndexedCollection collection = (IndexedCollection)pluralProperty.getValue();
        this.hasFormula = collection.getIndex().hasFormula();
        this.comparator = pluralProperty.getValue() instanceof Collection ? collection.getComparator() : null;
    }

    @Override
    public Comparator<?> getSortingComparator() {
        return this.comparator;
    }

    @Override
    public boolean contains(Object collection, Object childObject) {
        return ((Map)collection).containsValue(childObject);
    }

    @Override
    protected CollectionInitializerProducer createInitializerProducer(NavigablePath navigablePath, FetchParent fetchParent, boolean selected, String resultVariable, LockMode lockMode, DomainResultCreationState creationState) {
        return new MapInitializerProducer(this, selected, SqlAstHelper.generateCollectionIndexDomainResult(navigablePath.append("{index}"), this.getIndexDescriptor(), selected, null, creationState), SqlAstHelper.generateCollectionElementDomainResult(navigablePath.append("{element}"), (CollectionElement)this.getElementDescriptor(), selected, null, creationState));
    }

    @Override
    protected AbstractPluralPersistentAttribute createAttribute(Property pluralProperty, PropertyAccess propertyAccess, RuntimeModelCreationContext creationContext) {
        return new MapAttributeImpl(this, pluralProperty, propertyAccess, creationContext);
    }

    @Override
    protected void doProcessQueuedOps(PersistentCollection collection, Object id, SharedSessionContractImplementor session) {
    }

    @Override
    protected boolean hasIndex() {
        return true;
    }

    @Override
    protected boolean indexContainsFormula() {
        return this.hasFormula;
    }

    @Override
    public Iterator getElementsIterator(Object collection, SharedSessionContractImplementor session) {
        return ((Map)collection).values().iterator();
    }

    @Override
    public Object indexOf(Object collection, Object element) {
        for (Map.Entry o : ((Map)collection).entrySet()) {
            Map.Entry me = o;
            if (me.getValue() != element) continue;
            return me.getKey();
        }
        return null;
    }
}

