/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import java.util.Comparator;
import java.util.Set;
import org.hibernate.LockMode;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.internal.SetAttributeImpl;
import org.hibernate.metamodel.model.domain.internal.collection.SqlAstHelper;
import org.hibernate.metamodel.model.domain.spi.AbstractPersistentCollectionDescriptor;
import org.hibernate.metamodel.model.domain.spi.AbstractPluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.CollectionElement;
import org.hibernate.metamodel.model.domain.spi.ManagedTypeDescriptor;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.internal.domain.collection.CollectionInitializerProducer;
import org.hibernate.sql.results.internal.domain.collection.SetInitializerProducer;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.FetchParent;

public class PersistentSetDescriptorImpl<O, E>
extends AbstractPersistentCollectionDescriptor<O, Set<E>, E> {
    private final Comparator<E> comparator;

    public PersistentSetDescriptorImpl(Property bootProperty, ManagedTypeDescriptor runtimeContainer, RuntimeModelCreationContext context) {
        super(bootProperty, runtimeContainer, context);
        this.comparator = bootProperty.getValue() instanceof Collection ? ((Collection)bootProperty.getValue()).getComparator() : null;
    }

    @Override
    public Comparator<?> getSortingComparator() {
        return this.comparator;
    }

    @Override
    protected CollectionInitializerProducer createInitializerProducer(NavigablePath navigablePath, FetchParent fetchParent, boolean selected, String resultVariable, LockMode lockMode, DomainResultCreationState creationState) {
        return new SetInitializerProducer(this, selected, SqlAstHelper.generateCollectionElementDomainResult(navigablePath.append("{element}"), (CollectionElement)this.getElementDescriptor(), selected, null, creationState));
    }

    @Override
    protected AbstractPluralPersistentAttribute createAttribute(Property pluralProperty, PropertyAccess propertyAccess, RuntimeModelCreationContext creationContext) {
        return new SetAttributeImpl(this, pluralProperty, propertyAccess, creationContext);
    }

    @Override
    public boolean contains(Object collection, Object childObject) {
        return ((Set)collection).contains(childObject);
    }

    public String toString() {
        return this.getNavigableRole().getFullPath();
    }

    @Override
    protected void doProcessQueuedOps(PersistentCollection collection, Object id, SharedSessionContractImplementor session) {
    }
}

