/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.persistence.metamodel.Attribute;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.boot.model.domain.PersistentAttributeMapping;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.internal.NonNullableTransientDependencies;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.CascadeStyles;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.Component;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.model.domain.spi.AbstractNonIdSingularPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.EmbeddedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.EmbeddedValuedNavigable;
import org.hibernate.metamodel.model.domain.spi.ManagedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.NavigableVisitationStrategy;
import org.hibernate.metamodel.model.domain.spi.SimpleTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.SingularPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.StateArrayContributor;
import org.hibernate.metamodel.model.domain.spi.Writeable;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.produce.SqmPathRegistry;
import org.hibernate.query.sqm.produce.spi.SqmCreationState;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddedValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmNavigableReference;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.produce.metamodel.spi.Fetchable;
import org.hibernate.sql.ast.produce.metamodel.spi.Joinable;
import org.hibernate.sql.ast.produce.spi.ColumnReferenceQualifier;
import org.hibernate.sql.ast.produce.spi.SqlAstCreationState;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.internal.domain.embedded.CompositeFetchImpl;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.FetchParent;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.descriptor.java.spi.EmbeddableJavaDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class SingularPersistentAttributeEmbedded<O, J>
extends AbstractNonIdSingularPersistentAttribute<O, J>
implements EmbeddedValuedNavigable<J>,
Joinable<J>,
Fetchable<J> {
    private final EmbeddedTypeDescriptor<J> embeddedDescriptor;
    private CascadeStyle cascadeStyle;
    private final FetchStrategy mappedFetchStrategy = new FetchStrategy(FetchTiming.IMMEDIATE, FetchStyle.JOIN);

    public SingularPersistentAttributeEmbedded(ManagedTypeDescriptor<O> runtimeModelContainer, PersistentAttributeMapping bootModelAttribute, PropertyAccess propertyAccess, SingularPersistentAttribute.Disposition disposition, RuntimeModelCreationContext context) {
        super(runtimeModelContainer, bootModelAttribute, propertyAccess, disposition);
        Component embeddedMapping = (Component)bootModelAttribute.getValueMapping();
        this.embeddedDescriptor = embeddedMapping.makeRuntimeDescriptor(runtimeModelContainer, bootModelAttribute.getName(), disposition, context);
        this.instantiationComplete(bootModelAttribute, context);
    }

    private CascadeStyle getCascadeStyle(EmbeddedTypeDescriptor<J> embeddedDescriptor) {
        List stateArrayContributors = embeddedDescriptor.getStateArrayContributors();
        for (int i = 0; i < stateArrayContributors.size(); ++i) {
            if (stateArrayContributors.get(i) == CascadeStyles.NONE) continue;
            return CascadeStyles.ALL;
        }
        return CascadeStyles.NONE;
    }

    @Override
    public ForeignKeyDirection getForeignKeyDirection() {
        return null;
    }

    @Override
    public ManagedTypeDescriptor<O> getContainer() {
        return super.getContainer();
    }

    @Override
    public SimpleTypeDescriptor<?> getValueGraphType() {
        return this.getEmbeddedDescriptor();
    }

    @Override
    public SimpleTypeDescriptor<?> getKeyGraphType() {
        return null;
    }

    @Override
    public EmbeddedTypeDescriptor<J> getEmbeddedDescriptor() {
        return this.embeddedDescriptor;
    }

    @Override
    public EmbeddableJavaDescriptor<J> getJavaTypeDescriptor() {
        return (EmbeddableJavaDescriptor)super.getJavaTypeDescriptor();
    }

    @Override
    public SimpleTypeDescriptor<J> getType() {
        return this.getEmbeddedDescriptor();
    }

    @Override
    public SingularPersistentAttribute.SingularAttributeClassification getAttributeTypeClassification() {
        return SingularPersistentAttribute.SingularAttributeClassification.EMBEDDED;
    }

    @Override
    public String asLoggableText() {
        return this.toString();
    }

    public Attribute.PersistentAttributeType getPersistentAttributeType() {
        return Attribute.PersistentAttributeType.EMBEDDED;
    }

    @Override
    public <N> Navigable<N> findNavigable(String navigableName) {
        return this.getEmbeddedDescriptor().findNavigable(navigableName);
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.embeddedDescriptor.getNavigableRole();
    }

    @Override
    public void visitNavigable(NavigableVisitationStrategy visitor) {
        visitor.visitSingularAttributeEmbedded(this);
    }

    @Override
    public void visitNavigables(NavigableVisitationStrategy visitor) {
        this.embeddedDescriptor.visitNavigables(visitor);
    }

    @Override
    public SqmNavigableReference createSqmExpression(SqmPath lhs, SqmCreationState creationState) {
        NavigablePath navigablePath = lhs.getNavigablePath().append(this.getNavigableName());
        SqmPathRegistry pathRegistry = creationState.getProcessingStateStack().getCurrent().getPathRegistry();
        return (SqmNavigableReference)pathRegistry.resolvePath(navigablePath, np -> new SqmEmbeddedValuedSimplePath(navigablePath, this, lhs));
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, FetchTiming fetchTiming, boolean selected, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
        return new CompositeFetchImpl(fetchParent, this, fetchTiming, creationState);
    }

    @Override
    public void visitFetchables(Consumer<Fetchable> fetchableConsumer) {
        this.getEmbeddedDescriptor().visitFetchables(fetchableConsumer);
    }

    @Override
    public FetchStrategy getMappedFetchStrategy() {
        return this.mappedFetchStrategy;
    }

    public String toString() {
        return String.format(Locale.ROOT, "%s(%s)@%s", this.getClass().getSimpleName(), this.getNavigableRole().getFullPath(), System.identityHashCode(this));
    }

    @Override
    public List<Column> getColumns() {
        return this.getEmbeddedDescriptor().collectColumns();
    }

    @Override
    public Object resolveHydratedState(Object hydratedForm, ExecutionContext executionContext, SharedSessionContractImplementor session, Object containerInstance) {
        J instance = this.embeddedDescriptor.instantiate(session);
        Object[] hydratedValues = (Object[])hydratedForm;
        this.embeddedDescriptor.visitStateArrayContributors(contributor -> {
            Object subResolvedForm;
            Object subHydratedForm = hydratedValues[contributor.getStateArrayPosition()];
            hydratedValues[contributor.getStateArrayPosition()] = subResolvedForm = contributor.resolveHydratedState(subHydratedForm, executionContext, session, containerInstance);
        });
        this.embeddedDescriptor.setPropertyValues(instance, (Object[])hydratedForm);
        return instance;
    }

    @Override
    public int getNumberOfJdbcParametersForRestriction() {
        return this.getColumns().size();
    }

    @Override
    public void collectNonNullableTransientEntities(Object value, final ForeignKeys.Nullifier nullifier, final NonNullableTransientDependencies nonNullableTransientEntities, final SharedSessionContractImplementor session) {
        Object[] subValues;
        if (value == null) {
            return;
        }
        if (value instanceof Object[]) {
            subValues = (Object[])value;
        } else if (this.getEmbeddedDescriptor().getJavaTypeDescriptor().isInstance(value)) {
            subValues = this.getEmbeddedDescriptor().getPropertyValues(value);
        } else {
            throw new HibernateException("Unexpected value : " + value);
        }
        if (subValues.length == 0) {
            return;
        }
        this.getEmbeddedDescriptor().visitStateArrayContributors(new Consumer<StateArrayContributor<?>>(){
            int i = 0;

            @Override
            public void accept(StateArrayContributor<?> stateArrayContributor) {
                Object subValue;
                if ((subValue = subValues[this.i++]) == null) {
                    return;
                }
                stateArrayContributor.collectNonNullableTransientEntities(subValue, nullifier, nonNullableTransientEntities, session);
            }
        });
    }

    @Override
    public void visitJdbcTypes(Consumer<SqlExpressableType> action, Clause clause, TypeConfiguration typeConfiguration) {
        this.getEmbeddedDescriptor().visitJdbcTypes(action, clause, typeConfiguration);
    }

    @Override
    public Object unresolve(Object value, SharedSessionContractImplementor session) {
        Object[] values = this.getEmbeddedDescriptor().getPropertyValues(value);
        this.getEmbeddedDescriptor().visitStateArrayContributors(contributor -> {
            int index = contributor.getStateArrayPosition();
            values[index] = contributor.unresolve(values[index], session);
        });
        return values;
    }

    @Override
    public boolean isInsertable() {
        for (StateArrayContributor contributor : this.getEmbeddedDescriptor().getStateArrayContributors()) {
            if (!contributor.isInsertable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isUpdatable() {
        for (StateArrayContributor contributor : this.getEmbeddedDescriptor().getStateArrayContributors()) {
            if (!contributor.isUpdatable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CascadeStyle getCascadeStyle() {
        if (this.cascadeStyle == null) {
            this.cascadeStyle = this.getCascadeStyle(this.embeddedDescriptor);
        }
        return this.cascadeStyle;
    }

    @Override
    public void dehydrate(Object value, Writeable.JdbcValueCollector jdbcValueCollector, Clause clause, SharedSessionContractImplementor session) {
        Object[] values = (Object[])value;
        this.getEmbeddedDescriptor().visitStateArrayContributors(contributor -> {
            if (clause.getInclusionChecker().test((StateArrayContributor)contributor)) {
                contributor.dehydrate(values[contributor.getStateArrayPosition()], jdbcValueCollector, clause, session);
            }
        });
    }

    @Override
    public boolean isDirty(Object originalValue, Object currentValue, SharedSessionContractImplementor session) {
        if (originalValue == currentValue) {
            return false;
        }
        Object[] originalValues = this.getEmbeddedDescriptor().getPropertyValues(originalValue);
        Object[] currentValues = this.getEmbeddedDescriptor().getPropertyValues(currentValue);
        for (StateArrayContributor contributor : this.getEmbeddedDescriptor().getStateArrayContributors()) {
            int index;
            if (!contributor.isDirty(originalValues[index = contributor.getStateArrayPosition()], currentValues[index], session)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean areEqual(J x, J y) throws HibernateException {
        return this.getEmbeddedDescriptor().areEqual(x, y);
    }

    @Override
    public int extractHashCode(J o) {
        return this.getEmbeddedDescriptor().extractHashCode(o);
    }

    @Override
    protected void instantiationComplete(PersistentAttributeMapping bootModelAttribute, RuntimeModelCreationContext context) {
        super.instantiationComplete(bootModelAttribute, context);
        this.mutabilityPlan = this.getJavaTypeDescriptor().getMutabilityPlan();
    }

    @Override
    public List<ColumnReference> resolveColumnReferences(ColumnReferenceQualifier qualifier, SqlAstCreationState creationState) {
        ArrayList<ColumnReference> columnReferences = new ArrayList<ColumnReference>();
        this.getEmbeddedDescriptor().visitStateArrayContributors(contributor -> columnReferences.addAll(contributor.resolveColumnReferences(qualifier, creationState)));
        return columnReferences;
    }

    @Override
    public void visitColumns(BiConsumer<SqlExpressableType, Column> action, Clause clause, TypeConfiguration typeConfiguration) {
        this.getEmbeddedDescriptor().visitStateArrayContributors(contributor -> contributor.visitColumns(action, clause, typeConfiguration));
    }
}

