/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.persistence.EntityNotFoundException;
import javax.persistence.TemporalType;
import javax.persistence.metamodel.Attribute;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.boot.model.domain.PersistentAttributeMapping;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.internal.NonNullableTransientDependencies;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.CascadeStyles;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.EntityUniqueKey;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.internal.StandardSingleUniqueKeyEntityLoader;
import org.hibernate.loader.spi.SingleEntityLoader;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.ToOne;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.model.domain.internal.ForeignKeyDomainResult;
import org.hibernate.metamodel.model.domain.internal.SqlAliasStemHelper;
import org.hibernate.metamodel.model.domain.internal.entity.ToOneJoinCollectorImpl;
import org.hibernate.metamodel.model.domain.spi.AbstractNonIdSingularPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.AllowableParameterType;
import org.hibernate.metamodel.model.domain.spi.DomainModelHelper;
import org.hibernate.metamodel.model.domain.spi.EntityIdentifierComposite;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.EntityValuedNavigable;
import org.hibernate.metamodel.model.domain.spi.JoinablePersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.ManagedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.NavigableContainer;
import org.hibernate.metamodel.model.domain.spi.NavigableVisitationStrategy;
import org.hibernate.metamodel.model.domain.spi.NonIdPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.SimpleTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.SingularPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.StateArrayContributor;
import org.hibernate.metamodel.model.domain.spi.TableReferenceJoinCollector;
import org.hibernate.metamodel.model.domain.spi.Writeable;
import org.hibernate.metamodel.model.relational.internal.ColumnMappingImpl;
import org.hibernate.metamodel.model.relational.internal.ColumnMappingsImpl;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.ForeignKey;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.JoinType;
import org.hibernate.sql.ast.produce.metamodel.spi.Fetchable;
import org.hibernate.sql.ast.produce.metamodel.spi.Joinable;
import org.hibernate.sql.ast.produce.spi.ColumnReferenceQualifier;
import org.hibernate.sql.ast.produce.spi.SqlAliasBase;
import org.hibernate.sql.ast.produce.spi.SqlAstCreationState;
import org.hibernate.sql.ast.produce.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.produce.spi.TableGroupJoinProducer;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.internal.domain.entity.DelayedEntityFetch;
import org.hibernate.sql.results.internal.domain.entity.EntityFetchImpl;
import org.hibernate.sql.results.internal.domain.entity.ImmediatePkEntityFetch;
import org.hibernate.sql.results.internal.domain.entity.ImmediateUkEntityFetch;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.EntityFetch;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.FetchParent;
import org.hibernate.sql.results.spi.SqlSelection;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.descriptor.java.spi.EntityJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class SingularPersistentAttributeEntity<O, J>
extends AbstractNonIdSingularPersistentAttribute<O, J>
implements JoinablePersistentAttribute<O, J>,
EntityValuedNavigable<J>,
Joinable<J>,
Fetchable<J>,
AllowableParameterType<J>,
TableGroupJoinProducer {
    private final SingularPersistentAttribute.SingularAttributeClassification classification;
    private final Attribute.PersistentAttributeType persistentAttributeType;
    private final boolean isLogicalOneToOne;
    private final boolean constrained;
    private final NavigableRole navigableRole;
    private final String sqlAliasStem;
    private final EntityTypeDescriptor<J> entityDescriptor;
    private final String referencedUkAttributeName;
    private final FetchStrategy fetchStrategy;
    private final NotFoundAction notFoundAction;
    private final CascadeStyle cascadeStyle;
    private StateArrayContributor referencedUkAttribute;
    private SingleEntityLoader singleEntityLoader;
    private ForeignKey foreignKey;
    private String mappedBy;

    public SingularPersistentAttributeEntity(ManagedTypeDescriptor<O> runtimeModelContainer, PersistentAttributeMapping bootModelAttribute, PropertyAccess propertyAccess, SingularPersistentAttribute.Disposition disposition, SingularPersistentAttribute.SingularAttributeClassification classification, RuntimeModelCreationContext context) {
        super(runtimeModelContainer, bootModelAttribute, propertyAccess, disposition);
        this.classification = classification;
        this.navigableRole = runtimeModelContainer.getNavigableRole().append(bootModelAttribute.getName());
        this.mappedBy = bootModelAttribute.getMappedBy();
        ToOne valueMapping = (ToOne)bootModelAttribute.getValueMapping();
        this.referencedUkAttributeName = valueMapping.getReferencedPropertyName();
        if (valueMapping.getReferencedEntityName() == null) {
            throw new MappingException("Name of target entity of a to-one association not known : " + this.navigableRole.getFullPath());
        }
        this.entityDescriptor = context.getInFlightRuntimeModel().findEntityDescriptor(valueMapping.getReferencedEntityName());
        if (this.entityDescriptor == null) {
            throw new MappingException(String.format(Locale.ROOT, "Cannot create SingularPersistentAttributeEntity [%s] : could not locate target entity descriptor [%s]", this.navigableRole.getFullPath(), valueMapping.getReferencedEntityName()));
        }
        if (valueMapping.getForeignKey() != null) {
            this.foreignKey = context.getDatabaseObjectResolver().resolveForeignKey(valueMapping.getForeignKey());
        }
        if (SingularPersistentAttribute.SingularAttributeClassification.MANY_TO_ONE.equals((Object)classification)) {
            ManyToOne manyToOne = (ManyToOne)bootModelAttribute.getValueMapping();
            this.isLogicalOneToOne = manyToOne.isLogicalOneToOne();
            this.persistentAttributeType = this.isLogicalOneToOne ? Attribute.PersistentAttributeType.ONE_TO_ONE : Attribute.PersistentAttributeType.MANY_TO_ONE;
            this.constrained = true;
            this.notFoundAction = manyToOne.isIgnoreNotFound() ? NotFoundAction.IGNORE : NotFoundAction.EXCEPTION;
        } else {
            this.isLogicalOneToOne = false;
            this.persistentAttributeType = Attribute.PersistentAttributeType.ONE_TO_ONE;
            this.constrained = ((OneToOne)valueMapping).isConstrained();
            this.notFoundAction = NotFoundAction.EXCEPTION;
        }
        this.sqlAliasStem = SqlAliasStemHelper.INSTANCE.generateStemFromAttributeName(bootModelAttribute.getName());
        context.registerNavigable(this, bootModelAttribute);
        this.instantiationComplete(bootModelAttribute, context);
        this.cascadeStyle = CascadeStyles.getCascadeStyle(bootModelAttribute.getCascade());
        this.fetchStrategy = DomainModelHelper.determineFetchStrategy(bootModelAttribute, runtimeModelContainer, this.entityDescriptor);
    }

    @Override
    public CascadeStyle getCascadeStyle() {
        return this.cascadeStyle;
    }

    @Override
    public boolean isCircular(FetchParent fetchParent) {
        NavigableContainer parentNavigableContainer = fetchParent.getNavigableContainer();
        if (parentNavigableContainer != null) {
            if (parentNavigableContainer instanceof EntityIdentifierComposite) {
                NavigablePath parentParent;
                NavigablePath parent = fetchParent.getNavigablePath();
                if ((parent = parent.getParent()).getFullPath().endsWith("{element}")) {
                    parent = parent.getParent();
                }
                if ((parentParent = parent.getParent()) != null && parentParent.getFullPath().equals(this.getEntityDescriptor().getNavigableName())) {
                    return true;
                }
            } else {
                NavigableRole parentParentNavigableRole = parentNavigableContainer.getNavigableRole().getParent();
                if (parentParentNavigableRole != null && parentParentNavigableRole.getNavigableName().equals(this.getEntityDescriptor().getNavigableName())) {
                    if (this.mappedBy != null && this.mappedBy.equals(fetchParent.getNavigablePath().getLocalName())) {
                        return true;
                    }
                    String parentMappedBy = ((EntityFetch)fetchParent).getEntityValuedNavigable().getMappedBy();
                    if (this.mappedBy == null && this.getNavigableName().equals(parentMappedBy)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public String getMappedBy() {
        return this.mappedBy;
    }

    @Override
    public boolean finishInitialization(Object bootReference, RuntimeModelCreationContext creationContext) {
        if (this.referencedUkAttributeName == null) {
            this.singleEntityLoader = this.getAssociatedEntityDescriptor().getSingleIdLoader();
        } else {
            this.referencedUkAttribute = ((SingularPersistentAttributeEntity)this.getContainer().findDeclaredPersistentAttribute(this.getName())).getEntityDescriptor().findPersistentAttribute(this.referencedUkAttributeName);
            this.singleEntityLoader = new StandardSingleUniqueKeyEntityLoader(this.referencedUkAttribute, this);
        }
        if (this.foreignKey == null) {
            SingularPersistentAttributeEntity foreignKeyOwningAttribute = (SingularPersistentAttributeEntity)this.entityDescriptor.findNavigable(this.referencedUkAttributeName);
            if (foreignKeyOwningAttribute != null && foreignKeyOwningAttribute.getForeignKey() != null) {
                ForeignKey foreignKeyOwning = foreignKeyOwningAttribute.getForeignKey();
                ArrayList<ForeignKey.ColumnMappings.ColumnMapping> columns = new ArrayList<ForeignKey.ColumnMappings.ColumnMapping>();
                for (ForeignKey.ColumnMappings.ColumnMapping columnMapping : foreignKeyOwning.getColumnMappings().getColumnMappings()) {
                    columns.add(new ColumnMappingImpl(columnMapping.getTargetColumn(), columnMapping.getReferringColumn()));
                }
                this.foreignKey = new ForeignKey(foreignKeyOwning.getName(), false, foreignKeyOwning.getKeyDefinition(), false, false, foreignKeyOwning.getTargetTable(), foreignKeyOwning.getReferringTable(), new ColumnMappingsImpl(foreignKeyOwning.getTargetTable(), foreignKeyOwning.getReferringTable(), columns));
                return true;
            }
            return false;
        }
        return true;
    }

    public Attribute.PersistentAttributeType getPersistentAttributeType() {
        return this.persistentAttributeType;
    }

    @Override
    public EntityTypeDescriptor<J> getEntityDescriptor() {
        return this.entityDescriptor;
    }

    @Override
    public EntityTypeDescriptor<J> getType() {
        return this.getEntityDescriptor();
    }

    @Override
    public String getJpaEntityName() {
        return this.entityDescriptor.getJpaEntityName();
    }

    @Override
    public EntityJavaDescriptor<J> getJavaTypeDescriptor() {
        return this.entityDescriptor.getJavaTypeDescriptor();
    }

    @Override
    public <N> Navigable<N> findNavigable(String navigableName) {
        return this.entityDescriptor.findNavigable(navigableName);
    }

    @Override
    public void visitNavigables(NavigableVisitationStrategy visitor) {
        this.entityDescriptor.visitNavigables(visitor);
    }

    @Override
    public boolean isAssociation() {
        return true;
    }

    public EntityTypeDescriptor getAssociatedEntityDescriptor() {
        return this.entityDescriptor;
    }

    @Override
    public SingularPersistentAttribute.SingularAttributeClassification getAttributeTypeClassification() {
        return this.classification;
    }

    @Override
    public String asLoggableText() {
        return "SingularAttributeEntity([" + this.getAttributeTypeClassification().name() + "] " + this.getContainer().asLoggableText() + '.' + this.getAttributeName() + ")";
    }

    public String toString() {
        return this.asLoggableText();
    }

    @Override
    public String getEntityName() {
        return this.entityDescriptor.getEntityName();
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public void visitNavigable(NavigableVisitationStrategy visitor) {
        visitor.visitSingularAttributeEntity(this);
    }

    @Override
    public void visitFetchables(Consumer<Fetchable> fetchableConsumer) {
        this.getEntityDescriptor().visitFetchables(fetchableConsumer);
    }

    @Override
    public FetchStrategy getMappedFetchStrategy() {
        return this.fetchStrategy;
    }

    @Override
    public ForeignKeyDirection getForeignKeyDirection() {
        switch (this.getAttributeTypeClassification()) {
            case MANY_TO_ONE: {
                return this.isLogicalOneToOne ? ForeignKeyDirection.FROM_PARENT : ForeignKeyDirection.TO_PARENT;
            }
            case ONE_TO_ONE: {
                return this.mappedBy != null ? ForeignKeyDirection.TO_PARENT : ForeignKeyDirection.FROM_PARENT;
            }
            case ANY: {
                return ForeignKeyDirection.FROM_PARENT;
            }
        }
        throw new HibernateException("Unexpected classification [" + (Object)((Object)this.getAttributeTypeClassification()) + "] found in entity-valued attribute descriptor");
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, FetchTiming fetchTiming, boolean selected, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
        if (fetchTiming == FetchTiming.DELAYED) {
            boolean cannotBeLazy;
            boolean isContainerEnhancedForLazy = this.getContainer() instanceof EntityTypeDescriptor && ((EntityTypeDescriptor)this.getContainer()).getBytecodeEnhancementMetadata().isEnhancedForLazyLoading();
            boolean bl = cannotBeLazy = this.getAttributeTypeClassification() == SingularPersistentAttribute.SingularAttributeClassification.ONE_TO_ONE && this.isOptional() || isContainerEnhancedForLazy;
            if (cannotBeLazy) {
                return this.generateImmediateFetch(fetchParent, creationState);
            }
            return this.generateDelayedFetch(fetchParent, creationState);
        }
        if (selected) {
            return this.generateJoinFetch(fetchParent, lockMode, resultVariable, creationState);
        }
        return this.generateImmediateFetch(fetchParent, creationState);
    }

    private Fetch generateDelayedFetch(FetchParent fetchParent, DomainResultCreationState creationState) {
        return new DelayedEntityFetch(fetchParent, this, this.createKeyDomainResult(fetchParent, creationState));
    }

    private ForeignKeyDomainResult createKeyDomainResult(FetchParent fetchParent, DomainResultCreationState creationState) {
        TableGroup tableGroup = creationState.getFromClauseAccess().getTableGroup(fetchParent.getNavigablePath());
        SqlExpressionResolver sqlExpressionResolver = creationState.getSqlExpressionResolver();
        ArrayList<SqlSelection> sqlSelections = new ArrayList<SqlSelection>();
        List<Column> columns = this.getColumns();
        if (this.getColumns() == null || this.getColumns().isEmpty()) {
            columns = this.getAssociatedEntityDescriptor().getIdentifierDescriptor().getColumns();
        }
        for (Column column : columns) {
            sqlSelections.add(sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(tableGroup, column), column.getJavaTypeDescriptor(), creationState.getSqlAstCreationState().getCreationContext().getDomainModel().getTypeConfiguration()));
        }
        return new ForeignKeyDomainResult(null, sqlSelections);
    }

    private Fetch generateImmediateFetch(FetchParent fetchParent, DomainResultCreationState creationState) {
        if (this.referencedUkAttributeName == null || this.referencedUkAttributeName.equals("{id}") || this.referencedUkAttributeName.equals("id")) {
            return new ImmediatePkEntityFetch(fetchParent, this, this.singleEntityLoader, this.createKeyDomainResult(fetchParent, creationState), this.notFoundAction);
        }
        Navigable ukTargetNavigable = this.referencedUkAttribute == null ? this.getAssociatedEntityDescriptor().getIdentifierDescriptor() : this.referencedUkAttribute;
        return new ImmediateUkEntityFetch(fetchParent, this, this.singleEntityLoader, this.createKeyDomainResult(fetchParent, creationState), (key, sessionContractImplementor) -> new EntityUniqueKey(this.getAssociatedEntityDescriptor().getEntityName(), this.referencedUkAttributeName, key, (JavaTypeDescriptor)this.getAssociatedEntityDescriptor().getIdentifierDescriptor().getJavaTypeDescriptor(), (JavaTypeDescriptor)ukTargetNavigable.getJavaTypeDescriptor(), this.getAssociatedEntityDescriptor().getHierarchy().getRepresentation()), this.notFoundAction);
    }

    private Fetch generateJoinFetch(FetchParent fetchParent, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
        String navigableName = this.getNavigableName();
        NavigablePath navigablePath = fetchParent.getNavigablePath().append(navigableName);
        TableGroup tableGroup = creationState.getFromClauseAccess().getTableGroup(fetchParent.getNavigablePath());
        TableGroupJoin tableGroupJoin = this.createTableGroupJoin(navigablePath, tableGroup, resultVariable, this.isNullable() ? JoinType.LEFT : JoinType.INNER, lockMode, creationState.getSqlAstCreationState());
        tableGroup.addTableGroupJoin(tableGroupJoin);
        creationState.getFromClauseAccess().registerTableGroup(navigablePath, tableGroupJoin.getJoinedGroup());
        return new EntityFetchImpl(fetchParent, this, lockMode, navigablePath, creationState);
    }

    @Override
    public String getSqlAliasStem() {
        return this.sqlAliasStem;
    }

    @Override
    public void applyTableReferenceJoins(ColumnReferenceQualifier lhs, JoinType joinType, SqlAliasBase sqlAliasBase, TableReferenceJoinCollector joinCollector) {
        this.getEntityDescriptor().applyTableReferenceJoins(lhs, joinType, sqlAliasBase, joinCollector);
    }

    @Override
    public TableGroupJoin createTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, JoinType joinType, LockMode lockMode, SqlAstCreationState creationState) {
        SqlAliasBase sqlAliasBase = creationState.getSqlAliasBaseGenerator().createSqlAliasBase(this.getSqlAliasStem());
        ToOneJoinCollectorImpl joinCollector = new ToOneJoinCollectorImpl(navigablePath, this, lhs, explicitSourceAlias, lockMode);
        if (JoinType.INNER.equals((Object)joinType) && (this.isNullable() || !lhs.isInnerJoinPossible())) {
            joinType = JoinType.LEFT;
        }
        this.getEntityDescriptor().applyTableReferenceJoins(lhs, joinType, sqlAliasBase, joinCollector);
        return joinCollector.generateTableGroup(joinType);
    }

    @Override
    public Object unresolve(Object value, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (!this.getEntityDescriptor().isInstance(value)) {
            throw new HibernateException("Unexpected value for unresolve [" + value + "], expecting entity instance");
        }
        if (this.referencedUkAttributeName == null || this.classification.equals((Object)SingularPersistentAttribute.SingularAttributeClassification.ONE_TO_ONE)) {
            return this.getAssociatedEntityDescriptor().getIdentifierDescriptor().unresolve(ForeignKeys.getEntityIdentifierIfNotUnsaved(this.getAssociatedEntityDescriptor().getEntityName(), value, session), session);
        }
        NonIdPersistentAttribute referencedAttribute = this.getAssociatedEntityDescriptor().findPersistentAttribute(this.referencedUkAttributeName);
        return referencedAttribute.unresolve(referencedAttribute.getPropertyAccess().getGetter().get(value), session);
    }

    @Override
    public void dehydrate(Object value, Writeable.JdbcValueCollector jdbcValueCollector, Clause clause, SharedSessionContractImplementor session) {
        if (!clause.getInclusionChecker().test(this)) {
            return;
        }
        if (this.classification == SingularPersistentAttribute.SingularAttributeClassification.ONE_TO_ONE && this.isOptional() && !this.constrained) {
            return;
        }
        Navigable writeable = this.referencedUkAttributeName == null ? this.getAssociatedEntityDescriptor().getIdentifierDescriptor() : this.getAssociatedEntityDescriptor().findPersistentAttribute(this.referencedUkAttributeName);
        if (writeable != null) {
            Iterator<Column> columnItr = this.foreignKey.getColumnMappings().getReferringColumns().iterator();
            writeable.dehydrate(value, (jdbcValue, sqlExpressableType, boundColumn) -> {
                assert (columnItr.hasNext());
                jdbcValueCollector.collect(jdbcValue, sqlExpressableType, (Column)columnItr.next());
            }, clause, session);
            assert (!columnItr.hasNext());
        }
    }

    @Override
    public List<Column> getColumns() {
        return this.foreignKey.getColumnMappings().getReferringColumns();
    }

    @Override
    public SimpleTypeDescriptor<?> getValueGraphType() {
        return this.getEntityDescriptor();
    }

    @Override
    public SimpleTypeDescriptor<?> getKeyGraphType() {
        return this.entityDescriptor.getIdentifierDescriptor().getNavigableType();
    }

    @Override
    public Object resolveHydratedState(Object hydratedForm, ExecutionContext executionContext, SharedSessionContractImplementor session, Object containerInstance) {
        if (hydratedForm == null) {
            return null;
        }
        if (this.foreignKey.isReferenceToPrimaryKey()) {
            Object resolvedIdentifier = this.getEntityDescriptor().getHierarchy().getIdentifierDescriptor().resolveHydratedState(hydratedForm, executionContext, session, null);
            EntityKey entityKey = new EntityKey(resolvedIdentifier, this.getEntityDescriptor());
            Object entityInstance = executionContext.resolveEntityInstance(entityKey, !this.isOptional());
            if (entityInstance != null) {
                return entityInstance;
            }
            J loaded = this.getEntityDescriptor().getSingleIdLoader().load(resolvedIdentifier, LockOptions.READ, session);
            if (loaded != null) {
                return loaded;
            }
            throw new EntityNotFoundException(String.format(Locale.ROOT, "Unable to resolve entity-valued association [%s] foreign key value [%s] to associated entity instance of type [%s]", this.getNavigableRole(), resolvedIdentifier, this.getEntityDescriptor().getJavaTypeDescriptor()));
        }
        if (this.referencedUkAttributeName != null) {
            StandardSingleUniqueKeyEntityLoader loader = new StandardSingleUniqueKeyEntityLoader(this.referencedUkAttribute, this);
            EntityUniqueKey euk = new EntityUniqueKey(this.getEntityDescriptor().getEntityName(), this.referencedUkAttributeName, hydratedForm, (JavaTypeDescriptor)this.getAssociatedEntityDescriptor().getIdentifierDescriptor().getJavaTypeDescriptor(), (JavaTypeDescriptor)this.referencedUkAttribute.getJavaTypeDescriptor(), this.getEntityDescriptor().getHierarchy().getRepresentation());
            Object loaded = loader.load(hydratedForm, LockOptions.READ, session);
            return loaded;
        }
        return null;
    }

    @Override
    public void collectNonNullableTransientEntities(Object value, ForeignKeys.Nullifier nullifier, NonNullableTransientDependencies nonNullableTransientEntities, SharedSessionContractImplementor session) {
        if (!this.isNullable() && this.getAttributeTypeClassification() != SingularPersistentAttribute.SingularAttributeClassification.ONE_TO_ONE && nullifier.isNullifiable(this.getEntityDescriptor().getEntityName(), value)) {
            nonNullableTransientEntities.add(this.getEntityDescriptor().getEntityName(), value);
        }
    }

    @Override
    public int getNumberOfJdbcParametersNeeded() {
        return this.foreignKey.getColumnMappings().getColumnMappings().size();
    }

    public AllowableParameterType resolveTemporalPrecision(TemporalType temporalType, TypeConfiguration typeConfiguration) {
        throw new UnsupportedOperationException("ManyToOne cannot be treated as temporal type");
    }

    @Override
    public boolean isDirty(Object originalValue, Object currentValue, SharedSessionContractImplementor session) {
        if (Objects.equals(originalValue, currentValue)) {
            return false;
        }
        Object oldIdentifier = this.extractFkValue(originalValue);
        Object newIdentifier = this.extractFkValue(currentValue);
        return !this.getEntityDescriptor().getIdentifierDescriptor().areEqual(oldIdentifier, newIdentifier);
    }

    @Override
    public boolean areEqual(J x, J y) throws HibernateException {
        return this.getEntityDescriptor().areEqual(x, y);
    }

    @Override
    public int extractHashCode(J o) {
        return this.getEntityDescriptor().extractHashCode(o);
    }

    public Object extractFkValue(Object value) {
        if (value == null) {
            return null;
        }
        if (!this.getEntityDescriptor().isInstance(value)) {
            throw new HibernateException("Unexpected value for unresolve [" + value + "], expecting entity instance");
        }
        if (this.referencedUkAttributeName == null || this.classification.equals((Object)SingularPersistentAttribute.SingularAttributeClassification.ONE_TO_ONE)) {
            return this.getAssociatedEntityDescriptor().getIdentifier(value);
        }
        return this.getAssociatedEntityDescriptor().findPersistentAttribute(this.referencedUkAttributeName).getPropertyAccess().getGetter().get(value);
    }

    @Override
    public List<ColumnReference> resolveColumnReferences(ColumnReferenceQualifier qualifier, SqlAstCreationState creationState) {
        ArrayList<ColumnReference> columnReferences = new ArrayList<ColumnReference>();
        for (Column column : this.foreignKey.getColumnMappings().getReferringColumns()) {
            columnReferences.add(new ColumnReference(qualifier, column));
        }
        return columnReferences;
    }

    @Override
    protected void instantiationComplete(PersistentAttributeMapping bootModelAttribute, RuntimeModelCreationContext context) {
        super.instantiationComplete(bootModelAttribute, context);
        this.mutabilityPlan = ImmutableMutabilityPlan.INSTANCE;
    }

    public ForeignKey getForeignKey() {
        return this.foreignKey;
    }

    @Override
    public void visitColumns(BiConsumer<SqlExpressableType, Column> action, Clause clause, TypeConfiguration typeConfiguration) {
        for (ForeignKey.ColumnMappings.ColumnMapping columnMapping : this.getForeignKey().getColumnMappings().getColumnMappings()) {
            Column column = columnMapping.getReferringColumn();
            action.accept(column.getExpressableType(), column);
        }
    }
}

