/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.model.domain.spi.BasicValueMapper;
import org.hibernate.metamodel.model.domain.spi.IdentifiableTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.NavigableContainer;
import org.hibernate.metamodel.model.domain.spi.TenantDiscrimination;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.internal.ColumnBasedMapper;
import org.hibernate.type.spi.BasicType;

public class TenantDiscriminationImpl
implements TenantDiscrimination {
    private static final String NAVIGABLE_NAME = "{tenantId}";
    private final IdentifiableTypeDescriptor container;
    private final NavigableRole navigableRole;
    private final Column column;
    private final BasicValueMapper<String> valueMapper;
    private final boolean isShared;
    private final boolean useParameterBinding;

    public TenantDiscriminationImpl(IdentifiableTypeDescriptor container, Column column, boolean isShared, boolean useParameterBinding) {
        this.container = container;
        this.column = column;
        this.valueMapper = new ColumnBasedMapper<String>(column);
        this.isShared = isShared;
        this.useParameterBinding = useParameterBinding;
        this.navigableRole = container.getNavigableRole().append(NAVIGABLE_NAME);
    }

    @Override
    public NavigableContainer getContainer() {
        return this.container;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public BasicJavaDescriptor<String> getJavaTypeDescriptor() {
        return this.valueMapper.getDomainJavaDescriptor();
    }

    @Override
    public String asLoggableText() {
        return this.getNavigableRole().getFullPath();
    }

    @Override
    public Column getBoundColumn() {
        return this.column;
    }

    @Override
    public BasicValueMapper<String> getValueMapper() {
        return this.valueMapper;
    }

    @Override
    public SqlExpressableType getSqlExpressableType() {
        return this.column.getExpressableType();
    }

    public BasicType<String> getBasicType() {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public boolean isShared() {
        return this.isShared;
    }

    @Override
    public boolean isUseParameterBinding() {
        return this.useParameterBinding;
    }
}

