/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.collection;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.model.domain.internal.collection.CollectionCreationExecutor;
import org.hibernate.metamodel.model.domain.spi.CollectionIndex;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.tree.expression.LiteralParameter;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.exec.SqlExecLogger;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.BasicExecutionContext;
import org.hibernate.sql.exec.spi.JdbcMutation;
import org.hibernate.sql.exec.spi.JdbcMutationExecutor;
import org.hibernate.sql.exec.spi.JdbcParameter;
import org.jboss.logging.Logger;

public abstract class AbstractCreationExecutor
implements CollectionCreationExecutor {
    private static final Logger log = Logger.getLogger(AbstractCreationExecutor.class);
    private final PersistentCollectionDescriptor collectionDescriptor;
    private final JdbcMutation creationOperation;
    private final Map<Column, JdbcParameter> jdbcParameterMap;

    public AbstractCreationExecutor(PersistentCollectionDescriptor collectionDescriptor, Table dmlTargetTable, SessionFactoryImplementor sessionFactory) {
        this.collectionDescriptor = collectionDescriptor;
        HashMap<Column, JdbcParameter> jdbcParameterMap = new HashMap<Column, JdbcParameter>();
        this.creationOperation = this.generateCreationOperation(new TableReference(dmlTargetTable, null, false), sessionFactory, jdbcParameterMap::put);
        this.jdbcParameterMap = jdbcParameterMap;
    }

    public PersistentCollectionDescriptor getCollectionDescriptor() {
        return this.collectionDescriptor;
    }

    protected JdbcMutation getCreationOperation() {
        return this.creationOperation;
    }

    protected abstract JdbcMutation generateCreationOperation(TableReference var1, SessionFactoryImplementor var2, BiConsumer<Column, JdbcParameter> var3);

    @Override
    public void execute(PersistentCollection collection, Object key, SharedSessionContractImplementor session) {
        if (key == null) {
            key = collection.getKey();
        }
        assert (key != null);
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl();
        BasicExecutionContext executionContext = new BasicExecutionContext(session);
        Iterator entries = collection.entries(this.collectionDescriptor);
        if (!entries.hasNext()) {
            SqlExecLogger.INSTANCE.debugf("Collection was empty - nothing to (re)create : %s", LoggingHelper.toLoggableString(this.collectionDescriptor.getNavigableRole(), collection.getKey()));
            return;
        }
        int passes = 0;
        int count = 0;
        collection.preInsert(this.collectionDescriptor);
        while (entries.hasNext()) {
            Object entry = entries.next();
            if (collection.entryExists(entry, passes)) {
                this.bindCollectionKey(key, jdbcParameterBindings, session);
                this.bindCollectionId(entry, passes, collection, jdbcParameterBindings, session);
                this.bindCollectionIndex(entry, passes, collection, jdbcParameterBindings, session);
                this.bindCollectionElement(entry, collection, jdbcParameterBindings, session);
                ++count;
                JdbcMutationExecutor.WITH_AFTER_STATEMENT_CALL.execute(this.creationOperation, jdbcParameterBindings, executionContext);
                collection.afterRowInsert(this.collectionDescriptor, entry, passes);
            }
            ++passes;
            jdbcParameterBindings.clear();
        }
        log.debugf("Done inserting rows: %s inserted", count);
    }

    protected void bindCollectionId(Object entry, int assumedIdentifier, PersistentCollection collection, JdbcParameterBindingsImpl jdbcParameterBindings, SharedSessionContractImplementor session) {
        if (this.collectionDescriptor.getIdDescriptor() != null) {
            Object identifier = collection.getIdentifier(entry, assumedIdentifier, this.collectionDescriptor);
            this.collectionDescriptor.getIdDescriptor().dehydrate(this.collectionDescriptor.getIdDescriptor().unresolve(identifier, session), (jdbcValue, type, boundColumn) -> this.createBinding(jdbcValue, boundColumn, type, jdbcParameterBindings, session), Clause.INSERT, session);
        }
    }

    protected void bindCollectionIndex(Object entry, int assumedIndex, PersistentCollection collection, JdbcParameterBindingsImpl jdbcParameterBindings, SharedSessionContractImplementor session) {
        CollectionIndex indexDescriptor = this.collectionDescriptor.getIndexDescriptor();
        if (indexDescriptor != null) {
            Object index = collection.getIndex(entry, assumedIndex, this.collectionDescriptor);
            if (indexDescriptor.getBaseIndex() != 0) {
                index = (Integer)index + indexDescriptor.getBaseIndex();
            }
            indexDescriptor.dehydrate(indexDescriptor.unresolve(index, session), (jdbcValue, type, boundColumn) -> this.createBinding(jdbcValue, boundColumn, type, jdbcParameterBindings, session), Clause.INSERT, session);
        }
    }

    protected void bindCollectionKey(Object key, JdbcParameterBindingsImpl jdbcParameterBindings, SharedSessionContractImplementor session) {
        this.collectionDescriptor.getCollectionKeyDescriptor().dehydrate(this.collectionDescriptor.getCollectionKeyDescriptor().unresolve(key, session), (jdbcValue, type, boundColumn) -> this.createBinding(jdbcValue, boundColumn, type, jdbcParameterBindings, session), Clause.INSERT, session);
    }

    protected void createBinding(Object jdbcValue, Column boundColumn, SqlExpressableType type, JdbcParameterBindingsImpl jdbcParameterBindings, SharedSessionContractImplementor session) {
        JdbcParameter jdbcParameter = this.resolveJdbcParameter(boundColumn);
        jdbcParameterBindings.addBinding(jdbcParameter, new LiteralParameter(jdbcValue, type, Clause.INSERT, session.getFactory().getTypeConfiguration()));
    }

    protected JdbcParameter resolveJdbcParameter(Column boundColumn) {
        JdbcParameter jdbcParameter = this.jdbcParameterMap.get(boundColumn);
        if (jdbcParameter == null) {
            throw new IllegalStateException("JdbcParameter not found for Column [" + boundColumn + "]");
        }
        return jdbcParameter;
    }

    protected void bindCollectionElement(Object entry, PersistentCollection collection, JdbcParameterBindingsImpl jdbcParameterBindings, SharedSessionContractImplementor session) {
        this.collectionDescriptor.getElementDescriptor().dehydrate(this.collectionDescriptor.getElementDescriptor().unresolve(collection.getElement(entry, this.collectionDescriptor), session), (jdbcValue, type, boundColumn) -> this.createBinding(jdbcValue, boundColumn, type, jdbcParameterBindings, session), Clause.INSERT, session);
    }
}

