/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.collection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.model.domain.CollectionDomainType;
import org.hibernate.metamodel.model.domain.internal.collection.SqlAstCreationStateImpl;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.spi.ComparisonOperator;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.consume.spi.SelfRenderingExpression;
import org.hibernate.sql.ast.consume.spi.SqlAppender;
import org.hibernate.sql.ast.consume.spi.SqlAstSelectToJdbcSelectConverter;
import org.hibernate.sql.ast.consume.spi.SqlAstWalker;
import org.hibernate.sql.ast.produce.internal.SqlAstSelectDescriptorImpl;
import org.hibernate.sql.ast.produce.spi.QualifiableSqlExpressable;
import org.hibernate.sql.ast.produce.spi.SqlAstCreationState;
import org.hibernate.sql.ast.produce.spi.SqlSelectionExpression;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.LiteralParameter;
import org.hibernate.sql.ast.tree.expression.PositionalParameter;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.SelfRenderingPredicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcSelectExecutorStandardImpl;
import org.hibernate.sql.exec.internal.RowTransformerSingularReturnImpl;
import org.hibernate.sql.exec.spi.BasicExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameter;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.SqlSelection;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class AbstractSelector {
    private final PersistentCollectionDescriptor collectionDescriptor;
    private final JdbcSelect jdbcSelect;
    private final Map<Column, JdbcParameter> jdbcParameterMap;

    public AbstractSelector(PersistentCollectionDescriptor collectionDescriptor, Table table, String sqlWhereString, SessionFactoryImplementor sessionFactory) {
        this.collectionDescriptor = collectionDescriptor;
        this.jdbcParameterMap = new HashMap<Column, JdbcParameter>();
        this.jdbcSelect = this.generateSelect(table, sqlWhereString, this.jdbcParameterMap::put, sessionFactory);
    }

    protected PersistentCollectionDescriptor getCollectionDescriptor() {
        return this.collectionDescriptor;
    }

    protected List execute(JdbcParameterBindings jdbcParameterBindings, SharedSessionContractImplementor session) {
        BasicExecutionContext executionContext = new BasicExecutionContext(session);
        return JdbcSelectExecutorStandardImpl.INSTANCE.list(this.jdbcSelect, jdbcParameterBindings, executionContext, RowTransformerSingularReturnImpl.INSTANCE);
    }

    private JdbcSelect generateSelect(Table table, String sqlWhereString, BiConsumer<Column, JdbcParameter> columnCollector, SessionFactoryImplementor sessionFactory) {
        QuerySpec querySpec = new QuerySpec(true);
        SelectStatement selectStatement = new SelectStatement(querySpec);
        SqlAstCreationStateImpl creationState = this.getCreationState(sessionFactory, querySpec);
        TableGroup rootTableGroup = this.createTableGroup(creationState);
        querySpec.getFromClause().addRoot(rootTableGroup);
        creationState.getFromClauseAccess().registerTableGroup(rootTableGroup.getNavigablePath(), rootTableGroup);
        SelectClause selectClause = selectStatement.getQuerySpec().getSelectClause();
        ArrayList<DomainResult> domainResults = new ArrayList<DomainResult>();
        this.applySqlSelections(querySpec, rootTableGroup, selectClause, domainResults::add, creationState);
        Junction predicate = new Junction(Junction.Nature.CONJUNCTION);
        this.applyPredicates(predicate, rootTableGroup, columnCollector, creationState);
        querySpec.addRestriction(predicate);
        this.applyWhereFragment(sqlWhereString, querySpec);
        HashSet<String> affectedTableNames = new HashSet<String>();
        affectedTableNames.add(table.getTableExpression());
        return SqlAstSelectToJdbcSelectConverter.interpret(new SqlAstSelectDescriptorImpl(selectStatement, domainResults, affectedTableNames), sessionFactory);
    }

    protected SqlAstCreationStateImpl getCreationState(SessionFactoryImplementor sessionFactory, QuerySpec querySpec) {
        return new SqlAstCreationStateImpl(sessionFactory, querySpec);
    }

    private TableGroup createTableGroup(SqlAstCreationStateImpl creationState) {
        return this.collectionDescriptor.createRootTableGroup(new NavigablePath(this.collectionDescriptor.getNavigableRole().getFullPath()), null, null, LockMode.NONE, creationState);
    }

    protected abstract void applySqlSelections(QuerySpec var1, TableGroup var2, SelectClause var3, Consumer<DomainResult> var4, DomainResultCreationState var5);

    protected abstract void applyPredicates(Junction var1, TableGroup var2, BiConsumer<Column, JdbcParameter> var3, SqlAstCreationState var4);

    protected <T> void applyPredicates(Junction junction, Navigable<T> navigable, TableGroup tableGroup, BiConsumer<Column, JdbcParameter> columnCollector, SqlAstCreationState creationState) {
        TypeConfiguration typeConfiguration = creationState.getCreationContext().getDomainModel().getTypeConfiguration();
        AtomicInteger parameterCount = new AtomicInteger();
        navigable.visitColumns((sqlExpressableType, column) -> {
            PositionalParameter parameter = new PositionalParameter(parameterCount.getAndIncrement(), column.getExpressableType(), Clause.WHERE, typeConfiguration);
            columnCollector.accept((Column)column, parameter);
            Expression expression = tableGroup.qualify((QualifiableSqlExpressable)column);
            ColumnReference columnReference = !(expression instanceof ColumnReference) ? (ColumnReference)((SqlSelectionExpression)expression).getExpression() : (ColumnReference)expression;
            junction.add(new ComparisonPredicate(columnReference, ComparisonOperator.EQUAL, parameter));
        }, Clause.WHERE, typeConfiguration);
    }

    protected void bindCollectionIndex(Object index, JdbcParameterBindings jdbcParameterBindings, SharedSessionContractImplementor session) {
        this.bindValue(index, this.getCollectionDescriptor().getIndexDescriptor(), jdbcParameterBindings, session);
    }

    protected void bindCollectionKey(Object key, JdbcParameterBindings jdbcParameterBindings, SharedSessionContractImplementor session) {
        this.bindValue(key, this.getCollectionDescriptor().getCollectionKeyDescriptor(), jdbcParameterBindings, session);
    }

    protected void bindCollectionElement(Object entry, PersistentCollection collection, JdbcParameterBindings jdbcParameterBindings, SharedSessionContractImplementor session) {
        CollectionDomainType.Element elementDescriptor = this.getCollectionDescriptor().getElementDescriptor();
        Object unresolved = elementDescriptor.unresolve(entry, session);
        this.bindValue(unresolved, (Navigable)((Object)elementDescriptor), jdbcParameterBindings, session);
    }

    private void bindValue(Object value, Navigable navigable, JdbcParameterBindings jdbcParameterBindings, SharedSessionContractImplementor session) {
        navigable.dehydrate(value, (jdbcValue, type, boundColumn) -> this.createBinding(jdbcValue, boundColumn, type, jdbcParameterBindings, session), Clause.WHERE, session);
    }

    private void applyWhereFragment(final String sqlWhereString, QuerySpec querySpec) {
        if (StringHelper.isNotEmpty(sqlWhereString)) {
            SelfRenderingExpression whereExpression = new SelfRenderingExpression(){

                @Override
                public void renderToSql(SqlAppender sqlAppender, SqlAstWalker walker, SessionFactoryImplementor sessionFactory) {
                    sqlAppender.appendSql(sqlWhereString);
                }

                @Override
                public SqlExpressableType getType() {
                    return null;
                }

                @Override
                public SqlSelection createSqlSelection(int jdbcPosition, int valuesArrayPosition, BasicJavaDescriptor javaTypeDescriptor, TypeConfiguration typeConfiguration) {
                    return null;
                }
            };
            SelfRenderingPredicate wherePredicate = new SelfRenderingPredicate(whereExpression);
            querySpec.addRestriction(wherePredicate);
        }
    }

    private void createBinding(Object jdbcValue, Column boundColumn, SqlExpressableType type, JdbcParameterBindings jdbcParameterBindings, SharedSessionContractImplementor session) {
        JdbcParameter jdbcParameter = this.resolveJdbcParameter(boundColumn);
        jdbcParameterBindings.addBinding(jdbcParameter, new LiteralParameter(jdbcValue, type, Clause.INSERT, session.getFactory().getTypeConfiguration()));
    }

    private JdbcParameter resolveJdbcParameter(Column boundColumn) {
        JdbcParameter jdbcParameter = this.jdbcParameterMap.get(boundColumn);
        if (jdbcParameter == null) {
            throw new IllegalStateException("JdbcParameter not found for Column [" + boundColumn + "]");
        }
        return jdbcParameter;
    }
}

