/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.collection;

import java.util.function.BiConsumer;
import org.hibernate.boot.model.domain.BasicValueMapping;
import org.hibernate.mapping.Collection;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.spi.AbstractCollectionElement;
import org.hibernate.metamodel.model.domain.spi.BasicCollectionElement;
import org.hibernate.metamodel.model.domain.spi.BasicValueMapper;
import org.hibernate.metamodel.model.domain.spi.CollectionElement;
import org.hibernate.metamodel.model.domain.spi.ConvertibleNavigable;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.domain.spi.SimpleTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.TableReferenceJoinCollector;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.JoinType;
import org.hibernate.sql.ast.produce.spi.ColumnReferenceQualifier;
import org.hibernate.sql.ast.produce.spi.SqlAliasBase;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class BasicCollectionElementImpl<J>
extends AbstractCollectionElement<J>
implements BasicCollectionElement<J>,
ConvertibleNavigable<J> {
    private static final Logger log = Logger.getLogger(BasicCollectionElementImpl.class);
    private final Column column;
    private final BasicValueMapper<J> valueMapper;
    private final boolean nullable;

    public BasicCollectionElementImpl(PersistentCollectionDescriptor descriptor, Collection bootCollectionMapping, RuntimeModelCreationContext creationContext) {
        super(descriptor);
        BasicValueMapping simpleElementValueMapping = (BasicValueMapping)((Object)bootCollectionMapping.getElement());
        this.column = creationContext.getDatabaseObjectResolver().resolveColumn(simpleElementValueMapping.getMappedColumn());
        this.valueMapper = ((BasicValueMapping)((Object)bootCollectionMapping.getElement())).getResolution().getValueMapper();
        if (this.valueMapper.getValueConverter() != null) {
            log.debugf("BasicValueConverter [%s] being applied for basic collection elements : %s", (Object)this.valueMapper.getValueConverter(), (Object)this.getNavigableRole());
        }
        this.nullable = bootCollectionMapping.getElement().isNullable();
    }

    @Override
    public BasicJavaDescriptor<J> getJavaTypeDescriptor() {
        return this.valueMapper.getDomainJavaDescriptor();
    }

    @Override
    public BasicValueConverter getValueConverter() {
        return this.valueMapper.getValueConverter();
    }

    @Override
    public CollectionElement.ElementClassification getClassification() {
        return CollectionElement.ElementClassification.BASIC;
    }

    @Override
    public SimpleTypeDescriptor getDomainTypeDescriptor() {
        return this;
    }

    @Override
    public void visitColumns(BiConsumer<SqlExpressableType, Column> action, Clause clause, TypeConfiguration typeConfiguration) {
        action.accept(this.column.getExpressableType(), this.column);
    }

    @Override
    public Column getBoundColumn() {
        return this.column;
    }

    @Override
    public BasicValueMapper<J> getValueMapper() {
        return this.valueMapper;
    }

    @Override
    public SqlExpressableType getSqlExpressableType() {
        return this.valueMapper.getSqlExpressableType();
    }

    @Override
    public void applyTableReferenceJoins(ColumnReferenceQualifier lhs, JoinType joinType, SqlAliasBase sqlAliasBase, TableReferenceJoinCollector joinCollector) {
    }

    @Override
    public boolean hasNotNullColumns() {
        return !this.nullable;
    }

    @Override
    public boolean isMutable() {
        return this.getJavaTypeDescriptor().getMutabilityPlan().isMutable();
    }
}

