/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.collection;

import java.util.Collections;
import java.util.List;
import org.hibernate.boot.model.domain.BasicValueMapping;
import org.hibernate.boot.model.relational.MappedColumn;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.spi.AbstractCollectionIndex;
import org.hibernate.metamodel.model.domain.spi.BasicCollectionIndex;
import org.hibernate.metamodel.model.domain.spi.BasicValueMapper;
import org.hibernate.metamodel.model.domain.spi.ConvertibleNavigable;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.domain.spi.SimpleTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.TableReferenceJoinCollector;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.JoinType;
import org.hibernate.sql.ast.produce.spi.ColumnReferenceQualifier;
import org.hibernate.sql.ast.produce.spi.SqlAliasBase;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.jboss.logging.Logger;

public class BasicCollectionIndexImpl<J>
extends AbstractCollectionIndex<J>
implements BasicCollectionIndex<J>,
ConvertibleNavigable<J> {
    private static final Logger log = Logger.getLogger(BasicCollectionIndexImpl.class);
    private final Column column;
    private final BasicValueMapper<J> valueMapper;
    private final boolean nullable;

    public BasicCollectionIndexImpl(PersistentCollectionDescriptor descriptor, IndexedCollection bootCollectionMapping, RuntimeModelCreationContext creationContext) {
        super(descriptor, bootCollectionMapping);
        BasicValueMapping valueMapping = (BasicValueMapping)((Object)bootCollectionMapping.getIndex());
        MappedColumn mappedColumn = valueMapping.getMappedColumn();
        Column resolvedColumn = creationContext.getDatabaseObjectResolver().resolveColumn(mappedColumn);
        this.column = resolvedColumn != null ? resolvedColumn.clone(mappedColumn.isInsertable(), mappedColumn.isUpdatable()) : resolvedColumn;
        this.valueMapper = valueMapping.getResolution().getValueMapper();
        if (this.valueMapper.getValueConverter() != null) {
            log.debugf("BasicValueConverter [%s] being applied for basic collection elements : %s", (Object)this.valueMapper.getValueConverter(), (Object)this.getNavigableRole());
        }
        this.nullable = bootCollectionMapping.getIndex().isNullable();
    }

    @Override
    public BasicJavaDescriptor<J> getJavaTypeDescriptor() {
        return this.valueMapper.getDomainJavaDescriptor();
    }

    @Override
    public BasicValueConverter getValueConverter() {
        return this.valueMapper.getValueConverter();
    }

    @Override
    public Column getBoundColumn() {
        return this.column;
    }

    @Override
    public BasicValueMapper<J> getValueMapper() {
        return this.valueMapper;
    }

    @Override
    public SqlExpressableType getSqlExpressableType() {
        return this.valueMapper.getSqlExpressableType();
    }

    @Override
    public SimpleTypeDescriptor<?> getDomainTypeDescriptor() {
        return this;
    }

    @Override
    public List<Column> getColumns() {
        return Collections.singletonList(this.getBoundColumn());
    }

    @Override
    public void applyTableReferenceJoins(ColumnReferenceQualifier lhs, JoinType joinType, SqlAliasBase sqlAliasBase, TableReferenceJoinCollector joinCollector) {
    }

    @Override
    public boolean hasNotNullColumns() {
        return !this.nullable;
    }
}

