/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.collection;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.HibernateException;
import org.hibernate.boot.model.domain.spi.EmbeddedValueMappingImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.Collection;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.spi.AbstractCollectionElement;
import org.hibernate.metamodel.model.domain.spi.CollectionElementEmbedded;
import org.hibernate.metamodel.model.domain.spi.EmbeddedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.NavigableVisitationStrategy;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.domain.spi.SingularPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.TableReferenceJoinCollector;
import org.hibernate.metamodel.model.domain.spi.Writeable;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.JoinType;
import org.hibernate.sql.ast.produce.metamodel.spi.Fetchable;
import org.hibernate.sql.ast.produce.spi.ColumnReferenceQualifier;
import org.hibernate.sql.ast.produce.spi.SqlAliasBase;
import org.hibernate.sql.ast.produce.spi.TableReferenceContributor;
import org.hibernate.type.descriptor.java.spi.EmbeddableJavaDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class CollectionElementEmbeddedImpl<J>
extends AbstractCollectionElement<J>
implements CollectionElementEmbedded<J> {
    private final EmbeddedTypeDescriptor<J> embeddedDescriptor;

    public CollectionElementEmbeddedImpl(PersistentCollectionDescriptor descriptor, Collection mapping, RuntimeModelCreationContext creationContext) {
        super(descriptor);
        this.embeddedDescriptor = creationContext.getRuntimeModelDescriptorFactory().createEmbeddedTypeDescriptor((EmbeddedValueMappingImplementor)((Object)mapping.getElement()), descriptor, null, "{element}", SingularPersistentAttribute.Disposition.NORMAL, creationContext);
    }

    @Override
    public EmbeddedTypeDescriptor<J> getEmbeddedDescriptor() {
        return this.embeddedDescriptor;
    }

    @Override
    public EmbeddableJavaDescriptor<J> getJavaTypeDescriptor() {
        return this.getEmbeddedDescriptor().getJavaTypeDescriptor();
    }

    @Override
    public <N> Navigable<N> findNavigable(String navigableName) {
        return this.getEmbeddedDescriptor().findNavigable(navigableName);
    }

    @Override
    public void visitNavigables(NavigableVisitationStrategy visitor) {
        this.getEmbeddedDescriptor().visitNavigables(visitor);
    }

    @Override
    public void visitColumns(BiConsumer<SqlExpressableType, Column> action, Clause clause, TypeConfiguration typeConfiguration) {
        this.getEmbeddedDescriptor().visitColumns(action, clause, typeConfiguration);
    }

    @Override
    public Object unresolve(Object value, SharedSessionContractImplementor session) {
        return this.getEmbeddedDescriptor().unresolve(value, session);
    }

    @Override
    public void dehydrate(Object value, Writeable.JdbcValueCollector jdbcValueCollector, Clause clause, SharedSessionContractImplementor session) {
        this.getEmbeddedDescriptor().dehydrate(value, jdbcValueCollector, clause, session);
    }

    @Override
    public void visitFetchables(Consumer<Fetchable> fetchableConsumer) {
        this.getEmbeddedDescriptor().visitFetchables(fetchableConsumer);
    }

    @Override
    public void applyTableReferenceJoins(ColumnReferenceQualifier lhs, JoinType joinType, SqlAliasBase sqlAliasBase, TableReferenceJoinCollector joinCollector) {
        this.getEmbeddedDescriptor().visitStateArrayContributors(contributor -> {
            if (contributor instanceof TableReferenceContributor) {
                ((TableReferenceContributor)((Object)contributor)).applyTableReferenceJoins(lhs, joinType, sqlAliasBase, joinCollector);
            }
        });
    }

    @Override
    public EmbeddedTypeDescriptor<J> getDomainTypeDescriptor() {
        return this.getEmbeddedDescriptor();
    }

    @Override
    public boolean hasNotNullColumns() {
        return this.getEmbeddedDescriptor().visitAndCollectStateArrayContributors(contributor -> !contributor.isNullable()).stream().anyMatch(value -> value == true);
    }

    @Override
    public boolean isMutable() {
        return this.getJavaTypeDescriptor().getMutabilityPlan().isMutable();
    }

    @Override
    public boolean isDirty(Object one, Object another, SharedSessionContractImplementor session) {
        return this.getEmbeddedDescriptor().isDirty(one, another, session);
    }

    @Override
    public boolean areEqual(J x, J y) throws HibernateException {
        return this.getEmbeddedDescriptor().areEqual(x, y);
    }

    @Override
    public int extractHashCode(J o) {
        return this.getEmbeddedDescriptor().extractHashCode(o);
    }
}

