/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.HibernateException;
import org.hibernate.boot.model.relational.MappedColumn;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.ToOne;
import org.hibernate.metamodel.model.creation.spi.DatabaseObjectResolver;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.spi.AbstractCollectionElement;
import org.hibernate.metamodel.model.domain.spi.CollectionElement;
import org.hibernate.metamodel.model.domain.spi.CollectionElementEntity;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.NavigableVisitationStrategy;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.domain.spi.SimpleTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.TableReferenceJoinCollector;
import org.hibernate.metamodel.model.domain.spi.Writeable;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.ForeignKey;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.query.spi.ComparisonOperator;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.JoinType;
import org.hibernate.sql.ast.produce.metamodel.spi.Fetchable;
import org.hibernate.sql.ast.produce.spi.ColumnReferenceQualifier;
import org.hibernate.sql.ast.produce.spi.SqlAliasBase;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.type.descriptor.java.spi.EntityJavaDescriptor;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class CollectionElementEntityImpl<J>
extends AbstractCollectionElement<J>
implements CollectionElementEntity<J> {
    private static final Logger log = Logger.getLogger(CollectionElementEntityImpl.class);
    private final CollectionElement.ElementClassification elementClassification;
    private final EntityTypeDescriptor<J> entityDescriptor;
    private boolean fullyInitialized;
    private ForeignKey foreignKey;
    private Navigable foreignKeyTargetNavigable;

    public CollectionElementEntityImpl(PersistentCollectionDescriptor runtimeDescriptor, org.hibernate.mapping.Collection bootDescriptor, CollectionElement.ElementClassification elementClassification, RuntimeModelCreationContext creationContext) {
        super(runtimeDescriptor);
        this.elementClassification = elementClassification;
        this.entityDescriptor = this.resolveEntityDescriptor(elementClassification, bootDescriptor, creationContext);
        creationContext.registerNavigable(this, bootDescriptor);
    }

    private EntityTypeDescriptor<J> resolveEntityDescriptor(CollectionElement.ElementClassification elementClassification, org.hibernate.mapping.Collection mappingBinding, RuntimeModelCreationContext creationContext) {
        String elementEntityName;
        if (elementClassification == CollectionElement.ElementClassification.MANY_TO_MANY) {
            elementEntityName = ((ToOne)mappingBinding.getElement()).getReferencedEntityName();
        } else if (elementClassification == CollectionElement.ElementClassification.ONE_TO_MANY) {
            elementEntityName = ((OneToMany)mappingBinding.getElement()).getReferencedEntityName();
        } else {
            throw new HibernateException(String.format(Locale.ROOT, "Unexpected collection element classification [%s] for an entity-valued element", elementClassification.name()));
        }
        return creationContext.getInFlightRuntimeModel().findEntityDescriptor(elementEntityName);
    }

    @Override
    public boolean finishInitialization(Object bootReference, RuntimeModelCreationContext creationContext) {
        if (!this.fullyInitialized) {
            try {
                boolean done = this.tryFinishInitialize((org.hibernate.mapping.Collection)bootReference, creationContext);
                if (!done) {
                    return false;
                }
            }
            catch (Exception e) {
                log.debugf((Throwable)e, "#finishInitialization threw exception : %s ", (Object)this.getNavigableRole().getFullPath());
                return false;
            }
            this.fullyInitialized = true;
        }
        return true;
    }

    protected boolean tryFinishInitialize(org.hibernate.mapping.Collection bootDescriptor, RuntimeModelCreationContext creationContext) {
        String mappedBy = bootDescriptor.getMappedByProperty();
        this.foreignKeyTargetNavigable = StringHelper.isEmpty(mappedBy) ? this.getEntityDescriptor().getIdentifierDescriptor() : this.getEntityDescriptor().findNavigable(mappedBy);
        assert (this.foreignKeyTargetNavigable != null);
        this.foreignKey = this.resolveForeignKey(bootDescriptor, this.getEntityDescriptor().getPrimaryTable(), creationContext);
        return true;
    }

    @Override
    public EntityTypeDescriptor<J> getEntityDescriptor() {
        return this.entityDescriptor;
    }

    @Override
    public String getEntityName() {
        return this.getEntityDescriptor().getEntityName();
    }

    @Override
    public String getJpaEntityName() {
        return this.getEntityDescriptor().getJpaEntityName();
    }

    @Override
    public CollectionElement.ElementClassification getClassification() {
        return this.elementClassification;
    }

    @Override
    public Table getPrimaryDmlTable() {
        return this.entityDescriptor.getPrimaryTable();
    }

    @Override
    public SimpleTypeDescriptor getDomainTypeDescriptor() {
        return this.getEntityDescriptor();
    }

    @Override
    public <N> Navigable<N> findNavigable(String navigableName) {
        return this.getEntityDescriptor().findNavigable(navigableName);
    }

    @Override
    public void visitNavigables(NavigableVisitationStrategy visitor) {
        this.getEntityDescriptor().visitNavigables(visitor);
    }

    @Override
    public EntityJavaDescriptor<J> getJavaTypeDescriptor() {
        return this.getEntityDescriptor().getJavaTypeDescriptor();
    }

    @Override
    public void applyTableReferenceJoins(ColumnReferenceQualifier lhs, JoinType joinType, SqlAliasBase sqlAliasBase, TableReferenceJoinCollector joinCollector) {
        if (joinCollector.getPrimaryTableReference() != null) {
            TableReference joinedTableReference = new TableReference(this.getEntityDescriptor().getPrimaryTable(), sqlAliasBase.generateNewAlias(), false);
            joinCollector.addSecondaryReference(new TableReferenceJoin(joinType, joinedTableReference, this.makePredicate(joinCollector.getPrimaryTableReference(), joinedTableReference)));
            lhs = joinedTableReference;
        } else {
            joinCollector.addPrimaryReference(new TableReference(this.getEntityDescriptor().getPrimaryTable(), sqlAliasBase.generateNewAlias(), false));
            lhs = joinCollector.getPrimaryTableReference();
        }
        this.getEntityDescriptor().applyTableReferenceJoins(lhs, joinType, sqlAliasBase, joinCollector);
    }

    private Predicate makePredicate(ColumnReferenceQualifier lhs, TableReference rhs) {
        Junction conjunction = new Junction(Junction.Nature.CONJUNCTION);
        for (ForeignKey foreignKey : this.getContainer().getCollectionKeyDescriptor().getJoinForeignKey().getReferringTable().getForeignKeys()) {
            if (!foreignKey.getTargetTable().equals(rhs.getTable())) continue;
            for (ForeignKey.ColumnMappings.ColumnMapping columnMapping : foreignKey.getColumnMappings().getColumnMappings()) {
                ColumnReference referringColumnReference = lhs.resolveColumnReference(columnMapping.getReferringColumn());
                ColumnReference targetColumnReference = rhs.resolveColumnReference(columnMapping.getTargetColumn());
                conjunction.add(new ComparisonPredicate(referringColumnReference, ComparisonOperator.EQUAL, targetColumnReference));
            }
        }
        return conjunction;
    }

    @Override
    public void visitJdbcTypes(Consumer<SqlExpressableType> action, Clause clause, TypeConfiguration typeConfiguration) {
        this.visitColumns((sqlExpressableType, column) -> action.accept((SqlExpressableType)sqlExpressableType), clause, typeConfiguration);
    }

    @Override
    public Object unresolve(Object value, SharedSessionContractImplementor session) {
        return this.getEntityDescriptor().getIdentifierDescriptor().unresolve(this.getEntityDescriptor().getIdentifier(value), session);
    }

    @Override
    public void dehydrate(Object value, Writeable.JdbcValueCollector jdbcValueCollector, Clause clause, SharedSessionContractImplementor session) {
        this.getEntityDescriptor().getIdentifierDescriptor().dehydrate(value, (jdbcValue, sqlExpressableType, boundColumn) -> jdbcValueCollector.collect(jdbcValue, sqlExpressableType, this.getClassification() == CollectionElement.ElementClassification.ONE_TO_MANY ? boundColumn : this.foreignKey.resolveReferringFromTargetColumn(boundColumn)), clause, session);
    }

    @Override
    public void visitColumns(BiConsumer<SqlExpressableType, Column> action, Clause clause, TypeConfiguration typeConfiguration) {
        if (this.getCollectionDescriptor().isOneToMany()) {
            this.getEntityDescriptor().getIdentifierDescriptor().visitColumns(action, clause, typeConfiguration);
        } else {
            this.foreignKey.getColumnMappings().getReferringColumns().forEach(column -> action.accept(column.getExpressableType(), (Column)column));
        }
    }

    @Override
    public boolean isNullable() {
        return this.getCollectionDescriptor().getDescribedAttribute().isNullable();
    }

    @Override
    public void visitFetchables(Consumer<Fetchable> fetchableConsumer) {
        this.entityDescriptor.visitFetchables(fetchableConsumer);
    }

    private ForeignKey resolveForeignKey(org.hibernate.mapping.Collection bootDescriptor, Table table, RuntimeModelCreationContext creationContext) {
        DatabaseObjectResolver databaseObjectResolver = creationContext.getDatabaseObjectResolver();
        Collection<ForeignKey> foreignKeys = databaseObjectResolver.resolveForeignKey(bootDescriptor.getForeignKey()).getReferringTable().getForeignKeys();
        ForeignKey resolvedForeignKey = null;
        if (this.elementClassification.equals((Object)CollectionElement.ElementClassification.MANY_TO_MANY)) {
            List<Column> elementColumns = this.getElementColumns(bootDescriptor, databaseObjectResolver);
            for (ForeignKey foreignKey : foreignKeys) {
                if (!foreignKey.getTargetTable().equals(table)) continue;
                boolean columnsMatch = true;
                List<Column> referringColumns = foreignKey.getColumnMappings().getReferringColumns();
                for (Column column : elementColumns) {
                    if (referringColumns.contains(column)) continue;
                    columnsMatch = false;
                    break;
                }
                if (!columnsMatch) continue;
                resolvedForeignKey = foreignKey;
                break;
            }
        } else {
            for (ForeignKey foreignKey : foreignKeys) {
                if (!foreignKey.getReferringTable().equals(table)) continue;
                resolvedForeignKey = foreignKey;
                break;
            }
        }
        assert (resolvedForeignKey != null);
        return resolvedForeignKey;
    }

    private List<Column> getElementColumns(org.hibernate.mapping.Collection bootDescriptor, DatabaseObjectResolver databaseObjectResolver) {
        ArrayList<Column> elementColumns = new ArrayList<Column>();
        bootDescriptor.getElement().getMappedColumns().forEach(column -> elementColumns.add(databaseObjectResolver.resolveColumn((MappedColumn)column)));
        return elementColumns;
    }

    @Override
    public boolean hasNotNullColumns() {
        return this.getEntityDescriptor().visitAndCollectStateArrayContributors(contributor -> !contributor.isNullable()).stream().anyMatch(value -> value == true);
    }

    @Override
    public boolean isMutable() {
        return this.getJavaTypeDescriptor().getMutabilityPlan().isMutable();
    }

    @Override
    public J replace(J originalValue, J targetValue, Object owner, Map copyCache, SessionImplementor session) {
        return (J)this.getJavaTypeDescriptor().getMutabilityPlan().replace(this.getEntityDescriptor(), originalValue, targetValue, owner, copyCache, session);
    }

    @Override
    public boolean isDirty(Object one, Object another, SharedSessionContractImplementor session) {
        return this.getEntityDescriptor().isDirty(one, another, session);
    }
}

