/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.collection;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.internal.collection.AbstractSelector;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.produce.spi.SqlAstCreationState;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.JdbcParameter;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.sql.results.internal.domain.basic.BasicResultImpl;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.type.descriptor.java.internal.IntegerJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.sql.spi.IntegerSqlDescriptor;

public class CollectionElementExistsSelector
extends AbstractSelector {
    public CollectionElementExistsSelector(PersistentCollectionDescriptor collectionDescriptor, Table table, String sqlWhereString, SessionFactoryImplementor sessionFactory) {
        super(collectionDescriptor, table, sqlWhereString, sessionFactory);
    }

    public Boolean elementExists(Object loadedKey, Object element, PersistentCollection collection, SharedSessionContractImplementor session) {
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl();
        this.bindCollectionKey(loadedKey, jdbcParameterBindings, session);
        this.bindCollectionElement(element, collection, jdbcParameterBindings, session);
        List results = this.execute(jdbcParameterBindings, session);
        return !results.isEmpty();
    }

    @Override
    protected void applySqlSelections(QuerySpec querySpec, TableGroup tableGroup, SelectClause selectClause, Consumer<DomainResult> domainResultsCollector, DomainResultCreationState creationState) {
        SqlExpressableType sqlExpressableType = IntegerSqlDescriptor.INSTANCE.getSqlExpressableType((BasicJavaDescriptor)IntegerJavaDescriptor.INSTANCE, creationState.getSqlAstCreationState().getCreationContext().getDomainModel().getTypeConfiguration());
        SqlSelectionImpl sqlSelection = new SqlSelectionImpl(1, 0, (Expression)new QueryLiteral(1, sqlExpressableType, Clause.SELECT), sqlExpressableType);
        selectClause.addSqlSelection(sqlSelection);
        domainResultsCollector.accept(new BasicResultImpl(null, sqlSelection, sqlExpressableType));
    }

    @Override
    protected void applyPredicates(Junction junction, TableGroup tableGroup, BiConsumer<Column, JdbcParameter> columnCollector, SqlAstCreationState creationState) {
        this.applyPredicates(junction, this.getCollectionDescriptor().getCollectionKeyDescriptor(), tableGroup, columnCollector, creationState);
        this.applyPredicates(junction, this.getCollectionDescriptor().getElementDescriptor(), tableGroup, columnCollector, creationState);
    }
}

