/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.collection;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.boot.model.domain.spi.EmbeddedValueMappingImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.spi.AbstractCollectionIndex;
import org.hibernate.metamodel.model.domain.spi.CollectionIndexEmbedded;
import org.hibernate.metamodel.model.domain.spi.EmbeddedTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.NavigableVisitationStrategy;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.domain.spi.SimpleTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.SingularPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.TableReferenceJoinCollector;
import org.hibernate.metamodel.model.domain.spi.Writeable;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.JoinType;
import org.hibernate.sql.ast.produce.metamodel.spi.Fetchable;
import org.hibernate.sql.ast.produce.spi.ColumnReferenceQualifier;
import org.hibernate.sql.ast.produce.spi.SqlAliasBase;
import org.hibernate.sql.ast.produce.spi.TableReferenceContributor;
import org.hibernate.type.descriptor.java.spi.EmbeddableJavaDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class CollectionIndexEmbeddedImpl<J>
extends AbstractCollectionIndex<J>
implements CollectionIndexEmbedded<J> {
    private final EmbeddedTypeDescriptor<J> embeddedDescriptor;

    public CollectionIndexEmbeddedImpl(PersistentCollectionDescriptor descriptor, IndexedCollection bootCollectionMapping, RuntimeModelCreationContext creationContext) {
        super(descriptor, bootCollectionMapping);
        this.embeddedDescriptor = creationContext.getRuntimeModelDescriptorFactory().createEmbeddedTypeDescriptor((EmbeddedValueMappingImplementor)((Object)bootCollectionMapping.getIndex()), descriptor, null, "{index}", SingularPersistentAttribute.Disposition.NORMAL, creationContext);
    }

    @Override
    public EmbeddedTypeDescriptor<J> getEmbeddedDescriptor() {
        return this.embeddedDescriptor;
    }

    @Override
    public <N> Navigable<N> findNavigable(String navigableName) {
        return this.getEmbeddedDescriptor().findNavigable(navigableName);
    }

    @Override
    public void visitNavigables(NavigableVisitationStrategy visitor) {
        this.getEmbeddedDescriptor().visitNavigables(visitor);
    }

    @Override
    public EmbeddableJavaDescriptor<J> getJavaTypeDescriptor() {
        return this.getEmbeddedDescriptor().getJavaTypeDescriptor();
    }

    @Override
    public SimpleTypeDescriptor<?> getDomainTypeDescriptor() {
        return this.getEmbeddedDescriptor();
    }

    @Override
    public List<Column> getColumns() {
        return this.getEmbeddedDescriptor().collectColumns();
    }

    @Override
    public void visitFetchables(Consumer<Fetchable> fetchableConsumer) {
        this.getEmbeddedDescriptor().visitFetchables(fetchableConsumer);
    }

    @Override
    public void applyTableReferenceJoins(ColumnReferenceQualifier lhs, JoinType joinType, SqlAliasBase sqlAliasBase, TableReferenceJoinCollector joinCollector) {
        this.getEmbeddedDescriptor().visitStateArrayContributors(contributor -> {
            if (contributor instanceof TableReferenceContributor) {
                ((TableReferenceContributor)((Object)contributor)).applyTableReferenceJoins(lhs, joinType, sqlAliasBase, joinCollector);
            }
        });
    }

    @Override
    public void visitColumns(BiConsumer<SqlExpressableType, Column> action, Clause clause, TypeConfiguration typeConfiguration) {
        this.getEmbeddedDescriptor().visitStateArrayContributors(contributor -> contributor.visitColumns(action, clause, typeConfiguration));
    }

    @Override
    public Object unresolve(Object value, SharedSessionContractImplementor session) {
        Object[] values = this.getEmbeddedDescriptor().getPropertyValues(value);
        this.getEmbeddedDescriptor().visitStateArrayContributors(contributor -> {
            int index = contributor.getStateArrayPosition();
            values[index] = contributor.unresolve(values[index], session);
        });
        return values;
    }

    @Override
    public void dehydrate(Object value, Writeable.JdbcValueCollector jdbcValueCollector, Clause clause, SharedSessionContractImplementor session) {
        assert (value instanceof Object[]);
        Object[] subValues = (Object[])value;
        this.getEmbeddedDescriptor().visitStateArrayContributors(stateArrayContributor -> {
            Object subValue = subValues[stateArrayContributor.getStateArrayPosition()];
            stateArrayContributor.dehydrate(subValue, jdbcValueCollector, clause, session);
        });
    }

    @Override
    public boolean hasNotNullColumns() {
        return this.getEmbeddedDescriptor().visitAndCollectStateArrayContributors(contributor -> !contributor.isNullable()).stream().anyMatch(value -> value == true);
    }
}

