/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.collection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.HibernateException;
import org.hibernate.boot.model.relational.MappedColumn;
import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.model.creation.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.model.domain.spi.AbstractCollectionIndex;
import org.hibernate.metamodel.model.domain.spi.CollectionIndex;
import org.hibernate.metamodel.model.domain.spi.CollectionIndexEntity;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.NavigableVisitationStrategy;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.domain.spi.SimpleTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.TableReferenceJoinCollector;
import org.hibernate.metamodel.model.domain.spi.Writeable;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.ForeignKey;
import org.hibernate.query.spi.ComparisonOperator;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.JoinType;
import org.hibernate.sql.ast.produce.metamodel.spi.Fetchable;
import org.hibernate.sql.ast.produce.spi.ColumnReferenceQualifier;
import org.hibernate.sql.ast.produce.spi.SqlAliasBase;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.type.descriptor.java.spi.EntityJavaDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class CollectionIndexEntityImpl<J>
extends AbstractCollectionIndex<J>
implements CollectionIndexEntity<J> {
    private final EntityTypeDescriptor<J> entityDescriptor;
    private final NavigableRole navigableRole;
    private final List<Column> columns;

    public CollectionIndexEntityImpl(PersistentCollectionDescriptor descriptor, IndexedCollection bootCollectionMapping, RuntimeModelCreationContext creationContext) {
        super(descriptor, bootCollectionMapping);
        this.entityDescriptor = this.resolveEntityDescriptor(bootCollectionMapping, creationContext);
        this.navigableRole = descriptor.getNavigableRole().append("{index}");
        this.columns = CollectionIndexEntityImpl.resolveIndexColumns(bootCollectionMapping, creationContext);
    }

    @Override
    public EntityTypeDescriptor<J> getEntityDescriptor() {
        return this.entityDescriptor;
    }

    @Override
    public String getEntityName() {
        return this.getEntityDescriptor().getEntityName();
    }

    @Override
    public String getJpaEntityName() {
        return this.getEntityDescriptor().getJpaEntityName();
    }

    @Override
    public SimpleTypeDescriptor<?> getDomainTypeDescriptor() {
        return this.getEntityDescriptor();
    }

    @Override
    public CollectionIndex.IndexClassification getClassification() {
        return CollectionIndex.IndexClassification.ONE_TO_MANY;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public <N> Navigable<N> findNavigable(String navigableName) {
        return this.getEntityDescriptor().findNavigable(navigableName);
    }

    @Override
    public void visitNavigables(NavigableVisitationStrategy visitor) {
        this.getEntityDescriptor().visitNavigables(visitor);
    }

    @Override
    public List<Column> getColumns() {
        return this.columns;
    }

    @Override
    public EntityJavaDescriptor<J> getJavaTypeDescriptor() {
        return this.getEntityDescriptor().getJavaTypeDescriptor();
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public void applyTableReferenceJoins(ColumnReferenceQualifier lhs, JoinType joinType, SqlAliasBase sqlAliasBase, TableReferenceJoinCollector joinCollector) {
        if (joinCollector.getPrimaryTableReference() != null) {
            TableReference joinedTableReference = new TableReference(this.getEntityDescriptor().getPrimaryTable(), sqlAliasBase.generateNewAlias(), false);
            joinCollector.addSecondaryReference(new TableReferenceJoin(joinType, joinedTableReference, this.makePredicate(joinCollector.getPrimaryTableReference(), joinedTableReference)));
            lhs = joinedTableReference;
        } else {
            joinCollector.addPrimaryReference(new TableReference(this.getEntityDescriptor().getPrimaryTable(), sqlAliasBase.generateNewAlias(), false));
            lhs = joinCollector.getPrimaryTableReference();
        }
        this.getEntityDescriptor().applyTableReferenceJoins(lhs, joinType, sqlAliasBase, joinCollector);
    }

    private Predicate makePredicate(ColumnReferenceQualifier lhs, TableReference rhs) {
        Junction conjunction = new Junction(Junction.Nature.CONJUNCTION);
        for (ForeignKey foreignKey : this.getContainer().getCollectionKeyDescriptor().getJoinForeignKey().getReferringTable().getForeignKeys()) {
            if (!foreignKey.getTargetTable().equals(rhs.getTable())) continue;
            for (ForeignKey.ColumnMappings.ColumnMapping columnMapping : foreignKey.getColumnMappings().getColumnMappings()) {
                ColumnReference referringColumnReference = lhs.resolveColumnReference(columnMapping.getReferringColumn());
                ColumnReference targetColumnReference = rhs.resolveColumnReference(columnMapping.getTargetColumn());
                conjunction.add(new ComparisonPredicate(referringColumnReference, ComparisonOperator.EQUAL, targetColumnReference));
            }
        }
        return conjunction;
    }

    @Override
    public void visitFetchables(Consumer<Fetchable> fetchableConsumer) {
        this.getEntityDescriptor().visitFetchables(fetchableConsumer);
    }

    @Override
    public boolean hasNotNullColumns() {
        return this.getEntityDescriptor().visitAndCollectStateArrayContributors(contributor -> !contributor.isNullable()).stream().anyMatch(value -> value == true);
    }

    @Override
    public J replace(J originalValue, J targetValue, Object owner, Map copyCache, SessionImplementor session) {
        return (J)this.getJavaTypeDescriptor().getMutabilityPlan().replace(this.getEntityDescriptor(), originalValue, targetValue, owner, copyCache, session);
    }

    private EntityTypeDescriptor<J> resolveEntityDescriptor(IndexedCollection collection, RuntimeModelCreationContext creationContext) {
        String indexEntityName;
        Value indexValueMapping = collection.getIndex();
        if (indexValueMapping instanceof OneToMany) {
            indexEntityName = ((OneToMany)indexValueMapping).getReferencedEntityName();
        } else if (indexValueMapping instanceof ManyToOne) {
            indexEntityName = ((ManyToOne)indexValueMapping).getReferencedEntityName();
        } else {
            throw new HibernateException(String.format(Locale.ROOT, "Failed to resolve entity descriptor for collection index [%s]", collection.getRole()));
        }
        return creationContext.getInFlightRuntimeModel().findEntityDescriptor(indexEntityName);
    }

    @Override
    public Object unresolve(Object value, SharedSessionContractImplementor session) {
        return ForeignKeys.getEntityIdentifierIfNotUnsaved(this.getEntityName(), value, session);
    }

    @Override
    public void dehydrate(Object value, Writeable.JdbcValueCollector jdbcValueCollector, Clause clause, SharedSessionContractImplementor session) {
        for (Column column : this.columns) {
            jdbcValueCollector.collect(value, column.getExpressableType(), column);
        }
    }

    @Override
    public void visitColumns(BiConsumer<SqlExpressableType, Column> action, Clause clause, TypeConfiguration typeConfiguration) {
        for (Column column : this.columns) {
            action.accept(column.getExpressableType(), column);
        }
    }

    private static List<Column> resolveIndexColumns(IndexedCollection bootCollectionMapping, RuntimeModelCreationContext creationContext) {
        ArrayList<Column> columns = new ArrayList<Column>();
        Iterator<MappedColumn> iterator = bootCollectionMapping.getIndex().getMappedColumns().iterator();
        while (iterator.hasNext()) {
            MappedColumn indexColumn;
            MappedColumn mappedColumn = indexColumn = iterator.next();
            columns.add(creationContext.getDatabaseObjectResolver().resolveColumn(mappedColumn));
        }
        return columns;
    }
}

