/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.collection;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.collection.spi.CollectionClassification;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.internal.collection.AbstractSelector;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.produce.spi.SqlAstCreationState;
import org.hibernate.sql.ast.tree.expression.CountFunction;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.MaxFunction;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.JdbcParameter;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.sql.results.internal.domain.basic.BasicResultImpl;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.type.descriptor.java.internal.IntegerJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.sql.spi.IntegerSqlDescriptor;

public class CollectionSizeSelector
extends AbstractSelector {
    public CollectionSizeSelector(PersistentCollectionDescriptor collectionDescriptor, Table table, String sqlWhereString, SessionFactoryImplementor sessionFactory) {
        super(collectionDescriptor, table, sqlWhereString, sessionFactory);
    }

    public int execute(Object key, SharedSessionContractImplementor session) {
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl();
        this.bindCollectionKey(key, jdbcParameterBindings, session);
        List results = this.execute(jdbcParameterBindings, session);
        if (results.size() != 1) {
            return 0;
        }
        Object result = results.get(0);
        if (result == null) {
            return 0;
        }
        if (this.isIntegerIndexed()) {
            return (Integer)result + 1;
        }
        return (Integer)result;
    }

    @Override
    protected void applySqlSelections(QuerySpec querySpec, TableGroup tableGroup, SelectClause selectClause, Consumer<DomainResult> domainResultsCollector, DomainResultCreationState creationState) {
        if (this.isIntegerIndexed()) {
            List<Column> indexColumns = this.getCollectionDescriptor().getIndexDescriptor().getColumns();
            Column column = indexColumns.get(0);
            Expression columnExpression = tableGroup.qualify(column);
            MaxFunction maxExpression = new MaxFunction(columnExpression, false, column.getExpressableType());
            SqlSelectionImpl sqlSelection = new SqlSelectionImpl(1, 0, (Expression)maxExpression, column.getExpressableType().getJdbcValueExtractor());
            selectClause.addSqlSelection(sqlSelection);
            domainResultsCollector.accept(new BasicResultImpl(null, sqlSelection, indexColumns.get(0).getExpressableType()));
        } else {
            SqlExpressableType sqlExpressableType = IntegerSqlDescriptor.INSTANCE.getSqlExpressableType((BasicJavaDescriptor)IntegerJavaDescriptor.INSTANCE, creationState.getSqlAstCreationState().getCreationContext().getDomainModel().getTypeConfiguration());
            CountFunction countExpression = new CountFunction(new QueryLiteral(1, sqlExpressableType, Clause.SELECT), false, sqlExpressableType);
            SqlSelectionImpl sqlSelection = new SqlSelectionImpl(1, 0, (Expression)countExpression, sqlExpressableType.getJdbcValueExtractor());
            selectClause.addSqlSelection(sqlSelection);
            domainResultsCollector.accept(new BasicResultImpl(null, sqlSelection, sqlExpressableType));
        }
    }

    @Override
    protected void applyPredicates(Junction junction, TableGroup tableGroup, BiConsumer<Column, JdbcParameter> columnCollector, SqlAstCreationState creationState) {
        this.applyPredicates(junction, this.getCollectionDescriptor().getCollectionKeyDescriptor(), tableGroup, columnCollector, creationState);
    }

    private boolean isIntegerIndexed() {
        return this.getCollectionDescriptor().getIndexDescriptor() != null && this.getCollectionDescriptor().getCollectionClassification() != CollectionClassification.MAP;
    }
}

