/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.collection;

import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.metamodel.model.domain.spi.AbstractTableReferenceCollector;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.relational.spi.ForeignKey;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.spi.ComparisonOperator;
import org.hibernate.sql.ast.JoinType;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.StandardTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.type.ForeignKeyDirection;

public class FetchedTableReferenceCollectorImpl
extends AbstractTableReferenceCollector {
    private final NavigablePath navigablePath;
    private final PersistentCollectionDescriptor collectionDescriptor;
    private final TableGroup lhs;
    private final String explicitSourceAlias;
    private final LockMode lockMode;

    public FetchedTableReferenceCollectorImpl(NavigablePath navigablePath, PersistentCollectionDescriptor collectionDescriptor, TableGroup lhs, String explicitSourceAlias, LockMode lockMode) {
        this.navigablePath = navigablePath;
        this.collectionDescriptor = collectionDescriptor;
        this.lhs = lhs;
        this.explicitSourceAlias = explicitSourceAlias;
        this.lockMode = lockMode;
    }

    @Override
    public void addPrimaryReference(TableReference primaryReference) {
        super.addPrimaryReference(primaryReference);
    }

    @Override
    public void addSecondaryReference(TableReferenceJoin secondaryReference) {
        super.addSecondaryReference(secondaryReference);
    }

    public TableGroupJoin generateTableGroup(JoinType joinType) {
        StandardTableGroup joinedTableGroup = new StandardTableGroup(this.navigablePath, this.collectionDescriptor, this.lockMode, this.getPrimaryTableReference(), this.getTableReferenceJoins(), this.lhs);
        Predicate joinPredicate = this.makePredicate(this.lhs, joinedTableGroup);
        return new TableGroupJoin(joinType, joinedTableGroup, joinPredicate);
    }

    private Predicate makePredicate(TableGroup lhs, TableGroup rhs) {
        Junction conjunction = new Junction(Junction.Nature.CONJUNCTION);
        ForeignKey joinForeignKey = this.collectionDescriptor.getCollectionKeyDescriptor().getJoinForeignKey();
        ForeignKeyDirection keyDirection = this.collectionDescriptor.getForeignKeyDirection();
        List<ForeignKey.ColumnMappings.ColumnMapping> columnMappings = joinForeignKey.getColumnMappings().getColumnMappings();
        for (ForeignKey.ColumnMappings.ColumnMapping columnMapping : columnMappings) {
            ColumnReference keyCollectionColumnReference;
            ColumnReference keyContainerColumnReference;
            if (keyDirection == ForeignKeyDirection.TO_PARENT) {
                keyContainerColumnReference = lhs.resolveColumnReference(columnMapping.getTargetColumn());
                keyCollectionColumnReference = rhs.resolveColumnReference(columnMapping.getReferringColumn());
            } else {
                keyContainerColumnReference = lhs.resolveColumnReference(columnMapping.getReferringColumn());
                keyCollectionColumnReference = rhs.resolveColumnReference(columnMapping.getTargetColumn());
            }
            conjunction.add(new ComparisonPredicate(keyContainerColumnReference, ComparisonOperator.EQUAL, keyCollectionColumnReference));
        }
        return conjunction;
    }
}

