/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.collection;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.CollectionDomainType;
import org.hibernate.metamodel.model.domain.internal.collection.AbstractSelector;
import org.hibernate.metamodel.model.domain.internal.collection.CollectionRowByIndexSelector;
import org.hibernate.metamodel.model.domain.internal.collection.SqlAstCreationStateImpl;
import org.hibernate.metamodel.model.domain.spi.NavigableContainer;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.produce.metamodel.spi.Fetchable;
import org.hibernate.sql.ast.produce.spi.QualifiableSqlExpressable;
import org.hibernate.sql.ast.produce.spi.SqlAstCreationState;
import org.hibernate.sql.ast.produce.spi.SqlSelectionExpression;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.JdbcParameter;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.FetchParent;

public class JoinTableCollectionRowByIndexSelector
extends AbstractSelector
implements CollectionRowByIndexSelector {
    public <E, O, C> JoinTableCollectionRowByIndexSelector(PersistentCollectionDescriptor collectionDescriptor, Table table, String sqlWhereString, SessionFactoryImplementor sessionFactory) {
        super(collectionDescriptor, table, sqlWhereString, sessionFactory);
    }

    @Override
    public Object execute(Object key, Object index, SharedSessionContractImplementor session) {
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl();
        this.bindCollectionKey(key, jdbcParameterBindings, session);
        this.bindCollectionIndex(index, jdbcParameterBindings, session);
        List results = this.execute(jdbcParameterBindings, session);
        if (results.isEmpty()) {
            return null;
        }
        return results.get(0);
    }

    @Override
    protected void applySqlSelections(QuerySpec querySpec, TableGroup tableGroup, SelectClause selectClause, Consumer<DomainResult> domainResultsCollector, DomainResultCreationState creationState) {
        CollectionDomainType.Element elementDescriptor = this.getCollectionDescriptor().getElementDescriptor();
        NavigablePath collectionNavigablePath = tableGroup.getNavigablePath();
        DomainResult domainResult = elementDescriptor.createDomainResult(collectionNavigablePath.append("{element}"), null, creationState);
        Position position = new Position();
        elementDescriptor.visitColumns((sqlExpressableType, column) -> {
            Expression expression = tableGroup.qualify((QualifiableSqlExpressable)column);
            ColumnReference columnReference = !ColumnReference.class.isInstance(expression) ? (ColumnReference)((SqlSelectionExpression)expression).getExpression() : (ColumnReference)expression;
            SqlSelectionImpl sqlSelection = new SqlSelectionImpl(position.getJdbcPosition(), position.getValuesArrayPosition(), (Expression)columnReference, sqlExpressableType.getJdbcValueExtractor());
            position.increase();
            selectClause.addSqlSelection(sqlSelection);
        }, Clause.SELECT, creationState.getSqlAstCreationState().getCreationContext().getDomainModel().getTypeConfiguration());
        domainResultsCollector.accept(domainResult);
    }

    @Override
    protected SqlAstCreationStateImpl getCreationState(SessionFactoryImplementor sessionFactory, QuerySpec querySpec) {
        return new IndexSqlAstCreationStateImpl(sessionFactory, querySpec);
    }

    @Override
    protected void applyPredicates(Junction junction, TableGroup tableGroup, BiConsumer<Column, JdbcParameter> columnCollector, SqlAstCreationState creationState) {
        this.applyPredicates(junction, this.getCollectionDescriptor().getCollectionKeyDescriptor(), tableGroup, columnCollector, creationState);
        this.applyPredicates(junction, this.getCollectionDescriptor().getIndexDescriptor(), tableGroup, columnCollector, creationState);
    }

    public class IndexSqlAstCreationStateImpl
    extends SqlAstCreationStateImpl {
        public IndexSqlAstCreationStateImpl(SessionFactoryImplementor sessionFactory, QuerySpec querySpec) {
            super(sessionFactory, querySpec);
        }

        @Override
        public List<Fetch> visitFetches(FetchParent fetchParent) {
            ArrayList<Fetch> fetches = new ArrayList<Fetch>();
            Consumer<Fetchable> fetchableConsumer = fetchable -> {
                if (fetchParent.findFetch(fetchable.getNavigableName()) != null) {
                    return;
                }
                fetches.add(fetchable.generateFetch(fetchParent, FetchTiming.IMMEDIATE, true, LockMode.NONE, null, this));
            };
            NavigableContainer navigableContainer = (NavigableContainer)((Object)JoinTableCollectionRowByIndexSelector.this.getCollectionDescriptor().getElementDescriptor());
            navigableContainer.visitKeyFetchables(fetchableConsumer);
            navigableContainer.visitFetchables(fetchableConsumer);
            return fetches;
        }
    }

    public class Position {
        int jdbcPosition = 1;
        int valuesArrayPosition = 0;

        public void increase() {
            ++this.jdbcPosition;
            ++this.valuesArrayPosition;
        }

        public int getJdbcPosition() {
            return this.jdbcPosition;
        }

        public int getValuesArrayPosition() {
            return this.valuesArrayPosition;
        }
    }
}

