/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.collection;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.model.domain.internal.collection.AbstractCreationExecutor;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.consume.spi.InsertToJdbcInsertConverter;
import org.hibernate.sql.ast.tree.expression.PositionalParameter;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.insert.InsertStatement;
import org.hibernate.sql.exec.spi.JdbcMutation;
import org.hibernate.sql.exec.spi.JdbcParameter;

public class JoinTableCreationExecutor
extends AbstractCreationExecutor {
    public JoinTableCreationExecutor(PersistentCollectionDescriptor collectionDescriptor, Table dmlTargetTable, SessionFactoryImplementor sessionFactory) {
        super(collectionDescriptor, dmlTargetTable, sessionFactory);
    }

    @Override
    protected JdbcMutation generateCreationOperation(TableReference dmlTableRef, SessionFactoryImplementor sessionFactory, BiConsumer<Column, JdbcParameter> columnConsumer) {
        InsertStatement insertStatement = new InsertStatement(dmlTableRef);
        AtomicInteger parameterCount = new AtomicInteger();
        this.applyNavigable(this.getCollectionDescriptor().getCollectionKeyDescriptor(), insertStatement, parameterCount, columnConsumer, sessionFactory);
        if (this.getCollectionDescriptor().getIdDescriptor() != null) {
            this.applyNavigable(this.getCollectionDescriptor().getIdDescriptor(), insertStatement, parameterCount, columnConsumer, sessionFactory);
        }
        if (this.getCollectionDescriptor().getIndexDescriptor() != null) {
            this.applyNavigable(this.getCollectionDescriptor().getIndexDescriptor(), insertStatement, parameterCount, columnConsumer, sessionFactory);
        }
        this.applyNavigable((Navigable)((Object)this.getCollectionDescriptor().getElementDescriptor()), insertStatement, parameterCount, columnConsumer, sessionFactory);
        return InsertToJdbcInsertConverter.createJdbcInsert(insertStatement, sessionFactory);
    }

    protected void applyNavigable(Navigable navigable, InsertStatement insertStatement, AtomicInteger parameterCount, BiConsumer<Column, JdbcParameter> columnConsumer, SessionFactoryImplementor sessionFactory) {
        navigable.visitColumns((sqlExpressableType, column) -> {
            if (column.isInsertable()) {
                insertStatement.addTargetColumnReference(insertStatement.getTargetTable().resolveColumnReference((Column)column));
                PositionalParameter parameter = new PositionalParameter(parameterCount.getAndIncrement(), column.getExpressableType(), Clause.INSERT, sessionFactory.getTypeConfiguration());
                insertStatement.addValue(parameter);
                columnConsumer.accept((Column)column, parameter);
            }
        }, Clause.INSERT, sessionFactory.getTypeConfiguration());
    }
}

