/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.collection;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.internal.collection.CollectionRemovalExecutor;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.query.spi.ComparisonOperator;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.consume.spi.SqlDeleteToJdbcDeleteConverter;
import org.hibernate.sql.ast.produce.spi.QualifiableSqlExpressable;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.LiteralParameter;
import org.hibernate.sql.ast.tree.expression.PositionalParameter;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.BasicExecutionContext;
import org.hibernate.sql.exec.spi.JdbcDelete;
import org.hibernate.sql.exec.spi.JdbcMutationExecutor;
import org.hibernate.sql.exec.spi.JdbcParameter;

public class JoinTableRemovalExecutor
implements CollectionRemovalExecutor {
    private final PersistentCollectionDescriptor collectionDescriptor;
    private final SessionFactoryImplementor sessionFactory;
    private final Map<Column, JdbcParameter> jdbcParameterMap;
    private final JdbcDelete removalOperation;

    public JoinTableRemovalExecutor(PersistentCollectionDescriptor collectionDescriptor, SessionFactoryImplementor sessionFactory) {
        this.collectionDescriptor = collectionDescriptor;
        this.sessionFactory = sessionFactory;
        TableReference collectionTableRef = new TableReference(collectionDescriptor.getSeparateCollectionTable(), null, false);
        this.jdbcParameterMap = new HashMap<Column, JdbcParameter>();
        DeleteStatement deleteStatement = this.generateDeleteStatement(collectionTableRef, this.jdbcParameterMap::put, collectionDescriptor, sessionFactory);
        this.removalOperation = SqlDeleteToJdbcDeleteConverter.interpret(deleteStatement, sessionFactory);
    }

    private DeleteStatement generateDeleteStatement(TableReference collectionTableRef, BiConsumer<Column, JdbcParameter> parameterCollector, PersistentCollectionDescriptor collectionDescriptor, SessionFactoryImplementor sessionFactory) {
        AtomicInteger parameterCount = new AtomicInteger();
        Junction deleteRestriction = new Junction(Junction.Nature.CONJUNCTION);
        collectionDescriptor.getCollectionKeyDescriptor().visitColumns((jdbcType, column) -> {
            PositionalParameter parameter = new PositionalParameter(parameterCount.getAndIncrement(), column.getExpressableType(), Clause.INSERT, sessionFactory.getTypeConfiguration());
            parameterCollector.accept((Column)column, parameter);
            deleteRestriction.add(new ComparisonPredicate(collectionTableRef.qualify((QualifiableSqlExpressable)column), ComparisonOperator.EQUAL, parameter));
        }, Clause.DELETE, sessionFactory.getTypeConfiguration());
        return new DeleteStatement(collectionTableRef, deleteRestriction);
    }

    @Override
    public void execute(Object key, SharedSessionContractImplementor session) {
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl();
        BasicExecutionContext executionContext = new BasicExecutionContext(session);
        this.collectionDescriptor.getCollectionKeyDescriptor().dehydrate(this.collectionDescriptor.getCollectionKeyDescriptor().unresolve(key, session), (jdbcValue, type, boundColumn) -> this.createBinding(jdbcValue, boundColumn, type, jdbcParameterBindings, session), Clause.INSERT, session);
        JdbcMutationExecutor.WITH_AFTER_STATEMENT_CALL.execute(this.removalOperation, jdbcParameterBindings, executionContext);
    }

    protected void createBinding(Object jdbcValue, Column boundColumn, SqlExpressableType type, JdbcParameterBindingsImpl jdbcParameterBindings, SharedSessionContractImplementor session) {
        JdbcParameter jdbcParameter = this.resolveJdbcParameter(boundColumn);
        jdbcParameterBindings.addBinding(jdbcParameter, new LiteralParameter(jdbcValue, type, Clause.INSERT, session.getFactory().getTypeConfiguration()));
    }

    private JdbcParameter resolveJdbcParameter(Column boundColumn) {
        JdbcParameter jdbcParameter = this.jdbcParameterMap.get(boundColumn);
        if (jdbcParameter == null) {
            throw new IllegalStateException("JdbcParameter not found for Column [" + boundColumn + "]");
        }
        return jdbcParameter;
    }
}

