/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.collection;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.internal.collection.CollectionRowsDeletionExecutor;
import org.hibernate.metamodel.model.domain.spi.CollectionIndex;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.query.spi.ComparisonOperator;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.consume.spi.SqlDeleteToJdbcDeleteConverter;
import org.hibernate.sql.ast.produce.spi.QualifiableSqlExpressable;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.LiteralParameter;
import org.hibernate.sql.ast.tree.expression.PositionalParameter;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.internal.LoadParameterBindingContext;
import org.hibernate.sql.exec.spi.BasicExecutionContext;
import org.hibernate.sql.exec.spi.JdbcDelete;
import org.hibernate.sql.exec.spi.JdbcMutationExecutor;
import org.hibernate.sql.exec.spi.JdbcParameter;
import org.jboss.logging.Logger;

public class JoinTableRowsDeleletionExecutor
implements CollectionRowsDeletionExecutor {
    private static final Logger log = Logger.getLogger(JoinTableRowsDeleletionExecutor.class);
    private final PersistentCollectionDescriptor collectionDescriptor;
    private boolean deleteByIndex;
    private Map<Column, JdbcParameter> jdbcParameterMap;
    private final JdbcDelete removalOperation;

    public JoinTableRowsDeleletionExecutor(PersistentCollectionDescriptor collectionDescriptor, SessionFactoryImplementor sessionFactory, boolean deleteByIndex) {
        this.collectionDescriptor = collectionDescriptor;
        this.deleteByIndex = deleteByIndex;
        TableReference collectionTableRef = new TableReference(collectionDescriptor.getSeparateCollectionTable(), null, false);
        HashMap<Column, JdbcParameter> jdbcParameterMap = new HashMap<Column, JdbcParameter>();
        DeleteStatement deleteStatement = this.generateDeleteStatement(collectionTableRef, jdbcParameterMap::put, sessionFactory);
        this.jdbcParameterMap = jdbcParameterMap;
        this.removalOperation = SqlDeleteToJdbcDeleteConverter.interpret(deleteStatement, sessionFactory);
    }

    private DeleteStatement generateDeleteStatement(TableReference collectionTableRef, BiConsumer<Column, JdbcParameter> parameterCollector, SessionFactoryImplementor sessionFactory) {
        AtomicInteger parameterCount = new AtomicInteger();
        Junction deleteRestriction = new Junction(Junction.Nature.CONJUNCTION);
        if (this.collectionDescriptor.getIdDescriptor() != null) {
            this.collectionDescriptor.getIdDescriptor().visitColumns((jdbcType, column) -> {
                PositionalParameter parameter = new PositionalParameter(parameterCount.getAndIncrement(), column.getExpressableType(), Clause.DELETE, sessionFactory.getTypeConfiguration());
                parameterCollector.accept((Column)column, parameter);
                deleteRestriction.add(new ComparisonPredicate(collectionTableRef.qualify((QualifiableSqlExpressable)column), ComparisonOperator.EQUAL, parameter));
            }, Clause.DELETE, sessionFactory.getTypeConfiguration());
        } else {
            this.collectionDescriptor.getCollectionKeyDescriptor().visitColumns((jdbcType, column) -> {
                PositionalParameter parameter = new PositionalParameter(parameterCount.getAndIncrement(), column.getExpressableType(), Clause.DELETE, sessionFactory.getTypeConfiguration());
                parameterCollector.accept((Column)column, parameter);
                deleteRestriction.add(new ComparisonPredicate(collectionTableRef.qualify((QualifiableSqlExpressable)column), ComparisonOperator.EQUAL, parameter));
            }, Clause.DELETE, sessionFactory.getTypeConfiguration());
            if (this.deleteByIndex) {
                this.collectionDescriptor.getIndexDescriptor().visitColumns((jdbcType, column) -> {
                    PositionalParameter parameter = new PositionalParameter(parameterCount.getAndIncrement(), column.getExpressableType(), Clause.DELETE, sessionFactory.getTypeConfiguration());
                    parameterCollector.accept((Column)column, parameter);
                    deleteRestriction.add(new ComparisonPredicate(collectionTableRef.qualify((QualifiableSqlExpressable)column), ComparisonOperator.EQUAL, parameter));
                }, Clause.DELETE, sessionFactory.getTypeConfiguration());
            } else {
                this.collectionDescriptor.getElementDescriptor().visitColumns((jdbcType, column) -> {
                    PositionalParameter parameter = new PositionalParameter(parameterCount.getAndIncrement(), column.getExpressableType(), Clause.DELETE, sessionFactory.getTypeConfiguration());
                    parameterCollector.accept((Column)column, parameter);
                    deleteRestriction.add(new ComparisonPredicate(collectionTableRef.qualify((QualifiableSqlExpressable)column), ComparisonOperator.EQUAL, parameter));
                }, Clause.DELETE, sessionFactory.getTypeConfiguration());
            }
        }
        return new DeleteStatement(collectionTableRef, deleteRestriction);
    }

    @Override
    public void execute(PersistentCollection collection, Object key, SharedSessionContractImplementor session) {
        Iterator deletes = collection.getDeletes(this.collectionDescriptor, !this.deleteByIndex);
        if (log.isDebugEnabled()) {
            log.debugf("Deleting rows of collection: %s", (Object)MessageHelper.collectionInfoString(this.collectionDescriptor, collection, key, session));
        }
        if (deletes.hasNext()) {
            int passes = 0;
            JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl();
            BasicExecutionContext executionContext = new BasicExecutionContext(session, new LoadParameterBindingContext((SessionFactoryImplementor)session.getSessionFactory(), key));
            while (deletes.hasNext()) {
                Object entry = deletes.next();
                if (this.collectionDescriptor.getIdDescriptor() != null) {
                    this.bindCollectionId(entry, passes, collection, jdbcParameterBindings, session);
                } else {
                    this.bindCollectionKey(key, jdbcParameterBindings, session);
                    if (this.deleteByIndex) {
                        this.bindCollectionIndex(entry, jdbcParameterBindings, session);
                    } else {
                        this.bindCollectionElement(entry, collection, jdbcParameterBindings, session);
                    }
                }
                JdbcMutationExecutor.WITH_AFTER_STATEMENT_CALL.execute(this.removalOperation, jdbcParameterBindings, executionContext);
                jdbcParameterBindings.clear();
                log.debugf("Done deleting collection rows: %s deleted", ++passes);
            }
        } else {
            log.debug((Object)"No rows to delete");
        }
    }

    protected void bindCollectionElement(Object entry, PersistentCollection collection, JdbcParameterBindingsImpl jdbcParameterBindings, SharedSessionContractImplementor session) {
        this.collectionDescriptor.getElementDescriptor().dehydrate(this.collectionDescriptor.getElementDescriptor().unresolve(collection.getElement(entry, this.collectionDescriptor), session), (jdbcValue, type, boundColumn) -> this.createBinding(jdbcValue, boundColumn, type, jdbcParameterBindings, session), Clause.DELETE, session);
    }

    protected void bindCollectionIndex(Object index, JdbcParameterBindingsImpl jdbcParameterBindings, SharedSessionContractImplementor session) {
        CollectionIndex indexDescriptor = this.collectionDescriptor.getIndexDescriptor();
        if (indexDescriptor != null) {
            if (indexDescriptor.getBaseIndex() != 0) {
                index = (Integer)index + indexDescriptor.getBaseIndex();
            }
            indexDescriptor.dehydrate(indexDescriptor.unresolve(index, session), (jdbcValue, type, boundColumn) -> this.createBinding(jdbcValue, boundColumn, type, jdbcParameterBindings, session), Clause.DELETE, session);
        }
    }

    protected void bindCollectionKey(Object key, JdbcParameterBindingsImpl jdbcParameterBindings, SharedSessionContractImplementor session) {
        this.collectionDescriptor.getCollectionKeyDescriptor().dehydrate(this.collectionDescriptor.getCollectionKeyDescriptor().unresolve(key, session), (jdbcValue, type, boundColumn) -> this.createBinding(jdbcValue, boundColumn, type, jdbcParameterBindings, session), Clause.DELETE, session);
    }

    protected void bindCollectionId(Object entry, int assumedIdentifier, PersistentCollection collection, JdbcParameterBindingsImpl jdbcParameterBindings, SharedSessionContractImplementor session) {
        Object identifier = collection.getIdentifier(entry, assumedIdentifier, this.collectionDescriptor);
        this.collectionDescriptor.getIdDescriptor().dehydrate(this.collectionDescriptor.getIdDescriptor().unresolve(identifier, session), (jdbcValue, type, boundColumn) -> this.createBinding(jdbcValue, boundColumn, type, jdbcParameterBindings, session), Clause.DELETE, session);
    }

    protected void createBinding(Object jdbcValue, Column boundColumn, SqlExpressableType type, JdbcParameterBindingsImpl jdbcParameterBindings, SharedSessionContractImplementor session) {
        JdbcParameter jdbcParameter = this.resolveJdbcParameter(boundColumn);
        jdbcParameterBindings.addBinding(jdbcParameter, new LiteralParameter(jdbcValue, type, Clause.DELETE, session.getFactory().getTypeConfiguration()));
    }

    private JdbcParameter resolveJdbcParameter(Column boundColumn) {
        JdbcParameter jdbcParameter = this.jdbcParameterMap.get(boundColumn);
        if (jdbcParameter == null) {
            throw new IllegalStateException("JdbcParameter not found for Column [" + boundColumn + "]");
        }
        return jdbcParameter;
    }
}

