/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.collection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.CollectionDomainType;
import org.hibernate.metamodel.model.domain.internal.collection.CollectionRowsUpdateExecutor;
import org.hibernate.metamodel.model.domain.spi.CollectionIdentifier;
import org.hibernate.metamodel.model.domain.spi.CollectionIndex;
import org.hibernate.metamodel.model.domain.spi.CollectionKey;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.query.spi.ComparisonOperator;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.consume.spi.UpdateToJdbcUpdateConverter;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.LiteralParameter;
import org.hibernate.sql.ast.tree.expression.PositionalParameter;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.internal.LoadParameterBindingContext;
import org.hibernate.sql.exec.spi.BasicExecutionContext;
import org.hibernate.sql.exec.spi.JdbcMutationExecutor;
import org.hibernate.sql.exec.spi.JdbcParameter;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcUpdate;
import org.jboss.logging.Logger;

public class JoinTableRowsUpdateExecutor
implements CollectionRowsUpdateExecutor {
    private static final Logger LOG = Logger.getLogger(JoinTableRowsUpdateExecutor.class);
    private final PersistentCollectionDescriptor collectionDescriptor;
    private final Map<Column, JdbcParameter> jdbcParameterMap;
    private final JdbcUpdate jdbcUpdate;

    public JoinTableRowsUpdateExecutor(PersistentCollectionDescriptor collectionDescriptor, Table dmlTargetTable, boolean hasIndex, boolean indexContainsFormula, SessionFactoryImplementor sessionFactory) {
        this.collectionDescriptor = collectionDescriptor;
        this.jdbcParameterMap = new HashMap<Column, JdbcParameter>();
        TableReference tableReference = new TableReference(dmlTargetTable, null, false);
        this.jdbcUpdate = this.generateUpdateOperation(tableReference, this.jdbcParameterMap::put, hasIndex, indexContainsFormula, sessionFactory);
    }

    @Override
    public void execute(PersistentCollection collection, Object key, SharedSessionContractImplementor session) {
        LOG.infof("Updating rows of collection: %s#%s", (Object)this.collectionDescriptor.getNavigableRole().getFullPath(), key);
        ArrayList elements = new ArrayList();
        Iterator entries = collection.entries(this.collectionDescriptor);
        while (entries.hasNext()) {
            elements.add(entries.next());
        }
        BasicExecutionContext executionContext = new BasicExecutionContext(session, new LoadParameterBindingContext((SessionFactoryImplementor)session.getSessionFactory(), key));
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl();
        int count = 0;
        if (collection.isElementRemoved()) {
            for (int i = elements.size() - 1; i >= 0; --i) {
                Object entry = elements.get(i);
                if (!collection.needsUpdating(entry, i)) continue;
                this.bindCollectionKey(key, jdbcParameterBindings, session);
                this.bindCollectionId(entry, collection, jdbcParameterBindings, session);
                this.bindCollectionIndex(entry, collection, i, jdbcParameterBindings, session);
                this.bindCollectionElement(entry, collection, jdbcParameterBindings, session);
                JdbcMutationExecutor.WITH_AFTER_STATEMENT_CALL.execute(this.jdbcUpdate, jdbcParameterBindings, executionContext);
                jdbcParameterBindings.clear();
                ++count;
            }
        } else {
            for (int i = 0; i < elements.size(); ++i) {
                Object entry = elements.get(i);
                if (!collection.needsUpdating(entry, i)) continue;
                this.bindCollectionKey(key, jdbcParameterBindings, session);
                this.bindCollectionId(entry, collection, jdbcParameterBindings, session);
                this.bindCollectionIndex(entry, collection, i, jdbcParameterBindings, session);
                this.bindCollectionElement(entry, collection, jdbcParameterBindings, session);
                JdbcMutationExecutor.WITH_AFTER_STATEMENT_CALL.execute(this.jdbcUpdate, jdbcParameterBindings, executionContext);
                jdbcParameterBindings.clear();
                ++count;
            }
        }
        LOG.infof("Done updating rows: %s updated", (Object)count);
    }

    protected void bindCollectionId(Object entry, PersistentCollection collection, JdbcParameterBindings jdbcParameterBindings, SharedSessionContractImplementor session) {
        if (this.collectionDescriptor.getIdDescriptor() != null) {
            throw new NotYetImplementedFor6Exception();
        }
    }

    protected void bindCollectionKey(Object key, JdbcParameterBindings jdbcParameterBindings, SharedSessionContractImplementor session) {
        this.collectionDescriptor.getCollectionKeyDescriptor().dehydrate(this.collectionDescriptor.getCollectionKeyDescriptor().unresolve(key, session), (jdbcValue, type, boundColumn) -> this.createBinding(jdbcValue, boundColumn, type, jdbcParameterBindings, session, Clause.UPDATE), Clause.UPDATE, session);
    }

    protected void bindCollectionIndex(Object entry, PersistentCollection<?> collection, int assumedIndex, JdbcParameterBindings jdbcParameterBinding, SharedSessionContractImplementor session) {
        CollectionIndex indexDescriptor = this.collectionDescriptor.getIndexDescriptor();
        if (indexDescriptor != null) {
            Object index = collection.getIndex(entry, assumedIndex, this.collectionDescriptor);
            if (indexDescriptor.getBaseIndex() != 0) {
                index = (Integer)index + indexDescriptor.getBaseIndex();
            }
            indexDescriptor.dehydrate(indexDescriptor.unresolve(index, session), (jdbcValue, type, boundColumn) -> this.createBinding(jdbcValue, boundColumn, type, jdbcParameterBinding, session, Clause.UPDATE), Clause.UPDATE, session);
        }
    }

    protected void bindCollectionElement(Object entry, PersistentCollection collection, JdbcParameterBindings jdbcParameterBinding, SharedSessionContractImplementor session) {
        Object element = collection.getElement(entry, this.collectionDescriptor);
        this.collectionDescriptor.getElementDescriptor().dehydrate(this.collectionDescriptor.getElementDescriptor().unresolve(element, session), (jdbcValue, type, boundColumn) -> this.createBinding(jdbcValue, boundColumn, type, jdbcParameterBinding, session, Clause.UPDATE), Clause.UPDATE, session);
    }

    protected JdbcUpdate generateUpdateOperation(TableReference collectionTableRef, BiConsumer<Column, JdbcParameter> columnCollector, boolean hasIndex, boolean indexContainsFormula, SessionFactoryImplementor sessionFactory) {
        AtomicInteger parameterCount = new AtomicInteger();
        ArrayList<Assignment> assignments = new ArrayList<Assignment>();
        CollectionDomainType.Element element = this.collectionDescriptor.getElementDescriptor();
        element.visitColumns((sqlExpressableType, column) -> {
            ColumnReference columnReference = collectionTableRef.resolveColumnReference((Column)column);
            PositionalParameter parameter = new PositionalParameter(parameterCount.getAndIncrement(), column.getExpressableType(), Clause.UPDATE, sessionFactory.getTypeConfiguration());
            columnCollector.accept((Column)column, parameter);
            assignments.add(new Assignment(columnReference, parameter));
        }, Clause.UPDATE, sessionFactory.getTypeConfiguration());
        Junction junction = new Junction(Junction.Nature.CONJUNCTION);
        if (this.collectionDescriptor.getIdDescriptor() != null) {
            CollectionIdentifier identifier = this.collectionDescriptor.getIdDescriptor();
            identifier.visitColumns((sqlExpressableType, column) -> {
                ColumnReference columnReference = collectionTableRef.resolveColumnReference((Column)column);
                PositionalParameter parameter = new PositionalParameter(parameterCount.getAndIncrement(), column.getExpressableType(), Clause.WHERE, sessionFactory.getTypeConfiguration());
                columnCollector.accept((Column)column, parameter);
                junction.add(new ComparisonPredicate(columnReference, ComparisonOperator.EQUAL, parameter));
            }, Clause.WHERE, sessionFactory.getTypeConfiguration());
        } else if (hasIndex && !indexContainsFormula) {
            CollectionIndex index = this.collectionDescriptor.getIndexDescriptor();
            index.visitColumns((sqlExpressableType, column) -> {
                ColumnReference columnReference = collectionTableRef.resolveColumnReference((Column)column);
                PositionalParameter parameter = new PositionalParameter(parameterCount.getAndIncrement(), column.getExpressableType(), Clause.WHERE, sessionFactory.getTypeConfiguration());
                columnCollector.accept((Column)column, parameter);
                junction.add(new ComparisonPredicate(columnReference, ComparisonOperator.EQUAL, parameter));
            }, Clause.WHERE, sessionFactory.getTypeConfiguration());
            CollectionKey key = this.collectionDescriptor.getCollectionKeyDescriptor();
            key.visitColumns((sqlExpressableType, column) -> {
                ColumnReference columnReference = collectionTableRef.resolveColumnReference((Column)column);
                PositionalParameter parameter = new PositionalParameter(parameterCount.getAndIncrement(), column.getExpressableType(), Clause.WHERE, sessionFactory.getTypeConfiguration());
                columnCollector.accept((Column)column, parameter);
                junction.add(new ComparisonPredicate(columnReference, ComparisonOperator.EQUAL, parameter));
            }, Clause.WHERE, sessionFactory.getTypeConfiguration());
        } else {
            CollectionKey key = this.collectionDescriptor.getCollectionKeyDescriptor();
            key.visitColumns((sqlExpressableType, column) -> {
                ColumnReference columnReference = collectionTableRef.resolveColumnReference((Column)column);
                PositionalParameter parameter = new PositionalParameter(parameterCount.getAndIncrement(), column.getExpressableType(), Clause.WHERE, sessionFactory.getTypeConfiguration());
                columnCollector.accept((Column)column, parameter);
                junction.add(new ComparisonPredicate(columnReference, ComparisonOperator.EQUAL, parameter));
            }, Clause.WHERE, sessionFactory.getTypeConfiguration());
        }
        return UpdateToJdbcUpdateConverter.createJdbcUpdate(new UpdateStatement(collectionTableRef, assignments, junction), sessionFactory);
    }

    private void createBinding(Object jdbcValue, Column boundColumn, SqlExpressableType sqlExpressableType, JdbcParameterBindings jdbcParameterBindings, SharedSessionContractImplementor session, Clause clause) {
        JdbcParameter jdbcParameter = this.resolveJdbcParameter(boundColumn);
        jdbcParameterBindings.addBinding(jdbcParameter, new LiteralParameter(jdbcValue, sqlExpressableType, clause, session.getFactory().getTypeConfiguration()));
    }

    private JdbcParameter resolveJdbcParameter(Column boundColumn) {
        JdbcParameter jdbcParameter = this.jdbcParameterMap.get(boundColumn);
        if (jdbcParameter == null) {
            throw new IllegalStateException("JdbcParameter not found for Column [" + boundColumn + "]");
        }
        return jdbcParameter;
    }
}

