/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.collection;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.internal.collection.AbstractCreationExecutor;
import org.hibernate.metamodel.model.domain.spi.CollectionIndex;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.query.spi.ComparisonOperator;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.consume.spi.UpdateToJdbcUpdateConverter;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.LiteralParameter;
import org.hibernate.sql.ast.tree.expression.PositionalParameter;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.JdbcMutation;
import org.hibernate.sql.exec.spi.JdbcParameter;

public class OneToManyCreationExecutor
extends AbstractCreationExecutor {
    public OneToManyCreationExecutor(PersistentCollectionDescriptor collectionDescriptor, Table dmlTargetTable, SessionFactoryImplementor sessionFactory) {
        super(collectionDescriptor, dmlTargetTable, sessionFactory);
    }

    @Override
    protected JdbcMutation generateCreationOperation(TableReference dmlTableRef, SessionFactoryImplementor sessionFactory, BiConsumer<Column, JdbcParameter> columnConsumer) {
        ArrayList<Assignment> assignments = new ArrayList<Assignment>();
        AtomicInteger parameterCount = new AtomicInteger();
        this.applyNavigable(this.getCollectionDescriptor().getCollectionKeyDescriptor(), dmlTableRef, parameterCount, columnConsumer, assignments, sessionFactory);
        if (this.getCollectionDescriptor().getIndexDescriptor() != null) {
            this.applyNavigable(this.getCollectionDescriptor().getIndexDescriptor(), dmlTableRef, parameterCount, columnConsumer, assignments, sessionFactory);
        }
        Predicate predicate = this.resolvePredicate((Navigable<?>)((Object)this.getCollectionDescriptor().getElementDescriptor()), dmlTableRef, parameterCount, columnConsumer, sessionFactory);
        UpdateStatement updateStatement = new UpdateStatement(dmlTableRef, assignments, predicate);
        return UpdateToJdbcUpdateConverter.createJdbcUpdate(updateStatement, sessionFactory);
    }

    protected void applyNavigable(Navigable navigable, TableReference dmlTableRef, AtomicInteger parameterCount, BiConsumer<Column, JdbcParameter> columnConsumer, List<Assignment> assignments, SessionFactoryImplementor sessionFactory) {
        navigable.visitColumns((sqlExpressableType, column) -> {
            ColumnReference columnReference = dmlTableRef.resolveColumnReference((Column)column);
            PositionalParameter parameter = new PositionalParameter(parameterCount.getAndIncrement(), column.getExpressableType(), Clause.INSERT, sessionFactory.getTypeConfiguration());
            Assignment assignment = new Assignment(columnReference, parameter);
            assignments.add(assignment);
            columnConsumer.accept((Column)column, parameter);
        }, Clause.UPDATE, sessionFactory.getTypeConfiguration());
    }

    private Predicate resolvePredicate(Navigable<?> navigable, TableReference dmltableRef, AtomicInteger parameterCount, BiConsumer<Column, JdbcParameter> columnConsumer, SessionFactoryImplementor sessionFactory) {
        Junction junction = new Junction(Junction.Nature.CONJUNCTION);
        navigable.visitColumns((sqlExpressableType, column) -> {
            PositionalParameter parameter = new PositionalParameter(parameterCount.getAndIncrement(), column.getExpressableType(), Clause.UPDATE, sessionFactory.getTypeConfiguration());
            columnConsumer.accept((Column)column, parameter);
            junction.add(new ComparisonPredicate(new ColumnReference((Column)column), ComparisonOperator.EQUAL, parameter));
        }, Clause.WHERE, sessionFactory.getTypeConfiguration());
        return junction;
    }

    @Override
    protected void createBinding(Object jdbcValue, Column boundColumn, SqlExpressableType type, JdbcParameterBindingsImpl jdbcParameterBindings, SharedSessionContractImplementor session) {
        JdbcParameter jdbcParameter = this.resolveJdbcParameter(boundColumn);
        jdbcParameterBindings.addBinding(jdbcParameter, new LiteralParameter(jdbcValue, type, Clause.UPDATE, session.getFactory().getTypeConfiguration()));
    }

    @Override
    protected void bindCollectionElement(Object entry, PersistentCollection collection, JdbcParameterBindingsImpl jdbcParameterBindings, SharedSessionContractImplementor session) {
        Object element = collection.getElement(entry, this.getCollectionDescriptor());
        this.getCollectionDescriptor().getElementDescriptor().dehydrate(this.getCollectionDescriptor().getElementDescriptor().unresolve(element, session), (jdbcValue, type, boundColumn) -> this.createBinding(jdbcValue, boundColumn, type, jdbcParameterBindings, session), Clause.WHERE, session);
    }

    @Override
    protected void bindCollectionId(Object entry, int assumedIdentifier, PersistentCollection collection, JdbcParameterBindingsImpl jdbcParameterBindings, SharedSessionContractImplementor session) {
        if (this.getCollectionDescriptor().getIdDescriptor() != null) {
            Object id = collection.getIdentifier(entry, assumedIdentifier, this.getCollectionDescriptor());
            this.getCollectionDescriptor().getIdDescriptor().dehydrate(this.getCollectionDescriptor().getIdDescriptor().unresolve(id, session), (jdbcValue, type, boundColumn) -> this.createBinding(jdbcValue, boundColumn, type, jdbcParameterBindings, session), Clause.UPDATE, session);
        }
    }

    @Override
    protected void bindCollectionIndex(Object entry, int assumedIndex, PersistentCollection collection, JdbcParameterBindingsImpl jdbcParameterBindings, SharedSessionContractImplementor session) {
        CollectionIndex indexDescriptor = this.getCollectionDescriptor().getIndexDescriptor();
        if (indexDescriptor != null) {
            Object index = collection.getIndex(entry, assumedIndex, this.getCollectionDescriptor());
            if (indexDescriptor.getBaseIndex() != 0) {
                index = (Integer)index + indexDescriptor.getBaseIndex();
            }
            indexDescriptor.dehydrate(indexDescriptor.unresolve(index, session), (jdbcValue, type, boundColumn) -> this.createBinding(jdbcValue, boundColumn, type, jdbcParameterBindings, session), Clause.UPDATE, session);
        }
    }

    @Override
    protected void bindCollectionKey(Object key, JdbcParameterBindingsImpl jdbcParameterBindings, SharedSessionContractImplementor session) {
        this.getCollectionDescriptor().getCollectionKeyDescriptor().dehydrate(this.getCollectionDescriptor().getCollectionKeyDescriptor().unresolve(key, session), (jdbcValue, type, boundColumn) -> this.createBinding(jdbcValue, boundColumn, type, jdbcParameterBindings, session), Clause.UPDATE, session);
    }
}

