/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal.collection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.internal.collection.CollectionRemovalExecutor;
import org.hibernate.metamodel.model.domain.spi.CollectionIndex;
import org.hibernate.metamodel.model.domain.spi.CollectionKey;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.query.spi.ComparisonOperator;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.consume.spi.UpdateToJdbcUpdateConverter;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.LiteralParameter;
import org.hibernate.sql.ast.tree.expression.PositionalParameter;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.BasicExecutionContext;
import org.hibernate.sql.exec.spi.JdbcMutation;
import org.hibernate.sql.exec.spi.JdbcMutationExecutor;
import org.hibernate.sql.exec.spi.JdbcParameter;

public class OneToManyRemovalExecutor
implements CollectionRemovalExecutor {
    private final PersistentCollectionDescriptor collectionDescriptor;
    private final Map<Column, JdbcParameter> jdbcParametersMap;
    private final JdbcMutation updateMutation;

    public OneToManyRemovalExecutor(PersistentCollectionDescriptor collectionDescriptor, Table dmlTargetTable, SessionFactoryImplementor sessionFactory) {
        this.collectionDescriptor = collectionDescriptor;
        this.jdbcParametersMap = new HashMap<Column, JdbcParameter>();
        UpdateStatement updateStatement = this.generateUpdateStatement(new TableReference(dmlTargetTable, null, false), this.jdbcParametersMap::put, collectionDescriptor, sessionFactory);
        this.updateMutation = UpdateToJdbcUpdateConverter.createJdbcUpdate(updateStatement, sessionFactory);
    }

    @Override
    public void execute(Object key, SharedSessionContractImplementor session) {
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl();
        BasicExecutionContext executionContext = new BasicExecutionContext(session);
        this.collectionDescriptor.getCollectionKeyDescriptor().dehydrate(this.collectionDescriptor.getCollectionKeyDescriptor().unresolve(key, session), (jdbcValue, type, boundColumn) -> this.createBinding(jdbcValue, boundColumn, type, jdbcParameterBindings, session), Clause.WHERE, session);
        JdbcMutationExecutor.WITH_AFTER_STATEMENT_CALL.execute(this.updateMutation, jdbcParameterBindings, executionContext);
    }

    private void createBinding(Object jdbcValue, Column boundColumn, SqlExpressableType type, JdbcParameterBindingsImpl jdbcParameterBindings, SharedSessionContractImplementor session) {
        JdbcParameter jdbcParameter = this.resolveJdbcParmeter(boundColumn);
        jdbcParameterBindings.addBinding(jdbcParameter, new LiteralParameter(jdbcValue, type, Clause.UPDATE, session.getFactory().getTypeConfiguration()));
    }

    private JdbcParameter resolveJdbcParmeter(Column boundColumn) {
        JdbcParameter jdbcParameter = this.jdbcParametersMap.get(boundColumn);
        if (jdbcParameter == null) {
            throw new IllegalStateException("JdbcParameter not found for Column [" + boundColumn + "]");
        }
        return jdbcParameter;
    }

    private UpdateStatement generateUpdateStatement(TableReference dmlTableRef, BiConsumer<Column, JdbcParameter> columnConsumer, PersistentCollectionDescriptor collectionDescriptor, SessionFactoryImplementor sessionFactory) {
        ArrayList<Assignment> assignments = new ArrayList<Assignment>();
        AtomicInteger parameterCount = new AtomicInteger();
        CollectionKey collectionKey = collectionDescriptor.getCollectionKeyDescriptor();
        collectionKey.visitColumns((sqlExpressableType, column) -> {
            ColumnReference columnReference = dmlTableRef.resolveColumnReference((Column)column);
            LiteralParameter parameter = new LiteralParameter(null, column.getExpressableType(), Clause.UPDATE, sessionFactory.getTypeConfiguration());
            Assignment assignment = new Assignment(columnReference, parameter);
            assignments.add(assignment);
        }, Clause.UPDATE, sessionFactory.getTypeConfiguration());
        if (collectionDescriptor.getIndexDescriptor() != null) {
            CollectionIndex collectionIndex = collectionDescriptor.getIndexDescriptor();
            collectionIndex.visitColumns((sqlExpressableType, column) -> {
                if (column.isUpdatable()) {
                    ColumnReference columnReference = dmlTableRef.resolveColumnReference((Column)column);
                    LiteralParameter parameter = new LiteralParameter(null, column.getExpressableType(), Clause.UPDATE, sessionFactory.getTypeConfiguration());
                    Assignment assignment = new Assignment(columnReference, parameter);
                    assignments.add(assignment);
                }
            }, Clause.UPDATE, sessionFactory.getTypeConfiguration());
        }
        Junction junction = new Junction(Junction.Nature.CONJUNCTION);
        collectionKey.visitColumns((sqlExpressableType, column) -> {
            PositionalParameter parameter = new PositionalParameter(parameterCount.getAndIncrement(), column.getExpressableType(), Clause.UPDATE, sessionFactory.getTypeConfiguration());
            columnConsumer.accept((Column)column, parameter);
            junction.add(new ComparisonPredicate(new ColumnReference((Column)column), ComparisonOperator.EQUAL, parameter));
        }, Clause.UPDATE, sessionFactory.getTypeConfiguration());
        return new UpdateStatement(dmlTableRef, assignments, junction);
    }
}

